/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.android.model;

import com.malinskiy.marathon.android.model.AndroidTestResult;
import com.malinskiy.marathon.android.model.AndroidTestStatus;
import com.malinskiy.marathon.android.model.TestIdentifier;
import com.malinskiy.marathon.android.model.TestRunResultsAccumulator;
import com.malinskiy.marathon.log.MarathonLogging;
import com.malinskiy.marathon.time.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0018\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u000202H\u0002J\b\u0010:\u001a\u000207H\u0002J\u000e\u0010;\u001a\u00020\u001f2\u0006\u0010<\u001a\u00020/J\u0006\u0010=\u001a\u00020\u0010J\u0016\u0010>\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u001aJ*\u0010@\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u000b2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0.J\"\u0010@\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0.J\u0016\u0010C\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u001aJ\u000e\u0010D\u001a\u0002072\u0006\u00108\u001a\u00020\u0007J\"\u0010E\u001a\u0002072\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0.J\u000e\u0010F\u001a\u0002072\u0006\u0010G\u001a\u00020\u001aJ\u0016\u0010H\u001a\u0002072\u0006\u0010I\u001a\u00020\u001a2\u0006\u0010J\u001a\u00020\u001fJ\u000e\u0010K\u001a\u0002072\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010L\u001a\u0002072\u0006\u00108\u001a\u00020\u0007J\u0016\u0010L\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u000bJ\"\u0010N\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u0010<\u001a\u00020/2\b\u0010?\u001a\u0004\u0018\u00010\u001aH\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010!R\u0011\u0010$\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010!R\"\u0010&\u001a\u0004\u0018\u00010\u001a2\b\u0010\n\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u001dR-\u0010(\u001a\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0)j\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a`*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u001f0.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u00100\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020201j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u000202`3\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/malinskiy/marathon/android/model/TestRunResultsAccumulator;", "", "timer", "Lcom/malinskiy/marathon/time/Timer;", "(Lcom/malinskiy/marathon/time/Timer;)V", "completedTests", "", "Lcom/malinskiy/marathon/android/model/TestIdentifier;", "getCompletedTests", "()Ljava/util/Set;", "<set-?>", "", "elapsedTime", "getElapsedTime", "()J", "isCountDirty", "", "isRunComplete", "()Z", "setRunComplete", "(Z)V", "isRunFailure", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "", "name", "getName", "()Ljava/lang/String;", "numAllFailedTests", "", "getNumAllFailedTests", "()I", "numCompleteTests", "getNumCompleteTests", "numTests", "getNumTests", "runFailureMessage", "getRunFailureMessage", "runMetrics", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "getRunMetrics", "()Ljava/util/HashMap;", "statusCounts", "", "Lcom/malinskiy/marathon/android/model/AndroidTestStatus;", "testResults", "Ljava/util/LinkedHashMap;", "Lcom/malinskiy/marathon/android/model/AndroidTestResult;", "Lkotlin/collections/LinkedHashMap;", "getTestResults", "()Ljava/util/LinkedHashMap;", "addTestResult", "", "test", "testResult", "fillEndTime", "getNumTestsInState", "status", "hasFailedTests", "testAssumptionFailure", "trace", "testEnded", "endTime", "testMetrics", "testFailed", "testIgnored", "testRunEnded", "testRunFailed", "errorMessage", "testRunStarted", "runName", "testCount", "testRunStopped", "testStarted", "startTime", "updateTestResult", "base"})
public final class TestRunResultsAccumulator {
    @NotNull
    private final KLogger logger;
    @NotNull
    private String name;
    @NotNull
    private final LinkedHashMap<TestIdentifier, AndroidTestResult> testResults;
    @NotNull
    private final HashMap<String, String> runMetrics;
    private boolean isRunComplete;
    private boolean isCountDirty;
    private long elapsedTime;
    private Map<AndroidTestStatus, Integer> statusCounts;
    @Nullable
    private String runFailureMessage;
    private final Timer timer;

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final LinkedHashMap<TestIdentifier, AndroidTestResult> getTestResults() {
        return this.testResults;
    }

    @NotNull
    public final HashMap<String, String> getRunMetrics() {
        return this.runMetrics;
    }

    public final boolean isRunComplete() {
        return this.isRunComplete;
    }

    public final void setRunComplete(boolean bl) {
        this.isRunComplete = bl;
    }

    public final long getElapsedTime() {
        return this.elapsedTime;
    }

    @Nullable
    public final String getRunFailureMessage() {
        return this.runFailureMessage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TestIdentifier> getCompletedTests() {
        LinkedHashSet<void> completedTests = new LinkedHashSet<void>();
        Object object = this.testResults;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (TestIdentifier)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            AndroidTestResult value = (AndroidTestResult)entry2.getValue();
            if (value.getStatus() == AndroidTestStatus.INCOMPLETE) continue;
            completedTests.add(key);
        }
        return completedTests;
    }

    public final boolean isRunFailure() {
        return this.runFailureMessage != null;
    }

    public final int getNumTests() {
        return this.testResults.size();
    }

    public final int getNumCompleteTests() {
        return this.getNumTests() - this.getNumTestsInState(AndroidTestStatus.INCOMPLETE);
    }

    public final int getNumAllFailedTests() {
        return this.getNumTestsInState(AndroidTestStatus.FAILURE) + this.getNumTestsInState(AndroidTestStatus.ASSUMPTION_FAILURE);
    }

    public final int getNumTestsInState(@NotNull AndroidTestStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        if (this.isCountDirty) {
            Collection<AndroidTestResult> collection = this.testResults.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"testResults.values");
            Iterable $this$groupingBy$iv = collection;
            boolean $i$f$groupingBy = false;
            this.statusCounts = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<AndroidTestResult, AndroidTestStatus>($this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<AndroidTestResult> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object keyOf(Object element) {
                    AndroidTestResult it = (AndroidTestResult)element;
                    boolean bl = false;
                    return it.getStatus();
                }
            }));
        }
        Integer n = this.statusCounts.get((Object)status);
        return n != null ? n : 0;
    }

    public final boolean hasFailedTests() {
        return this.getNumAllFailedTests() > 0;
    }

    public final void testRunStarted(@NotNull String runName, int testCount) {
        Intrinsics.checkNotNullParameter((Object)runName, (String)"runName");
        this.name = runName;
        this.isRunComplete = false;
        this.runFailureMessage = null;
    }

    public final void testStarted(@NotNull TestIdentifier test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        this.testStarted(test, this.timer.currentTimeMillis());
    }

    public final void testStarted(@NotNull TestIdentifier test, long startTime) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        AndroidTestResult res = new AndroidTestResult(null, 0L, 0L, null, null, 31, null);
        res.setStartTime(startTime);
        this.addTestResult(test, res);
    }

    private final void addTestResult(TestIdentifier test, AndroidTestResult testResult) {
        this.isCountDirty = true;
        ((Map)this.testResults).put(test, testResult);
    }

    private final void updateTestResult(TestIdentifier test, AndroidTestStatus status, String trace) {
        AndroidTestResult r = this.testResults.get(test);
        if (r == null) {
            this.logger.debug((Function0)new Function0<Object>(test){
                final /* synthetic */ TestIdentifier $test;

                @Nullable
                public final Object invoke() {
                    return "received test event without test start for " + this.$test.getClassName() + '#' + this.$test.getTestName();
                }
                {
                    this.$test = testIdentifier;
                    super(0);
                }
            });
            r = new AndroidTestResult(null, this.timer.currentTimeMillis(), 0L, null, null, 29, null);
        }
        r.setStatus(status);
        r.setStackTrace(trace);
        this.addTestResult(test, r);
    }

    public final void testFailed(@NotNull TestIdentifier test, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.updateTestResult(test, AndroidTestStatus.FAILURE, trace);
    }

    public final void testAssumptionFailure(@NotNull TestIdentifier test, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.updateTestResult(test, AndroidTestStatus.ASSUMPTION_FAILURE, trace);
    }

    public final void testIgnored(@NotNull TestIdentifier test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        this.updateTestResult(test, AndroidTestStatus.IGNORED, null);
    }

    public final void testEnded(@NotNull TestIdentifier test, @NotNull Map<String, String> testMetrics) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        Intrinsics.checkNotNullParameter(testMetrics, (String)"testMetrics");
        this.testEnded(test, this.timer.currentTimeMillis(), testMetrics);
    }

    public final void testEnded(@NotNull TestIdentifier test, long endTime, @NotNull Map<String, String> testMetrics) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        Intrinsics.checkNotNullParameter(testMetrics, (String)"testMetrics");
        AndroidTestResult result = this.testResults.get(test);
        if (result == null) {
            result = new AndroidTestResult(null, this.timer.currentTimeMillis(), 0L, null, null, 29, null);
        }
        if (result.getStatus() == AndroidTestStatus.INCOMPLETE) {
            result.setStatus(AndroidTestStatus.PASSED);
        }
        result.setEndTime(endTime);
        result.setMetrics(testMetrics);
        this.addTestResult(test, result);
    }

    public final void testRunFailed(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this.runFailureMessage = errorMessage;
        this.fillEndTime();
    }

    /*
     * WARNING - void declaration
     */
    private final void fillEndTime() {
        void $this$filterTo$iv$iv;
        Collection<AndroidTestResult> collection = this.testResults.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"testResults.values");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AndroidTestResult it = (AndroidTestResult)element$iv$iv;
            boolean bl = false;
            if (!(it.getEndTime() == 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidTestResult it = (AndroidTestResult)element$iv;
            boolean bl = false;
            it.setEndTime(this.timer.currentTimeMillis());
        }
    }

    public final void testRunStopped(long elapsedTime) {
        this.elapsedTime += elapsedTime;
        this.isRunComplete = true;
        this.fillEndTime();
    }

    public final void testRunEnded(long elapsedTime, @NotNull Map<String, String> runMetrics) {
        Intrinsics.checkNotNullParameter(runMetrics, (String)"runMetrics");
        this.runMetrics.putAll(runMetrics);
        this.elapsedTime += elapsedTime;
        this.isRunComplete = true;
        this.fillEndTime();
    }

    public TestRunResultsAccumulator(@NotNull Timer timer) {
        Intrinsics.checkNotNullParameter((Object)timer, (String)"timer");
        this.timer = timer;
        this.logger = MarathonLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.name = "not started";
        this.testResults = new LinkedHashMap();
        this.runMetrics = new HashMap();
        boolean bl = false;
        this.statusCounts = new LinkedHashMap();
    }
}

