/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config;

import com.malinskiy.marathon.config.Configuration;
import com.malinskiy.marathon.config.ConfigurationValidator;
import com.malinskiy.marathon.config.TestFilterConfiguration;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import com.malinskiy.marathon.config.strategy.ExecutionMode;
import com.malinskiy.marathon.config.strategy.FlakinessStrategyConfiguration;
import com.malinskiy.marathon.config.strategy.RetryStrategyConfiguration;
import com.malinskiy.marathon.config.strategy.ShardingStrategyConfiguration;
import com.malinskiy.marathon.config.vendor.VendorConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/malinskiy/marathon/config/LogicalConfigurationValidator;", "Lcom/malinskiy/marathon/config/ConfigurationValidator;", "()V", "validate", "", "configuration", "Lcom/malinskiy/marathon/config/Configuration;"})
@SourceDebugExtension(value={"SMAP\nLogicalConfigurationValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalConfigurationValidator.kt\ncom/malinskiy/marathon/config/LogicalConfigurationValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1855#2,2:66\n1855#2,2:68\n*S KotlinDebug\n*F\n+ 1 LogicalConfigurationValidator.kt\ncom/malinskiy/marathon/config/LogicalConfigurationValidator\n*L\n23#1:66,2\n24#1:68,2\n*E\n"})
public final class LogicalConfigurationValidator
implements ConfigurationValidator {
    @Override
    public void validate(@NotNull Configuration configuration) {
        TestFilterConfiguration it;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (!(configuration.getFlakinessStrategy() instanceof FlakinessStrategyConfiguration.IgnoreFlakinessStrategyConfiguration) && !(configuration.getShardingStrategy() instanceof ShardingStrategyConfiguration.ParallelShardingStrategyConfiguration)) {
            throw new ConfigurationException("Configuration is invalid: can't use complex sharding and complex flakiness strategy at the same time. See: https://github.com/MarathonLabs/marathon/issues/197");
        }
        Iterable $this$forEach$iv = configuration.getFilteringConfiguration().getAllowlist();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TestFilterConfiguration)element$iv;
            boolean bl = false;
            it.validate();
        }
        $this$forEach$iv = configuration.getFilteringConfiguration().getBlocklist();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (TestFilterConfiguration)element$iv;
            boolean bl = false;
            it.validate();
        }
        VendorConfiguration vendorConfiguration = configuration.getVendorConfiguration();
        if (vendorConfiguration instanceof VendorConfiguration.IOSConfiguration) {
            ((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration()).validate();
        } else if (vendorConfiguration instanceof VendorConfiguration.AndroidConfiguration) {
            ((VendorConfiguration.AndroidConfiguration)configuration.getVendorConfiguration()).validate();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[configuration.getExecutionStrategy().getMode().ordinal()]) {
            case 1: {
                if (!(configuration.getShardingStrategy() instanceof ShardingStrategyConfiguration.CountShardingStrategyConfiguration) || ((ShardingStrategyConfiguration.CountShardingStrategyConfiguration)configuration.getShardingStrategy()).getCount() == 1) break;
                throw new ConfigurationException("Configuration is invalid: can't use complex sharding and any success execution strategy at the same time. Consult documentation for the any success execution logic");
            }
            case 2: {
                if (!(configuration.getFlakinessStrategy() instanceof FlakinessStrategyConfiguration.IgnoreFlakinessStrategyConfiguration)) {
                    throw new ConfigurationException("Configuration is invalid: can't use complex flakiness strategy and all success execution strategy at the same time. Consult documentation for the all success execution logic");
                }
                if (configuration.getRetryStrategy() instanceof RetryStrategyConfiguration.NoRetryStrategyConfiguration) break;
                throw new ConfigurationException("Configuration is invalid: can't use complex retry strategy and all success execution strategy at the same time. Consult documentation for the all success execution logic");
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExecutionMode.values().length];
            try {
                nArray[ExecutionMode.ANY_SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExecutionMode.ALL_SUCCESS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

