/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AnnotationDataFilterConfiguration.class, name="annotationData"), @JsonSubTypes.Type(value=AnnotationFilterConfiguration.class, name="annotation"), @JsonSubTypes.Type(value=CompositionFilterConfiguration.class, name="composition"), @JsonSubTypes.Type(value=FragmentationFilterConfiguration.class, name="fragmentation"), @JsonSubTypes.Type(value=FullyQualifiedClassnameFilterConfiguration.class, name="fully-qualified-class-name"), @JsonSubTypes.Type(value=FullyQualifiedTestnameFilterConfiguration.class, name="fully-qualified-test-name"), @JsonSubTypes.Type(value=SimpleTestnameFilterConfiguration.class, name="simple-test-name"), @JsonSubTypes.Type(value=SimpleClassnameFilterConfiguration.class, name="simple-class-name"), @JsonSubTypes.Type(value=TestMethodFilterConfiguration.class, name="method"), @JsonSubTypes.Type(value=TestPackageFilterConfiguration.class, name="package"), @JsonSubTypes.Type(value=AllureFilterConfiguration.class, name="allure")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u000b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH&R\u0016\u0010\u0003\u001a\u00020\u00048\u0016X\u0097D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u000b\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "", "()V", "enabled", "", "getEnabled", "()Z", "validate", "", "AllureFilterConfiguration", "AnnotationDataFilterConfiguration", "AnnotationFilterConfiguration", "CompositionFilterConfiguration", "FragmentationFilterConfiguration", "FullyQualifiedClassnameFilterConfiguration", "FullyQualifiedTestnameFilterConfiguration", "SimpleClassnameFilterConfiguration", "SimpleTestnameFilterConfiguration", "TestMethodFilterConfiguration", "TestPackageFilterConfiguration", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$AllureFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationDataFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$FragmentationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedTestnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$SimpleClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$SimpleTestnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestMethodFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestPackageFilterConfiguration;", "configuration"})
public abstract class TestFilterConfiguration {
    @JsonProperty(value="enabled")
    private final boolean enabled;

    private TestFilterConfiguration() {
        this.enabled = true;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public abstract void validate();

    public /* synthetic */ TestFilterConfiguration(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$AllureFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "enabled", "", "(Z)V", "getEnabled", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "validate", "", "configuration"})
    public static final class AllureFilterConfiguration
    extends TestFilterConfiguration {
        private final boolean enabled;

        public AllureFilterConfiguration(@JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.enabled = enabled;
        }

        public /* synthetic */ AllureFilterConfiguration(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = true;
            }
            this(bl);
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
        }

        public boolean equals(@Nullable Object other) {
            return super.equals(other);
        }

        public int hashCode() {
            return super.hashCode();
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final AllureFilterConfiguration copy(@JsonProperty(value="enabled") boolean enabled) {
            return new AllureFilterConfiguration(enabled);
        }

        public static /* synthetic */ AllureFilterConfiguration copy$default(AllureFilterConfiguration allureFilterConfiguration, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = allureFilterConfiguration.enabled;
            }
            return allureFilterConfiguration.copy(bl);
        }

        @NotNull
        public String toString() {
            return "AllureFilterConfiguration(enabled=" + this.enabled + ")";
        }

        public AllureFilterConfiguration() {
            this(false, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationDataFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "nameRegex", "Lkotlin/text/Regex;", "valueRegex", "enabled", "", "(Lkotlin/text/Regex;Lkotlin/text/Regex;Z)V", "getEnabled", "()Z", "getNameRegex", "()Lkotlin/text/Regex;", "getValueRegex", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "validate", "", "configuration"})
    public static final class AnnotationDataFilterConfiguration
    extends TestFilterConfiguration {
        @NotNull
        private final Regex nameRegex;
        @NotNull
        private final Regex valueRegex;
        private final boolean enabled;

        public AnnotationDataFilterConfiguration(@JsonProperty(value="nameRegex") @NotNull Regex nameRegex, @JsonProperty(value="valueRegex") @NotNull Regex valueRegex, @JsonProperty(value="enabled") boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
            Intrinsics.checkNotNullParameter((Object)valueRegex, (String)"valueRegex");
            super(null);
            this.nameRegex = nameRegex;
            this.valueRegex = valueRegex;
            this.enabled = enabled;
        }

        public /* synthetic */ AnnotationDataFilterConfiguration(Regex regex, Regex regex2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(regex, regex2, bl);
        }

        @NotNull
        public final Regex getNameRegex() {
            return this.nameRegex;
        }

        @NotNull
        public final Regex getValueRegex() {
            return this.valueRegex;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof AnnotationDataFilterConfiguration)) {
                return false;
            }
            return ("" + this.nameRegex + this.valueRegex).contentEquals("" + ((AnnotationDataFilterConfiguration)other).nameRegex + ((AnnotationDataFilterConfiguration)other).valueRegex);
        }

        public int hashCode() {
            return this.nameRegex.hashCode() + this.valueRegex.hashCode();
        }

        @NotNull
        public final Regex component1() {
            return this.nameRegex;
        }

        @NotNull
        public final Regex component2() {
            return this.valueRegex;
        }

        public final boolean component3() {
            return this.enabled;
        }

        @NotNull
        public final AnnotationDataFilterConfiguration copy(@JsonProperty(value="nameRegex") @NotNull Regex nameRegex, @JsonProperty(value="valueRegex") @NotNull Regex valueRegex, @JsonProperty(value="enabled") boolean enabled) {
            Intrinsics.checkNotNullParameter((Object)nameRegex, (String)"nameRegex");
            Intrinsics.checkNotNullParameter((Object)valueRegex, (String)"valueRegex");
            return new AnnotationDataFilterConfiguration(nameRegex, valueRegex, enabled);
        }

        public static /* synthetic */ AnnotationDataFilterConfiguration copy$default(AnnotationDataFilterConfiguration annotationDataFilterConfiguration, Regex regex, Regex regex2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                regex = annotationDataFilterConfiguration.nameRegex;
            }
            if ((n & 2) != 0) {
                regex2 = annotationDataFilterConfiguration.valueRegex;
            }
            if ((n & 4) != 0) {
                bl = annotationDataFilterConfiguration.enabled;
            }
            return annotationDataFilterConfiguration.copy(regex, regex2, bl);
        }

        @NotNull
        public String toString() {
            return "AnnotationDataFilterConfiguration(nameRegex=" + this.nameRegex + ", valueRegex=" + this.valueRegex + ", enabled=" + this.enabled + ")";
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$AnnotationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "enabled", "", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;Z)V", "getEnabled", "()Z", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class AnnotationFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;
        private final boolean enabled;

        public AnnotationFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
            this.enabled = enabled;
        }

        public /* synthetic */ AnnotationFilterConfiguration(Regex regex, List list, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(regex, list, file, bl);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            int i = 0;
            if (this.regex != null) {
                ++i;
            }
            if (this.values != null) {
                ++i;
            }
            if (this.file != null) {
                ++i;
            }
            if (i > 1) {
                throw new ConfigurationException("Only one of [regex,values,file] can be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
            if (i == 0) {
                throw new ConfigurationException("At least one of [regex,values,file] should be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.AnnotationFilterConfiguration");
            AnnotationFilterConfiguration cfr_ignored_0 = (AnnotationFilterConfiguration)other;
            if (!String.valueOf(this.regex).contentEquals(String.valueOf(((AnnotationFilterConfiguration)other).regex))) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((AnnotationFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((AnnotationFilterConfiguration)other).file);
        }

        public int hashCode() {
            Regex regex = this.regex;
            int result = regex != null ? regex.hashCode() : 0;
            List<String> list = this.values;
            result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
            File file = this.file;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.enabled;
        }

        @NotNull
        public final AnnotationFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            return new AnnotationFilterConfiguration(regex, values, file, enabled);
        }

        public static /* synthetic */ AnnotationFilterConfiguration copy$default(AnnotationFilterConfiguration annotationFilterConfiguration, Regex regex, List list, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                regex = annotationFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = annotationFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = annotationFilterConfiguration.file;
            }
            if ((n & 8) != 0) {
                bl = annotationFilterConfiguration.enabled;
            }
            return annotationFilterConfiguration.copy(regex, list, file, bl);
        }

        @NotNull
        public String toString() {
            return "AnnotationFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ", enabled=" + this.enabled + ")";
        }

        public AnnotationFilterConfiguration() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB)\u0012\u000e\b\u0001\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0012\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "filters", "", "op", "Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;", "enabled", "", "(Ljava/util/List;Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;Z)V", "getEnabled", "()Z", "getFilters", "()Ljava/util/List;", "getOp", "()Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "validate", "", "OPERATION", "configuration"})
    @SourceDebugExtension(value={"SMAP\nFilteringConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilteringConfiguration.kt\ncom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,373:1\n1855#2,2:374\n1855#2,2:376\n*S KotlinDebug\n*F\n+ 1 FilteringConfiguration.kt\ncom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration\n*L\n336#1:374,2\n349#1:376,2\n*E\n"})
    public static final class CompositionFilterConfiguration
    extends TestFilterConfiguration {
        @NotNull
        private final List<TestFilterConfiguration> filters;
        @NotNull
        private final OPERATION op;
        private final boolean enabled;

        public CompositionFilterConfiguration(@JsonProperty(value="filters") @NotNull List<? extends TestFilterConfiguration> filters, @JsonProperty(value="op") @NotNull OPERATION op, @JsonProperty(value="enabled") boolean enabled) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
            super(null);
            this.filters = filters;
            this.op = op;
            this.enabled = enabled;
        }

        public /* synthetic */ CompositionFilterConfiguration(List list, OPERATION oPERATION, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(list, oPERATION, bl);
        }

        @NotNull
        public final List<TestFilterConfiguration> getFilters() {
            return this.filters;
        }

        @NotNull
        public final OPERATION getOp() {
            return this.op;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            Iterable $this$forEach$iv = this.filters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestFilterConfiguration it = (TestFilterConfiguration)element$iv;
                boolean bl = false;
                it.validate();
            }
        }

        public boolean equals(@Nullable Object other) {
            if (!(other instanceof CompositionFilterConfiguration)) {
                return false;
            }
            if (((Collection)this.filters).size() != ((Collection)((CompositionFilterConfiguration)other).filters).size()) {
                return false;
            }
            if (this.op != ((CompositionFilterConfiguration)other).op) {
                return false;
            }
            Iterable $this$forEach$iv = this.filters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestFilterConfiguration it = (TestFilterConfiguration)element$iv;
                boolean bl = false;
                if (((CompositionFilterConfiguration)other).filters.contains(it)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.filters).hashCode() + this.op.hashCode();
        }

        @NotNull
        public final List<TestFilterConfiguration> component1() {
            return this.filters;
        }

        @NotNull
        public final OPERATION component2() {
            return this.op;
        }

        public final boolean component3() {
            return this.enabled;
        }

        @NotNull
        public final CompositionFilterConfiguration copy(@JsonProperty(value="filters") @NotNull List<? extends TestFilterConfiguration> filters, @JsonProperty(value="op") @NotNull OPERATION op, @JsonProperty(value="enabled") boolean enabled) {
            Intrinsics.checkNotNullParameter(filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)((Object)op), (String)"op");
            return new CompositionFilterConfiguration(filters, op, enabled);
        }

        public static /* synthetic */ CompositionFilterConfiguration copy$default(CompositionFilterConfiguration compositionFilterConfiguration, List list, OPERATION oPERATION, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                list = compositionFilterConfiguration.filters;
            }
            if ((n & 2) != 0) {
                oPERATION = compositionFilterConfiguration.op;
            }
            if ((n & 4) != 0) {
                bl = compositionFilterConfiguration.enabled;
            }
            return compositionFilterConfiguration.copy(list, oPERATION, bl);
        }

        @NotNull
        public String toString() {
            return "CompositionFilterConfiguration(filters=" + this.filters + ", op=" + this.op + ", enabled=" + this.enabled + ")";
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$CompositionFilterConfiguration$OPERATION;", "", "(Ljava/lang/String;I)V", "UNION", "INTERSECTION", "SUBTRACT", "configuration"})
        public static final class OPERATION
        extends Enum<OPERATION> {
            public static final /* enum */ OPERATION UNION = new OPERATION();
            public static final /* enum */ OPERATION INTERSECTION = new OPERATION();
            public static final /* enum */ OPERATION SUBTRACT = new OPERATION();
            private static final /* synthetic */ OPERATION[] $VALUES;

            public static OPERATION[] values() {
                return (OPERATION[])$VALUES.clone();
            }

            public static OPERATION valueOf(String value) {
                return Enum.valueOf(OPERATION.class, value);
            }

            static {
                $VALUES = oPERATIONArray = new OPERATION[]{OPERATION.UNION, OPERATION.INTERSECTION, OPERATION.SUBTRACT};
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0003\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00062\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$FragmentationFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "index", "", "count", "enabled", "", "(IIZ)V", "getCount", "()I", "getEnabled", "()Z", "getIndex", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "toString", "", "validate", "", "configuration"})
    public static final class FragmentationFilterConfiguration
    extends TestFilterConfiguration {
        private final int index;
        private final int count;
        private final boolean enabled;

        public FragmentationFilterConfiguration(int index, int count, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.index = index;
            this.count = count;
            this.enabled = enabled;
        }

        public /* synthetic */ FragmentationFilterConfiguration(int n, int n2, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 4) != 0) {
                bl = true;
            }
            this(n, n2, bl);
        }

        public final int getIndex() {
            return this.index;
        }

        public final int getCount() {
            return this.count;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            if (this.index < 0) {
                throw new ConfigurationException("Fragment index [" + this.index + "] should be >= 0");
            }
            if (this.count < 0) {
                throw new ConfigurationException("Fragment count [" + this.count + "] should be >= 0");
            }
            if (this.index >= this.count) {
                throw new ConfigurationException("Fragment index [" + this.index + "] should be less than count [" + this.count + "]");
            }
        }

        public final int component1() {
            return this.index;
        }

        public final int component2() {
            return this.count;
        }

        public final boolean component3() {
            return this.enabled;
        }

        @NotNull
        public final FragmentationFilterConfiguration copy(int index, int count, @JsonProperty(value="enabled") boolean enabled) {
            return new FragmentationFilterConfiguration(index, count, enabled);
        }

        public static /* synthetic */ FragmentationFilterConfiguration copy$default(FragmentationFilterConfiguration fragmentationFilterConfiguration, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = fragmentationFilterConfiguration.index;
            }
            if ((n3 & 2) != 0) {
                n2 = fragmentationFilterConfiguration.count;
            }
            if ((n3 & 4) != 0) {
                bl = fragmentationFilterConfiguration.enabled;
            }
            return fragmentationFilterConfiguration.copy(n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "FragmentationFilterConfiguration(index=" + this.index + ", count=" + this.count + ", enabled=" + this.enabled + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.index);
            result = result * 31 + Integer.hashCode(this.count);
            int n = this.enabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FragmentationFilterConfiguration)) {
                return false;
            }
            FragmentationFilterConfiguration fragmentationFilterConfiguration = (FragmentationFilterConfiguration)other;
            if (this.index != fragmentationFilterConfiguration.index) {
                return false;
            }
            if (this.count != fragmentationFilterConfiguration.count) {
                return false;
            }
            return this.enabled == fragmentationFilterConfiguration.enabled;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "enabled", "", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;Z)V", "getEnabled", "()Z", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class FullyQualifiedClassnameFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;
        private final boolean enabled;

        public FullyQualifiedClassnameFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
            this.enabled = enabled;
        }

        public /* synthetic */ FullyQualifiedClassnameFilterConfiguration(Regex regex, List list, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(regex, list, file, bl);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            int i = 0;
            if (this.regex != null) {
                ++i;
            }
            if (this.values != null) {
                ++i;
            }
            if (this.file != null) {
                ++i;
            }
            if (i > 1) {
                throw new ConfigurationException("Only one of [regex,values,file] can be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
            if (i == 0) {
                throw new ConfigurationException("At least one of [regex,values,file] should be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.FullyQualifiedClassnameFilterConfiguration");
            FullyQualifiedClassnameFilterConfiguration cfr_ignored_0 = (FullyQualifiedClassnameFilterConfiguration)other;
            if (!String.valueOf(this.regex).contentEquals(String.valueOf(((FullyQualifiedClassnameFilterConfiguration)other).regex))) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((FullyQualifiedClassnameFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((FullyQualifiedClassnameFilterConfiguration)other).file);
        }

        public int hashCode() {
            Regex regex = this.regex;
            int result = regex != null ? regex.hashCode() : 0;
            List<String> list = this.values;
            result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
            File file = this.file;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.enabled;
        }

        @NotNull
        public final FullyQualifiedClassnameFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            return new FullyQualifiedClassnameFilterConfiguration(regex, values, file, enabled);
        }

        public static /* synthetic */ FullyQualifiedClassnameFilterConfiguration copy$default(FullyQualifiedClassnameFilterConfiguration fullyQualifiedClassnameFilterConfiguration, Regex regex, List list, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                regex = fullyQualifiedClassnameFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = fullyQualifiedClassnameFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = fullyQualifiedClassnameFilterConfiguration.file;
            }
            if ((n & 8) != 0) {
                bl = fullyQualifiedClassnameFilterConfiguration.enabled;
            }
            return fullyQualifiedClassnameFilterConfiguration.copy(regex, list, file, bl);
        }

        @NotNull
        public String toString() {
            return "FullyQualifiedClassnameFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ", enabled=" + this.enabled + ")";
        }

        public FullyQualifiedClassnameFilterConfiguration() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$FullyQualifiedTestnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "enabled", "", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;Z)V", "getEnabled", "()Z", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class FullyQualifiedTestnameFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;
        private final boolean enabled;

        public FullyQualifiedTestnameFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
            this.enabled = enabled;
        }

        public /* synthetic */ FullyQualifiedTestnameFilterConfiguration(Regex regex, List list, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(regex, list, file, bl);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            int i = 0;
            if (this.regex != null) {
                ++i;
            }
            if (this.values != null) {
                ++i;
            }
            if (this.file != null) {
                ++i;
            }
            if (i > 1) {
                throw new ConfigurationException("Only one of [regex,values,file] can be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
            if (i == 0) {
                throw new ConfigurationException("At least one of [regex,values,file] should be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.FullyQualifiedTestnameFilterConfiguration");
            FullyQualifiedTestnameFilterConfiguration cfr_ignored_0 = (FullyQualifiedTestnameFilterConfiguration)other;
            if (!String.valueOf(this.regex).contentEquals(String.valueOf(((FullyQualifiedTestnameFilterConfiguration)other).regex))) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((FullyQualifiedTestnameFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((FullyQualifiedTestnameFilterConfiguration)other).file);
        }

        public int hashCode() {
            Regex regex = this.regex;
            int result = regex != null ? regex.hashCode() : 0;
            List<String> list = this.values;
            result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
            File file = this.file;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.enabled;
        }

        @NotNull
        public final FullyQualifiedTestnameFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            return new FullyQualifiedTestnameFilterConfiguration(regex, values, file, enabled);
        }

        public static /* synthetic */ FullyQualifiedTestnameFilterConfiguration copy$default(FullyQualifiedTestnameFilterConfiguration fullyQualifiedTestnameFilterConfiguration, Regex regex, List list, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                regex = fullyQualifiedTestnameFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = fullyQualifiedTestnameFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = fullyQualifiedTestnameFilterConfiguration.file;
            }
            if ((n & 8) != 0) {
                bl = fullyQualifiedTestnameFilterConfiguration.enabled;
            }
            return fullyQualifiedTestnameFilterConfiguration.copy(regex, list, file, bl);
        }

        @NotNull
        public String toString() {
            return "FullyQualifiedTestnameFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ", enabled=" + this.enabled + ")";
        }

        public FullyQualifiedTestnameFilterConfiguration() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$SimpleClassnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "enabled", "", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;Z)V", "getEnabled", "()Z", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class SimpleClassnameFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;
        private final boolean enabled;

        public SimpleClassnameFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
            this.enabled = enabled;
        }

        public /* synthetic */ SimpleClassnameFilterConfiguration(Regex regex, List list, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(regex, list, file, bl);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            int i = 0;
            if (this.regex != null) {
                ++i;
            }
            if (this.values != null) {
                ++i;
            }
            if (this.file != null) {
                ++i;
            }
            if (i > 1) {
                throw new ConfigurationException("Only one of [regex,values,file] can be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
            if (i == 0) {
                throw new ConfigurationException("At least one of [regex,values,file] should be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.SimpleClassnameFilterConfiguration");
            SimpleClassnameFilterConfiguration cfr_ignored_0 = (SimpleClassnameFilterConfiguration)other;
            if (!String.valueOf(this.regex).contentEquals(String.valueOf(((SimpleClassnameFilterConfiguration)other).regex))) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((SimpleClassnameFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((SimpleClassnameFilterConfiguration)other).file);
        }

        public int hashCode() {
            Regex regex = this.regex;
            int result = regex != null ? regex.hashCode() : 0;
            List<String> list = this.values;
            result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
            File file = this.file;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.enabled;
        }

        @NotNull
        public final SimpleClassnameFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            return new SimpleClassnameFilterConfiguration(regex, values, file, enabled);
        }

        public static /* synthetic */ SimpleClassnameFilterConfiguration copy$default(SimpleClassnameFilterConfiguration simpleClassnameFilterConfiguration, Regex regex, List list, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                regex = simpleClassnameFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = simpleClassnameFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = simpleClassnameFilterConfiguration.file;
            }
            if ((n & 8) != 0) {
                bl = simpleClassnameFilterConfiguration.enabled;
            }
            return simpleClassnameFilterConfiguration.copy(regex, list, file, bl);
        }

        @NotNull
        public String toString() {
            return "SimpleClassnameFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ", enabled=" + this.enabled + ")";
        }

        public SimpleClassnameFilterConfiguration() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$SimpleTestnameFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "enabled", "", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;Z)V", "getEnabled", "()Z", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class SimpleTestnameFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;
        private final boolean enabled;

        public SimpleTestnameFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
            this.enabled = enabled;
        }

        public /* synthetic */ SimpleTestnameFilterConfiguration(Regex regex, List list, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(regex, list, file, bl);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            int i = 0;
            if (this.regex != null) {
                ++i;
            }
            if (this.values != null) {
                ++i;
            }
            if (this.file != null) {
                ++i;
            }
            if (i > 1) {
                throw new ConfigurationException("Only one of [regex,values,file] can be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
            if (i == 0) {
                throw new ConfigurationException("At least one of [regex,values,file] should be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.SimpleClassnameFilterConfiguration");
            SimpleClassnameFilterConfiguration cfr_ignored_0 = (SimpleClassnameFilterConfiguration)other;
            if (!String.valueOf(this.regex).contentEquals(String.valueOf(((SimpleClassnameFilterConfiguration)other).getRegex()))) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((SimpleClassnameFilterConfiguration)other).getValues())) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((SimpleClassnameFilterConfiguration)other).getFile());
        }

        public int hashCode() {
            Regex regex = this.regex;
            int result = regex != null ? regex.hashCode() : 0;
            List<String> list = this.values;
            result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
            File file = this.file;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.enabled;
        }

        @NotNull
        public final SimpleTestnameFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            return new SimpleTestnameFilterConfiguration(regex, values, file, enabled);
        }

        public static /* synthetic */ SimpleTestnameFilterConfiguration copy$default(SimpleTestnameFilterConfiguration simpleTestnameFilterConfiguration, Regex regex, List list, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                regex = simpleTestnameFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = simpleTestnameFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = simpleTestnameFilterConfiguration.file;
            }
            if ((n & 8) != 0) {
                bl = simpleTestnameFilterConfiguration.enabled;
            }
            return simpleTestnameFilterConfiguration.copy(regex, list, file, bl);
        }

        @NotNull
        public String toString() {
            return "SimpleTestnameFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ", enabled=" + this.enabled + ")";
        }

        public SimpleTestnameFilterConfiguration() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestMethodFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "enabled", "", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;Z)V", "getEnabled", "()Z", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class TestMethodFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;
        private final boolean enabled;

        public TestMethodFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
            this.enabled = enabled;
        }

        public /* synthetic */ TestMethodFilterConfiguration(Regex regex, List list, File file, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = true;
            }
            this(regex, list, file, bl);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            int i = 0;
            if (this.regex != null) {
                ++i;
            }
            if (this.values != null) {
                ++i;
            }
            if (this.file != null) {
                ++i;
            }
            if (i > 1) {
                throw new ConfigurationException("Only one of [regex,values,file] can be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
            if (i == 0) {
                throw new ConfigurationException("At least one of [regex,values,file] should be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.TestMethodFilterConfiguration");
            TestMethodFilterConfiguration cfr_ignored_0 = (TestMethodFilterConfiguration)other;
            if (!String.valueOf(this.regex).contentEquals(String.valueOf(((TestMethodFilterConfiguration)other).regex))) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((TestMethodFilterConfiguration)other).values)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.file, (Object)((TestMethodFilterConfiguration)other).file);
        }

        public int hashCode() {
            Regex regex = this.regex;
            int result = regex != null ? regex.hashCode() : 0;
            List<String> list = this.values;
            result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
            File file = this.file;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.enabled;
        }

        @NotNull
        public final TestMethodFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="enabled") boolean enabled) {
            return new TestMethodFilterConfiguration(regex, values, file, enabled);
        }

        public static /* synthetic */ TestMethodFilterConfiguration copy$default(TestMethodFilterConfiguration testMethodFilterConfiguration, Regex regex, List list, File file, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                regex = testMethodFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = testMethodFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = testMethodFilterConfiguration.file;
            }
            if ((n & 8) != 0) {
                bl = testMethodFilterConfiguration.enabled;
            }
            return testMethodFilterConfiguration.copy(regex, list, file, bl);
        }

        @NotNull
        public String toString() {
            return "TestMethodFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ", enabled=" + this.enabled + ")";
        }

        public TestMethodFilterConfiguration() {
            this(null, null, null, false, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0003\u0010\t\u001a\u00020\n\u0012\b\b\u0003\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\nH\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0003\u0010\t\u001a\u00020\n2\b\b\u0003\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\t\u0010!\u001a\u00020\u0006H\u00d6\u0001J\b\u0010\"\u001a\u00020#H\u0016R\u0014\u0010\u000b\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcom/malinskiy/marathon/config/TestFilterConfiguration$TestPackageFilterConfiguration;", "Lcom/malinskiy/marathon/config/TestFilterConfiguration;", "regex", "Lkotlin/text/Regex;", "values", "", "", "file", "Ljava/io/File;", "subpackages", "", "enabled", "(Lkotlin/text/Regex;Ljava/util/List;Ljava/io/File;ZZ)V", "getEnabled", "()Z", "getFile", "()Ljava/io/File;", "getRegex", "()Lkotlin/text/Regex;", "getSubpackages", "getValues", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class TestPackageFilterConfiguration
    extends TestFilterConfiguration {
        @Nullable
        private final Regex regex;
        @Nullable
        private final List<String> values;
        @Nullable
        private final File file;
        private final boolean subpackages;
        private final boolean enabled;

        public TestPackageFilterConfiguration(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="subpackages") boolean subpackages, @JsonProperty(value="enabled") boolean enabled) {
            super(null);
            this.regex = regex;
            this.values = values;
            this.file = file;
            this.subpackages = subpackages;
            this.enabled = enabled;
        }

        public /* synthetic */ TestPackageFilterConfiguration(Regex regex, List list, File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                regex = null;
            }
            if ((n & 2) != 0) {
                list = null;
            }
            if ((n & 4) != 0) {
                file = null;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = true;
            }
            this(regex, list, file, bl, bl2);
        }

        @Nullable
        public final Regex getRegex() {
            return this.regex;
        }

        @Nullable
        public final List<String> getValues() {
            return this.values;
        }

        @Nullable
        public final File getFile() {
            return this.file;
        }

        public final boolean getSubpackages() {
            return this.subpackages;
        }

        @Override
        public boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public void validate() {
            int i = 0;
            if (this.regex != null) {
                ++i;
            }
            if (this.values != null) {
                ++i;
            }
            if (this.file != null) {
                ++i;
            }
            if (i > 1) {
                throw new ConfigurationException("Only one of [regex,values,file] can be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
            if (i == 0) {
                throw new ConfigurationException("At least one of [regex,values,file] should be specified for " + Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName());
            }
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                return false;
            }
            Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.malinskiy.marathon.config.TestFilterConfiguration.TestPackageFilterConfiguration");
            TestPackageFilterConfiguration cfr_ignored_0 = (TestPackageFilterConfiguration)other;
            if (!String.valueOf(this.regex).contentEquals(String.valueOf(((TestPackageFilterConfiguration)other).regex))) {
                return false;
            }
            if (!Intrinsics.areEqual(this.values, ((TestPackageFilterConfiguration)other).values)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.file, (Object)((TestPackageFilterConfiguration)other).file)) {
                return false;
            }
            return this.subpackages == ((TestPackageFilterConfiguration)other).subpackages;
        }

        public int hashCode() {
            Regex regex = this.regex;
            int result = regex != null ? regex.hashCode() : 0;
            List<String> list = this.values;
            result = 31 * result + (list != null ? ((Object)list).hashCode() : 0);
            File file = this.file;
            result = 31 * result + (file != null ? file.hashCode() : 0);
            result = 31 * result + Boolean.hashCode(this.subpackages);
            return result;
        }

        @Nullable
        public final Regex component1() {
            return this.regex;
        }

        @Nullable
        public final List<String> component2() {
            return this.values;
        }

        @Nullable
        public final File component3() {
            return this.file;
        }

        public final boolean component4() {
            return this.subpackages;
        }

        public final boolean component5() {
            return this.enabled;
        }

        @NotNull
        public final TestPackageFilterConfiguration copy(@JsonProperty(value="regex") @Nullable Regex regex, @JsonProperty(value="values") @Nullable List<String> values, @JsonProperty(value="file") @Nullable File file, @JsonProperty(value="subpackages") boolean subpackages, @JsonProperty(value="enabled") boolean enabled) {
            return new TestPackageFilterConfiguration(regex, values, file, subpackages, enabled);
        }

        public static /* synthetic */ TestPackageFilterConfiguration copy$default(TestPackageFilterConfiguration testPackageFilterConfiguration, Regex regex, List list, File file, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                regex = testPackageFilterConfiguration.regex;
            }
            if ((n & 2) != 0) {
                list = testPackageFilterConfiguration.values;
            }
            if ((n & 4) != 0) {
                file = testPackageFilterConfiguration.file;
            }
            if ((n & 8) != 0) {
                bl = testPackageFilterConfiguration.subpackages;
            }
            if ((n & 0x10) != 0) {
                bl2 = testPackageFilterConfiguration.enabled;
            }
            return testPackageFilterConfiguration.copy(regex, list, file, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "TestPackageFilterConfiguration(regex=" + this.regex + ", values=" + this.values + ", file=" + this.file + ", subpackages=" + this.subpackages + ", enabled=" + this.enabled + ")";
        }

        public TestPackageFilterConfiguration() {
            this(null, null, null, false, false, 31, null);
        }
    }
}

