/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.serialization;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinFeature;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import com.malinskiy.marathon.config.Configuration;
import com.malinskiy.marathon.config.environment.EnvironmentReader;
import com.malinskiy.marathon.config.environment.SystemEnvironmentReader;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import com.malinskiy.marathon.config.serialization.ConfigurationFactoryKt;
import com.malinskiy.marathon.config.serialization.time.InstantTimeProviderImpl;
import com.malinskiy.marathon.config.serialization.yaml.SerializeModule;
import com.malinskiy.marathon.config.vendor.VendorConfiguration;
import com.malinskiy.marathon.config.vendor.apple.AppleTestBundleConfiguration;
import com.malinskiy.marathon.config.vendor.apple.SshAuthentication;
import com.malinskiy.marathon.config.vendor.apple.SshConfiguration;
import com.malinskiy.marathon.config.vendor.apple.ios.PullingPolicy;
import com.malinskiy.marathon.config.vendor.apple.ios.XcresultConfiguration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.text.StringSubstitutor;
import org.apache.commons.text.lookup.StringLookupFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0012\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/malinskiy/marathon/config/serialization/ConfigurationFactory;", "", "marathonfileDir", "Ljava/io/File;", "environmentReader", "Lcom/malinskiy/marathon/config/environment/EnvironmentReader;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "environmentVariableSubstitutor", "Lorg/apache/commons/text/StringSubstitutor;", "analyticsTracking", "", "bugsnagReporting", "(Ljava/io/File;Lcom/malinskiy/marathon/config/environment/EnvironmentReader;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/apache/commons/text/StringSubstitutor;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "parse", "Lcom/malinskiy/marathon/config/Configuration;", "marathonfile", "serialize", "", "configuration"})
@SourceDebugExtension(value={"SMAP\nConfigurationFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationFactory.kt\ncom/malinskiy/marathon/config/serialization/ConfigurationFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,212:1\n1#2:213\n1549#3:214\n1620#3,3:215\n1549#3:218\n1620#3,3:219\n1549#3:222\n1620#3,3:223\n*S KotlinDebug\n*F\n+ 1 ConfigurationFactory.kt\ncom/malinskiy/marathon/config/serialization/ConfigurationFactory\n*L\n78#1:214\n78#1:215,3\n89#1:218\n89#1:219,3\n139#1:222\n139#1:223,3\n*E\n"})
public final class ConfigurationFactory {
    @NotNull
    private final File marathonfileDir;
    @NotNull
    private final EnvironmentReader environmentReader;
    @NotNull
    private final ObjectMapper mapper;
    @NotNull
    private final StringSubstitutor environmentVariableSubstitutor;
    @Nullable
    private final Boolean analyticsTracking;
    @Nullable
    private final Boolean bugsnagReporting;

    public ConfigurationFactory(@NotNull File marathonfileDir, @NotNull EnvironmentReader environmentReader, @NotNull ObjectMapper mapper, @NotNull StringSubstitutor environmentVariableSubstitutor, @Nullable Boolean analyticsTracking, @Nullable Boolean bugsnagReporting) {
        Intrinsics.checkNotNullParameter((Object)marathonfileDir, (String)"marathonfileDir");
        Intrinsics.checkNotNullParameter((Object)environmentReader, (String)"environmentReader");
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter((Object)environmentVariableSubstitutor, (String)"environmentVariableSubstitutor");
        this.marathonfileDir = marathonfileDir;
        this.environmentReader = environmentReader;
        this.mapper = mapper;
        this.environmentVariableSubstitutor = environmentVariableSubstitutor;
        this.analyticsTracking = analyticsTracking;
        this.bugsnagReporting = bugsnagReporting;
    }

    public /* synthetic */ ConfigurationFactory(File file, EnvironmentReader environmentReader, ObjectMapper objectMapper, StringSubstitutor stringSubstitutor, Boolean bl, Boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            environmentReader = new SystemEnvironmentReader(null, 1, null);
        }
        if ((n & 4) != 0) {
            ObjectMapper objectMapper2;
            ObjectMapper $this$_init__u24lambda_u240 = objectMapper2 = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID));
            boolean bl3 = false;
            $this$_init__u24lambda_u240.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            $this$_init__u24lambda_u240.registerModule((Module)new SerializeModule(new InstantTimeProviderImpl(), file));
            $this$_init__u24lambda_u240.registerModule((Module)new KotlinModule.Builder().withReflectionCacheSize(512).configure(KotlinFeature.NullToEmptyCollection, false).configure(KotlinFeature.NullToEmptyMap, false).configure(KotlinFeature.NullIsSameAsDefault, false).configure(KotlinFeature.SingletonSupport, true).configure(KotlinFeature.StrictNullChecks, false).build());
            $this$_init__u24lambda_u240.registerModule((Module)new JavaTimeModule());
            $this$_init__u24lambda_u240.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            $this$_init__u24lambda_u240.configure(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, false);
            objectMapper = objectMapper2;
        }
        if ((n & 8) != 0) {
            stringSubstitutor = new StringSubstitutor(StringLookupFactory.INSTANCE.environmentVariableStringLookup());
        }
        if ((n & 0x10) != 0) {
            bl = null;
        }
        if ((n & 0x20) != 0) {
            bl2 = null;
        }
        this(file, environmentReader, objectMapper, stringSubstitutor, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Configuration parse(@NotNull File marathonfile) {
        Intrinsics.checkNotNullParameter((Object)marathonfile, (String)"marathonfile");
        String configWithEnvironmentVariablesReplaced = this.environmentVariableSubstitutor.replace(FilesKt.readText$default((File)marathonfile, null, (int)1, null));
        try {
            AppleTestBundleConfiguration resolvedBundle;
            Iterable resolvedExtraApplications;
            File ddd;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            File resolvedTestApplication;
            File resolvedApplication;
            File ddd2;
            AppleTestBundleConfiguration it;
            VendorConfiguration vendorConfiguration;
            Configuration configuration = (Configuration)this.mapper.readValue(configWithEnvironmentVariablesReplaced, Configuration.class);
            VendorConfiguration vendorConfiguration2 = configuration.getVendorConfiguration();
            if (vendorConfiguration2 instanceof VendorConfiguration.AndroidConfiguration) {
                VendorConfiguration.AndroidConfiguration androidConfiguration;
                if (((VendorConfiguration.AndroidConfiguration)configuration.getVendorConfiguration()).getAndroidSdk() == null) {
                    File file = this.environmentReader.read().getAndroidSdk();
                    if (file == null) {
                        throw new ConfigurationException("No android SDK path specified");
                    }
                    File androidSdk = file;
                    androidConfiguration = VendorConfiguration.AndroidConfiguration.copy$default((VendorConfiguration.AndroidConfiguration)configuration.getVendorConfiguration(), androidSdk, null, null, null, null, null, false, null, false, false, 0, null, null, null, 0L, null, null, null, null, null, null, null, false, 0x7FFFFE, null);
                } else {
                    androidConfiguration = (VendorConfiguration.AndroidConfiguration)configuration.getVendorConfiguration();
                }
                vendorConfiguration = androidConfiguration;
            } else if (vendorConfiguration2 instanceof VendorConfiguration.IOSConfiguration) {
                XcresultConfiguration xcresultConfiguration;
                SshAuthentication sshAuthentication;
                File file;
                List resolvedMediaFiles;
                List list;
                SshAuthentication $this$mapTo$iv$iv2;
                AppleTestBundleConfiguration appleTestBundleConfiguration;
                Object $this$parse_u24lambda_u246_u24lambda_u245;
                VendorConfiguration.IOSConfiguration iosConfiguration = (VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration();
                AppleTestBundleConfiguration appleTestBundleConfiguration2 = iosConfiguration.getBundle();
                if (appleTestBundleConfiguration2 != null) {
                    List list2;
                    File file2;
                    File file3;
                    File file4;
                    it = appleTestBundleConfiguration2;
                    boolean bl = false;
                    File file5 = it.getDerivedDataDir();
                    if (file5 != null) {
                        ddd2 = file5;
                        boolean bl2 = false;
                        file4 = FilesKt.resolve((File)this.marathonfileDir, (File)ddd2);
                    } else {
                        file4 = null;
                    }
                    File resolvedDerivedDataDir = file4;
                    File file6 = it.getApplication();
                    if (file6 != null) {
                        File ddd3 = file6;
                        boolean bl3 = false;
                        file3 = FilesKt.resolve((File)this.marathonfileDir, (File)ddd3);
                    } else {
                        file3 = null;
                    }
                    resolvedApplication = file3;
                    File file7 = it.getTestApplication();
                    if (file7 != null) {
                        File ddd4 = file7;
                        boolean bl4 = false;
                        file2 = FilesKt.resolve((File)this.marathonfileDir, (File)ddd4);
                    } else {
                        file2 = null;
                    }
                    resolvedTestApplication = file2;
                    List<File> list3 = it.getExtraApplications();
                    if (list3 != null) {
                        Iterable $this$map$iv = list3;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            File file8 = (File)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl5 = false;
                            collection.add(FilesKt.resolve((File)this.marathonfileDir, (File)ddd));
                        }
                        list2 = (List)destination$iv$iv;
                    } else {
                        list2 = null;
                    }
                    resolvedExtraApplications = list2;
                    AppleTestBundleConfiguration ddd3 = new AppleTestBundleConfiguration(resolvedApplication, resolvedTestApplication, (List)resolvedExtraApplications, resolvedDerivedDataDir, it.getTestType(), null, 32, null);
                    $this$parse_u24lambda_u246_u24lambda_u245 = ddd3;
                    boolean bl6 = false;
                    ((AppleTestBundleConfiguration)$this$parse_u24lambda_u246_u24lambda_u245).validate();
                    appleTestBundleConfiguration = ddd3;
                } else {
                    appleTestBundleConfiguration = null;
                }
                resolvedBundle = appleTestBundleConfiguration;
                List<File> list4 = iosConfiguration.getMediaFiles();
                if (list4 != null) {
                    Iterable $this$map$iv = list4;
                    boolean $i$f$map = false;
                    resolvedExtraApplications = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    $this$parse_u24lambda_u246_u24lambda_u245 = $this$mapTo$iv$iv2.iterator();
                    while ($this$parse_u24lambda_u246_u24lambda_u245.hasNext()) {
                        void ddd5;
                        Object item$iv$iv = $this$parse_u24lambda_u246_u24lambda_u245.next();
                        File bl6 = (File)item$iv$iv;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl = false;
                        collection2.add(FilesKt.resolve((File)this.marathonfileDir, (File)ddd5));
                    }
                    list = (List)destination$iv$iv2;
                } else {
                    list = resolvedMediaFiles = null;
                }
                if ((file = ((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration()).getDevicesFile()) == null || (file = ConfigurationFactoryKt.access$resolveAgainst(file, this.marathonfileDir)) == null) {
                    file = FilesKt.resolve((File)this.marathonfileDir, (String)"Marathondevices");
                }
                File optionalDevices = file;
                File file9 = iosConfiguration.getSsh().getKnownHostsPath();
                File optionalknownHostsPath = file9 != null ? ConfigurationFactoryKt.access$resolveAgainst(file9, this.marathonfileDir) : null;
                $this$mapTo$iv$iv2 = iosConfiguration.getSsh().getAuthentication();
                if ($this$mapTo$iv$iv2 instanceof SshAuthentication.PasswordAuthentication) {
                    sshAuthentication = iosConfiguration.getSsh().getAuthentication();
                } else if ($this$mapTo$iv$iv2 instanceof SshAuthentication.PublicKeyAuthentication) {
                    sshAuthentication = ((SshAuthentication.PublicKeyAuthentication)iosConfiguration.getSsh().getAuthentication()).copy(((SshAuthentication.PublicKeyAuthentication)iosConfiguration.getSsh().getAuthentication()).getUsername(), ConfigurationFactoryKt.access$resolveAgainst(((SshAuthentication.PublicKeyAuthentication)iosConfiguration.getSsh().getAuthentication()).getKey(), this.marathonfileDir));
                } else if ($this$mapTo$iv$iv2 == null) {
                    sshAuthentication = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                SshAuthentication optionalSshAuthentication = sshAuthentication;
                SshConfiguration optionalSshConfiguration = SshConfiguration.copy$default(iosConfiguration.getSsh(), optionalSshAuthentication, optionalknownHostsPath, null, false, false, 28, null);
                Boolean $i$f$mapTo2 = iosConfiguration.getXcresult().getPull();
                if (Intrinsics.areEqual((Object)$i$f$mapTo2, (Object)true)) {
                    xcresultConfiguration = XcresultConfiguration.copy$default(iosConfiguration.getXcresult(), null, PullingPolicy.ALWAYS, iosConfiguration.getXcresult().getRemoteClean(), null, null, 25, null);
                } else if (Intrinsics.areEqual((Object)$i$f$mapTo2, (Object)false)) {
                    xcresultConfiguration = XcresultConfiguration.copy$default(iosConfiguration.getXcresult(), null, PullingPolicy.NEVER, iosConfiguration.getXcresult().getRemoteClean(), null, null, 25, null);
                } else if ($i$f$mapTo2 == null) {
                    xcresultConfiguration = iosConfiguration.getXcresult();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                XcresultConfiguration xcresultConfiguration2 = xcresultConfiguration;
                vendorConfiguration = VendorConfiguration.IOSConfiguration.copy$default((VendorConfiguration.IOSConfiguration)configuration.getVendorConfiguration(), resolvedBundle, optionalDevices, optionalSshConfiguration, xcresultConfiguration2, null, null, null, null, resolvedMediaFiles, null, null, false, false, null, null, false, null, false, null, 524016, null);
            } else if (vendorConfiguration2 instanceof VendorConfiguration.MacosConfiguration) {
                XcresultConfiguration xcresultConfiguration;
                SshAuthentication sshAuthentication;
                File file;
                Object object;
                Object object2;
                VendorConfiguration.MacosConfiguration macosConfiguration = (VendorConfiguration.MacosConfiguration)configuration.getVendorConfiguration();
                AppleTestBundleConfiguration appleTestBundleConfiguration = macosConfiguration.getBundle();
                if (appleTestBundleConfiguration != null) {
                    List list;
                    File file10;
                    File file11;
                    File file12;
                    it = appleTestBundleConfiguration;
                    boolean bl = false;
                    File file13 = it.getDerivedDataDir();
                    if (file13 != null) {
                        ddd2 = file13;
                        boolean bl7 = false;
                        file12 = FilesKt.resolve((File)this.marathonfileDir, (File)ddd2);
                    } else {
                        file12 = null;
                    }
                    File resolvedDerivedDataDir = file12;
                    File file14 = it.getApplication();
                    if (file14 != null) {
                        File ddd6 = file14;
                        boolean bl8 = false;
                        file11 = FilesKt.resolve((File)this.marathonfileDir, (File)ddd6);
                    } else {
                        file11 = null;
                    }
                    resolvedApplication = file11;
                    File file15 = it.getTestApplication();
                    if (file15 != null) {
                        File ddd7 = file15;
                        boolean bl9 = false;
                        file10 = FilesKt.resolve((File)this.marathonfileDir, (File)ddd7);
                    } else {
                        file10 = null;
                    }
                    resolvedTestApplication = file10;
                    List<File> list5 = it.getExtraApplications();
                    if (list5 != null) {
                        Iterable $this$map$iv = list5;
                        boolean $i$f$map = false;
                        $this$mapTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            ddd = (File)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl10 = false;
                            collection.add(FilesKt.resolve((File)this.marathonfileDir, (File)ddd));
                        }
                        list = (List)destination$iv$iv;
                    } else {
                        list = null;
                    }
                    resolvedExtraApplications = list;
                    object2 = new AppleTestBundleConfiguration(resolvedApplication, resolvedTestApplication, (List)resolvedExtraApplications, resolvedDerivedDataDir, it.getTestType(), null, 32, null);
                    AppleTestBundleConfiguration $this$parse_u24lambda_u2413_u24lambda_u2412 = object2;
                    boolean bl11 = false;
                    $this$parse_u24lambda_u2413_u24lambda_u2412.validate();
                    object = object2;
                } else {
                    object = resolvedBundle = null;
                }
                if ((file = ((VendorConfiguration.MacosConfiguration)configuration.getVendorConfiguration()).getDevicesFile()) == null || (file = ConfigurationFactoryKt.access$resolveAgainst(file, this.marathonfileDir)) == null) {
                    file = FilesKt.resolve((File)this.marathonfileDir, (String)"Marathondevices");
                }
                File optionalDevices = file;
                File file16 = macosConfiguration.getSsh().getKnownHostsPath();
                File optionalknownHostsPath = file16 != null ? ConfigurationFactoryKt.access$resolveAgainst(file16, this.marathonfileDir) : null;
                SshAuthentication bl = macosConfiguration.getSsh().getAuthentication();
                if (bl instanceof SshAuthentication.PasswordAuthentication) {
                    sshAuthentication = macosConfiguration.getSsh().getAuthentication();
                } else if (bl instanceof SshAuthentication.PublicKeyAuthentication) {
                    sshAuthentication = ((SshAuthentication.PublicKeyAuthentication)macosConfiguration.getSsh().getAuthentication()).copy(((SshAuthentication.PublicKeyAuthentication)macosConfiguration.getSsh().getAuthentication()).getUsername(), ConfigurationFactoryKt.access$resolveAgainst(((SshAuthentication.PublicKeyAuthentication)macosConfiguration.getSsh().getAuthentication()).getKey(), this.marathonfileDir));
                } else if (bl == null) {
                    sshAuthentication = null;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                SshAuthentication optionalSshAuthentication = sshAuthentication;
                SshConfiguration optionalSshConfiguration = SshConfiguration.copy$default(macosConfiguration.getSsh(), optionalSshAuthentication, optionalknownHostsPath, null, false, false, 28, null);
                object2 = macosConfiguration.getXcresult().getPull();
                if (Intrinsics.areEqual((Object)object2, (Object)true)) {
                    xcresultConfiguration = XcresultConfiguration.copy$default(macosConfiguration.getXcresult(), null, PullingPolicy.ALWAYS, macosConfiguration.getXcresult().getRemoteClean(), null, null, 25, null);
                } else if (Intrinsics.areEqual((Object)object2, (Object)false)) {
                    xcresultConfiguration = XcresultConfiguration.copy$default(macosConfiguration.getXcresult(), null, PullingPolicy.NEVER, macosConfiguration.getXcresult().getRemoteClean(), null, null, 25, null);
                } else if (object2 == null) {
                    xcresultConfiguration = macosConfiguration.getXcresult();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                XcresultConfiguration xcresultConfiguration3 = xcresultConfiguration;
                vendorConfiguration = VendorConfiguration.MacosConfiguration.copy$default((VendorConfiguration.MacosConfiguration)configuration.getVendorConfiguration(), resolvedBundle, optionalDevices, optionalSshConfiguration, xcresultConfiguration3, null, null, null, false, false, null, null, null, null, 8176, null);
            } else if (Intrinsics.areEqual((Object)vendorConfiguration2, (Object)VendorConfiguration.StubVendorConfiguration.INSTANCE)) {
                vendorConfiguration = configuration.getVendorConfiguration();
            } else {
                if (vendorConfiguration2 instanceof VendorConfiguration.EmptyVendorConfiguration) {
                    throw new ConfigurationException("No vendor configuration specified");
                }
                throw new NoWhenBranchMatchedException();
            }
            VendorConfiguration vendorConfiguration3 = vendorConfiguration;
            Intrinsics.checkNotNull((Object)configuration);
            return Configuration.copy$default(configuration, null, null, null, null, null, null, null, null, null, null, null, false, null, false, 0, null, null, 0L, 0L, false, null, vendorConfiguration3, !Intrinsics.areEqual((Object)this.analyticsTracking, (Object)false) && configuration.getAnalyticsTracking(), !Intrinsics.areEqual((Object)this.bugsnagReporting, (Object)false) && configuration.getBugsnagReporting(), 0L, null, 0x31FFFFF, null);
        }
        catch (JsonProcessingException e) {
            throw new ConfigurationException("Error parsing config file " + marathonfile.getAbsolutePath(), e);
        }
    }

    @NotNull
    public final String serialize(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        String string = this.mapper.writeValueAsString((Object)configuration);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        return string;
    }
}

