/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.serialization.yaml;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.malinskiy.marathon.config.AnalyticsConfiguration;
import com.malinskiy.marathon.config.serialization.time.InstantTimeProvider;
import com.malinskiy.marathon.config.serialization.yaml.ExecutionTimeSortingStrategyConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.FileDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.FixedSizeBatchingStrategyConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.GraphiteConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.InfluxDbConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.ProbabilityBasedFlakinessStrategyConfigurationDeserializer;
import com.malinskiy.marathon.config.serialization.yaml.RegexSerializer;
import com.malinskiy.marathon.config.serialization.yaml.RetentionPolicyConfigurationDeserializer;
import com.malinskiy.marathon.config.strategy.BatchingStrategyConfiguration;
import com.malinskiy.marathon.config.strategy.FlakinessStrategyConfiguration;
import com.malinskiy.marathon.config.strategy.SortingStrategyConfiguration;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/malinskiy/marathon/config/serialization/yaml/SerializeModule;", "Lcom/fasterxml/jackson/databind/module/SimpleModule;", "instantTimeProvider", "Lcom/malinskiy/marathon/config/serialization/time/InstantTimeProvider;", "marathonfileDir", "Ljava/io/File;", "(Lcom/malinskiy/marathon/config/serialization/time/InstantTimeProvider;Ljava/io/File;)V", "configuration"})
public final class SerializeModule
extends SimpleModule {
    public SerializeModule(@NotNull InstantTimeProvider instantTimeProvider, @NotNull File marathonfileDir) {
        Intrinsics.checkNotNullParameter((Object)instantTimeProvider, (String)"instantTimeProvider");
        Intrinsics.checkNotNullParameter((Object)marathonfileDir, (String)"marathonfileDir");
        this.addDeserializer(AnalyticsConfiguration.InfluxDbConfiguration.class, (JsonDeserializer)new InfluxDbConfigurationDeserializer());
        this.addDeserializer(AnalyticsConfiguration.GraphiteConfiguration.class, (JsonDeserializer)new GraphiteConfigurationDeserializer());
        this.addDeserializer(AnalyticsConfiguration.InfluxDbConfiguration.RetentionPolicyConfiguration.class, (JsonDeserializer)new RetentionPolicyConfigurationDeserializer());
        this.addDeserializer(SortingStrategyConfiguration.ExecutionTimeSortingStrategyConfiguration.class, (JsonDeserializer)new ExecutionTimeSortingStrategyConfigurationDeserializer(instantTimeProvider));
        this.addDeserializer(FlakinessStrategyConfiguration.ProbabilityBasedFlakinessStrategyConfiguration.class, (JsonDeserializer)new ProbabilityBasedFlakinessStrategyConfigurationDeserializer(instantTimeProvider));
        this.addDeserializer(BatchingStrategyConfiguration.FixedSizeBatchingStrategyConfiguration.class, (JsonDeserializer)new FixedSizeBatchingStrategyConfigurationDeserializer(instantTimeProvider));
        this.addSerializer(Regex.class, (JsonSerializer)new RegexSerializer());
        this.addDeserializer(File.class, (JsonDeserializer)new FileDeserializer(marathonfileDir));
    }
}

