/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.vendor;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import com.malinskiy.marathon.config.vendor.android.AdbEndpoint;
import com.malinskiy.marathon.config.vendor.android.AllureConfiguration;
import com.malinskiy.marathon.config.vendor.android.AndroidTestBundleConfiguration;
import com.malinskiy.marathon.config.vendor.android.FileSyncConfiguration;
import com.malinskiy.marathon.config.vendor.android.ScreenRecordConfiguration;
import com.malinskiy.marathon.config.vendor.android.SerialStrategy;
import com.malinskiy.marathon.config.vendor.android.TestAccessConfiguration;
import com.malinskiy.marathon.config.vendor.android.TestParserConfiguration;
import com.malinskiy.marathon.config.vendor.apple.AppleTestBundleConfiguration;
import com.malinskiy.marathon.config.vendor.apple.RsyncConfiguration;
import com.malinskiy.marathon.config.vendor.apple.SshConfiguration;
import com.malinskiy.marathon.config.vendor.apple.TestParserConfiguration;
import com.malinskiy.marathon.config.vendor.apple.ThreadingConfiguration;
import com.malinskiy.marathon.config.vendor.apple.TimeoutConfiguration;
import com.malinskiy.marathon.config.vendor.apple.ios.LifecycleConfiguration;
import com.malinskiy.marathon.config.vendor.apple.ios.PermissionsConfiguration;
import com.malinskiy.marathon.config.vendor.apple.ios.SigningConfiguration;
import com.malinskiy.marathon.config.vendor.apple.ios.XcresultConfiguration;
import com.malinskiy.marathon.config.vendor.apple.ios.XctestrunEnvConfiguration;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=AndroidConfiguration.class, name="Android"), @JsonSubTypes.Type(value=IOSConfiguration.class, names={"iOS", "watchOS", "tvOS", "visionOS"}), @JsonSubTypes.Type(value=MacosConfiguration.class, name="macOS"), @JsonSubTypes.Type(value=StubVendorConfiguration.class, name="stub"), @JsonSubTypes.Type(value=EmptyVendorConfiguration.class, name="empty")})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0006\u0003\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Lcom/malinskiy/marathon/config/vendor/VendorConfiguration;", "", "()V", "AndroidConfiguration", "AndroidConfigurationBuilder", "EmptyVendorConfiguration", "IOSConfiguration", "MacosConfiguration", "StubVendorConfiguration", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$AndroidConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$EmptyVendorConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$IOSConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$MacosConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$StubVendorConfiguration;", "configuration"})
public abstract class VendorConfiguration {
    private VendorConfiguration() {
    }

    public /* synthetic */ VendorConfiguration(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\bB\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u009b\u0002\u0012\n\b\u0001\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0001\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0001\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0010\b\u0001\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u0010\b\u0003\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u0012\b\b\u0003\u0010\u000b\u001a\u00020\f\u0012\u0014\b\u0003\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\b\u0003\u0010\u0010\u001a\u00020\f\u0012\b\b\u0003\u0010\u0011\u001a\u00020\f\u0012\b\b\u0003\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0003\u0010\u0014\u001a\u00020\u000f\u0012\b\b\u0003\u0010\u0015\u001a\u00020\u0016\u0012\b\b\u0003\u0010\u0017\u001a\u00020\u0018\u0012\b\b\u0003\u0010\u0019\u001a\u00020\u001a\u0012\b\b\u0003\u0010\u001b\u001a\u00020\u001c\u0012\b\b\u0003\u0010\u001d\u001a\u00020\u001e\u0012\b\b\u0003\u0010\u001f\u001a\u00020 \u0012\b\b\u0003\u0010!\u001a\u00020\"\u0012\b\b\u0003\u0010#\u001a\u00020$\u0012\b\b\u0003\u0010%\u001a\u00020&\u0012\u000e\b\u0003\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0007\u0012\b\b\u0003\u0010)\u001a\u00020\f\u00a2\u0006\u0002\u0010*J\u000b\u0010Q\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010R\u001a\u00020\fH\u00c6\u0003J\t\u0010S\u001a\u00020\u0013H\u00c6\u0003J\t\u0010T\u001a\u00020\u000fH\u00c6\u0003J\t\u0010U\u001a\u00020\u0016H\u00c6\u0003J\t\u0010V\u001a\u00020\u0018H\u00c6\u0003J\t\u0010W\u001a\u00020\u001aH\u00c6\u0003J\t\u0010X\u001a\u00020\u001cH\u00c6\u0003J\t\u0010Y\u001a\u00020\u001eH\u00c6\u0003J\t\u0010Z\u001a\u00020 H\u00c6\u0003J\t\u0010[\u001a\u00020\"H\u00c6\u0003J\u000b\u0010\\\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010]\u001a\u00020$H\u00c6\u0003J\t\u0010^\u001a\u00020&H\u00c6\u0003J\u000f\u0010_\u001a\b\u0012\u0004\u0012\u00020(0\u0007H\u00c6\u0003J\t\u0010`\u001a\u00020\fH\u00c6\u0003J\u000b\u0010a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u00c6\u0003J\u0011\u0010c\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007H\u00c6\u0003J\u0011\u0010d\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007H\u00c6\u0003J\t\u0010e\u001a\u00020\fH\u00c6\u0003J\u0015\u0010f\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eH\u00c6\u0003J\t\u0010g\u001a\u00020\fH\u00c6\u0003J\u009f\u0002\u0010h\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00072\u0010\b\u0003\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00072\u0010\b\u0003\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00072\b\b\u0003\u0010\u000b\u001a\u00020\f2\u0014\b\u0003\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0003\u0010\u0010\u001a\u00020\f2\b\b\u0003\u0010\u0011\u001a\u00020\f2\b\b\u0003\u0010\u0012\u001a\u00020\u00132\b\b\u0003\u0010\u0014\u001a\u00020\u000f2\b\b\u0003\u0010\u0015\u001a\u00020\u00162\b\b\u0003\u0010\u0017\u001a\u00020\u00182\b\b\u0003\u0010\u0019\u001a\u00020\u001a2\b\b\u0003\u0010\u001b\u001a\u00020\u001c2\b\b\u0003\u0010\u001d\u001a\u00020\u001e2\b\b\u0003\u0010\u001f\u001a\u00020 2\b\b\u0003\u0010!\u001a\u00020\"2\b\b\u0003\u0010#\u001a\u00020$2\b\b\u0003\u0010%\u001a\u00020&2\u000e\b\u0003\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u00072\b\b\u0003\u0010)\u001a\u00020\fH\u00c6\u0001J\u0013\u0010i\u001a\u00020\f2\b\u0010j\u001a\u0004\u0018\u00010kH\u00d6\u0003J\t\u0010l\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010m\u001a\u00020\u0003J\t\u0010n\u001a\u00020\u000fH\u00d6\u0001J\u0006\u0010o\u001a\u00020pJ\u0012\u0010q\u001a\u00020p2\b\u0010r\u001a\u0004\u0018\u00010\u0003H\u0002R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0017\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00102R\u0011\u0010\u0010\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00105R\u0011\u0010)\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00105R\u0019\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010.R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010.R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010.R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u00102R\u0011\u0010\u0011\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u00105R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010JR\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010P\u00a8\u0006s"}, d2={"Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$AndroidConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration;", "androidSdk", "Ljava/io/File;", "applicationOutput", "testApplicationOutput", "splitApks", "", "extraApplicationsOutput", "outputs", "Lcom/malinskiy/marathon/config/vendor/android/AndroidTestBundleConfiguration;", "autoGrantPermission", "", "instrumentationArgs", "", "", "applicationPmClear", "testApplicationPmClear", "adbInitTimeoutMillis", "", "installOptions", "serialStrategy", "Lcom/malinskiy/marathon/config/vendor/android/SerialStrategy;", "screenRecordConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/ScreenRecordConfiguration;", "waitForDevicesTimeoutMillis", "", "allureConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/AllureConfiguration;", "timeoutConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/TimeoutConfiguration;", "fileSyncConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/FileSyncConfiguration;", "threadingConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/ThreadingConfiguration;", "testParserConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/TestParserConfiguration;", "testAccessConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/TestAccessConfiguration;", "adbServers", "Lcom/malinskiy/marathon/config/vendor/android/AdbEndpoint;", "disableWindowAnimation", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/util/Map;ZZILjava/lang/String;Lcom/malinskiy/marathon/config/vendor/android/SerialStrategy;Lcom/malinskiy/marathon/config/vendor/android/ScreenRecordConfiguration;JLcom/malinskiy/marathon/config/vendor/android/AllureConfiguration;Lcom/malinskiy/marathon/config/vendor/android/TimeoutConfiguration;Lcom/malinskiy/marathon/config/vendor/android/FileSyncConfiguration;Lcom/malinskiy/marathon/config/vendor/android/ThreadingConfiguration;Lcom/malinskiy/marathon/config/vendor/android/TestParserConfiguration;Lcom/malinskiy/marathon/config/vendor/android/TestAccessConfiguration;Ljava/util/List;Z)V", "getAdbInitTimeoutMillis", "()I", "getAdbServers", "()Ljava/util/List;", "getAllureConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/AllureConfiguration;", "getAndroidSdk", "()Ljava/io/File;", "getApplicationOutput", "getApplicationPmClear", "()Z", "getAutoGrantPermission", "getDisableWindowAnimation", "getExtraApplicationsOutput", "getFileSyncConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/FileSyncConfiguration;", "getInstallOptions", "()Ljava/lang/String;", "getInstrumentationArgs", "()Ljava/util/Map;", "getOutputs", "getScreenRecordConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/ScreenRecordConfiguration;", "getSerialStrategy", "()Lcom/malinskiy/marathon/config/vendor/android/SerialStrategy;", "getSplitApks", "getTestAccessConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/TestAccessConfiguration;", "getTestApplicationOutput", "getTestApplicationPmClear", "getTestParserConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/TestParserConfiguration;", "getThreadingConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/ThreadingConfiguration;", "getTimeoutConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/TimeoutConfiguration;", "getWaitForDevicesTimeoutMillis", "()J", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component20", "component21", "component22", "component23", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "safeAndroidSdk", "toString", "validate", "", "validateFile", "file", "configuration"})
    @SourceDebugExtension(value={"SMAP\nVendorConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VendorConfiguration.kt\ncom/malinskiy/marathon/config/vendor/VendorConfiguration$AndroidConfiguration\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1855#2,2:218\n1855#2,2:220\n1855#2:222\n1855#2,2:223\n1855#2,2:225\n1856#2:227\n*S KotlinDebug\n*F\n+ 1 VendorConfiguration.kt\ncom/malinskiy/marathon/config/vendor/VendorConfiguration$AndroidConfiguration\n*L\n83#1:218,2\n84#1:220,2\n85#1:222\n88#1:223,2\n89#1:225,2\n85#1:227\n*E\n"})
    public static final class AndroidConfiguration
    extends VendorConfiguration {
        @Nullable
        private final File androidSdk;
        @Nullable
        private final File applicationOutput;
        @Nullable
        private final File testApplicationOutput;
        @Nullable
        private final List<File> splitApks;
        @Nullable
        private final List<File> extraApplicationsOutput;
        @Nullable
        private final List<AndroidTestBundleConfiguration> outputs;
        private final boolean autoGrantPermission;
        @NotNull
        private final Map<String, String> instrumentationArgs;
        private final boolean applicationPmClear;
        private final boolean testApplicationPmClear;
        private final int adbInitTimeoutMillis;
        @NotNull
        private final String installOptions;
        @NotNull
        private final SerialStrategy serialStrategy;
        @NotNull
        private final ScreenRecordConfiguration screenRecordConfiguration;
        private final long waitForDevicesTimeoutMillis;
        @NotNull
        private final AllureConfiguration allureConfiguration;
        @NotNull
        private final com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration timeoutConfiguration;
        @NotNull
        private final FileSyncConfiguration fileSyncConfiguration;
        @NotNull
        private final com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration threadingConfiguration;
        @NotNull
        private final com.malinskiy.marathon.config.vendor.android.TestParserConfiguration testParserConfiguration;
        @NotNull
        private final TestAccessConfiguration testAccessConfiguration;
        @NotNull
        private final List<AdbEndpoint> adbServers;
        private final boolean disableWindowAnimation;

        public AndroidConfiguration(@JsonProperty(value="androidSdk") @Nullable File androidSdk, @JsonProperty(value="applicationApk") @Nullable File applicationOutput, @JsonProperty(value="testApplicationApk") @Nullable File testApplicationOutput, @JsonProperty(value="splitApks") @Nullable List<? extends File> splitApks, @JsonProperty(value="extraApplicationsApk") @Nullable List<? extends File> extraApplicationsOutput, @JsonProperty(value="outputs") @Nullable List<AndroidTestBundleConfiguration> outputs, @JsonProperty(value="autoGrantPermission") boolean autoGrantPermission, @JsonProperty(value="instrumentationArgs") @NotNull Map<String, String> instrumentationArgs, @JsonProperty(value="applicationPmClear") boolean applicationPmClear, @JsonProperty(value="testApplicationPmClear") boolean testApplicationPmClear, @JsonProperty(value="adbInitTimeoutMillis") int adbInitTimeoutMillis, @JsonProperty(value="installOptions") @NotNull String installOptions, @JsonProperty(value="serialStrategy") @NotNull SerialStrategy serialStrategy, @JsonProperty(value="screenRecordConfiguration") @NotNull ScreenRecordConfiguration screenRecordConfiguration, @JsonProperty(value="waitForDevicesTimeoutMillis") long waitForDevicesTimeoutMillis, @JsonProperty(value="allureConfiguration") @NotNull AllureConfiguration allureConfiguration, @JsonProperty(value="timeoutConfiguration") @NotNull com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration timeoutConfiguration, @JsonProperty(value="fileSyncConfiguration") @NotNull FileSyncConfiguration fileSyncConfiguration, @JsonProperty(value="threadingConfiguration") @NotNull com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration threadingConfiguration, @JsonProperty(value="testParserConfiguration") @NotNull com.malinskiy.marathon.config.vendor.android.TestParserConfiguration testParserConfiguration, @JsonProperty(value="testAccessConfiguration") @NotNull TestAccessConfiguration testAccessConfiguration, @JsonProperty(value="adbServers") @NotNull List<AdbEndpoint> adbServers, @JsonProperty(value="disableWindowAnimation") boolean disableWindowAnimation) {
            Intrinsics.checkNotNullParameter(instrumentationArgs, (String)"instrumentationArgs");
            Intrinsics.checkNotNullParameter((Object)installOptions, (String)"installOptions");
            Intrinsics.checkNotNullParameter((Object)((Object)serialStrategy), (String)"serialStrategy");
            Intrinsics.checkNotNullParameter((Object)screenRecordConfiguration, (String)"screenRecordConfiguration");
            Intrinsics.checkNotNullParameter((Object)allureConfiguration, (String)"allureConfiguration");
            Intrinsics.checkNotNullParameter((Object)timeoutConfiguration, (String)"timeoutConfiguration");
            Intrinsics.checkNotNullParameter((Object)fileSyncConfiguration, (String)"fileSyncConfiguration");
            Intrinsics.checkNotNullParameter((Object)threadingConfiguration, (String)"threadingConfiguration");
            Intrinsics.checkNotNullParameter((Object)testParserConfiguration, (String)"testParserConfiguration");
            Intrinsics.checkNotNullParameter((Object)testAccessConfiguration, (String)"testAccessConfiguration");
            Intrinsics.checkNotNullParameter(adbServers, (String)"adbServers");
            super(null);
            this.androidSdk = androidSdk;
            this.applicationOutput = applicationOutput;
            this.testApplicationOutput = testApplicationOutput;
            this.splitApks = splitApks;
            this.extraApplicationsOutput = extraApplicationsOutput;
            this.outputs = outputs;
            this.autoGrantPermission = autoGrantPermission;
            this.instrumentationArgs = instrumentationArgs;
            this.applicationPmClear = applicationPmClear;
            this.testApplicationPmClear = testApplicationPmClear;
            this.adbInitTimeoutMillis = adbInitTimeoutMillis;
            this.installOptions = installOptions;
            this.serialStrategy = serialStrategy;
            this.screenRecordConfiguration = screenRecordConfiguration;
            this.waitForDevicesTimeoutMillis = waitForDevicesTimeoutMillis;
            this.allureConfiguration = allureConfiguration;
            this.timeoutConfiguration = timeoutConfiguration;
            this.fileSyncConfiguration = fileSyncConfiguration;
            this.threadingConfiguration = threadingConfiguration;
            this.testParserConfiguration = testParserConfiguration;
            this.testAccessConfiguration = testAccessConfiguration;
            this.adbServers = adbServers;
            this.disableWindowAnimation = disableWindowAnimation;
        }

        public /* synthetic */ AndroidConfiguration(File file, File file2, File file3, List list, List list2, List list3, boolean bl, Map map, boolean bl2, boolean bl3, int n, String string, SerialStrategy serialStrategy, ScreenRecordConfiguration screenRecordConfiguration, long l, AllureConfiguration allureConfiguration, com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration timeoutConfiguration, FileSyncConfiguration fileSyncConfiguration, com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration threadingConfiguration, com.malinskiy.marathon.config.vendor.android.TestParserConfiguration testParserConfiguration, TestAccessConfiguration testAccessConfiguration, List list4, boolean bl4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 0x20) != 0) {
                list3 = null;
            }
            if ((n2 & 0x40) != 0) {
                bl = false;
            }
            if ((n2 & 0x80) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n2 & 0x100) != 0) {
                bl2 = false;
            }
            if ((n2 & 0x200) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x400) != 0) {
                n = 30000;
            }
            if ((n2 & 0x800) != 0) {
                string = "";
            }
            if ((n2 & 0x1000) != 0) {
                serialStrategy = SerialStrategy.AUTOMATIC;
            }
            if ((n2 & 0x2000) != 0) {
                screenRecordConfiguration = new ScreenRecordConfiguration(null, null, null, 7, null);
            }
            if ((n2 & 0x4000) != 0) {
                l = 30000L;
            }
            if ((n2 & 0x8000) != 0) {
                allureConfiguration = new AllureConfiguration(false, null, null, 7, null);
            }
            if ((n2 & 0x10000) != 0) {
                timeoutConfiguration = new com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
            }
            if ((n2 & 0x20000) != 0) {
                fileSyncConfiguration = new FileSyncConfiguration(null, null, 3, null);
            }
            if ((n2 & 0x40000) != 0) {
                threadingConfiguration = new com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration(0, 0, 0, 7, null);
            }
            if ((n2 & 0x80000) != 0) {
                testParserConfiguration = TestParserConfiguration.LocalTestParserConfiguration.INSTANCE;
            }
            if ((n2 & 0x100000) != 0) {
                testAccessConfiguration = new TestAccessConfiguration(false, false, false, null, 15, null);
            }
            if ((n2 & 0x200000) != 0) {
                list4 = CollectionsKt.listOf((Object)new AdbEndpoint(null, 0, 3, null));
            }
            if ((n2 & 0x400000) != 0) {
                bl4 = true;
            }
            this(file, file2, file3, list, list2, list3, bl, map, bl2, bl3, n, string, serialStrategy, screenRecordConfiguration, l, allureConfiguration, timeoutConfiguration, fileSyncConfiguration, threadingConfiguration, testParserConfiguration, testAccessConfiguration, list4, bl4);
        }

        @Nullable
        public final File getAndroidSdk() {
            return this.androidSdk;
        }

        @Nullable
        public final File getApplicationOutput() {
            return this.applicationOutput;
        }

        @Nullable
        public final File getTestApplicationOutput() {
            return this.testApplicationOutput;
        }

        @Nullable
        public final List<File> getSplitApks() {
            return this.splitApks;
        }

        @Nullable
        public final List<File> getExtraApplicationsOutput() {
            return this.extraApplicationsOutput;
        }

        @Nullable
        public final List<AndroidTestBundleConfiguration> getOutputs() {
            return this.outputs;
        }

        public final boolean getAutoGrantPermission() {
            return this.autoGrantPermission;
        }

        @NotNull
        public final Map<String, String> getInstrumentationArgs() {
            return this.instrumentationArgs;
        }

        public final boolean getApplicationPmClear() {
            return this.applicationPmClear;
        }

        public final boolean getTestApplicationPmClear() {
            return this.testApplicationPmClear;
        }

        public final int getAdbInitTimeoutMillis() {
            return this.adbInitTimeoutMillis;
        }

        @NotNull
        public final String getInstallOptions() {
            return this.installOptions;
        }

        @NotNull
        public final SerialStrategy getSerialStrategy() {
            return this.serialStrategy;
        }

        @NotNull
        public final ScreenRecordConfiguration getScreenRecordConfiguration() {
            return this.screenRecordConfiguration;
        }

        public final long getWaitForDevicesTimeoutMillis() {
            return this.waitForDevicesTimeoutMillis;
        }

        @NotNull
        public final AllureConfiguration getAllureConfiguration() {
            return this.allureConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration getTimeoutConfiguration() {
            return this.timeoutConfiguration;
        }

        @NotNull
        public final FileSyncConfiguration getFileSyncConfiguration() {
            return this.fileSyncConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration getThreadingConfiguration() {
            return this.threadingConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.TestParserConfiguration getTestParserConfiguration() {
            return this.testParserConfiguration;
        }

        @NotNull
        public final TestAccessConfiguration getTestAccessConfiguration() {
            return this.testAccessConfiguration;
        }

        @NotNull
        public final List<AdbEndpoint> getAdbServers() {
            return this.adbServers;
        }

        public final boolean getDisableWindowAnimation() {
            return this.disableWindowAnimation;
        }

        @NotNull
        public final File safeAndroidSdk() {
            File file = this.androidSdk;
            if (file == null) {
                throw new ConfigurationException("No android SDK path specified");
            }
            return file;
        }

        public final void validate() {
            block8: {
                Object it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                this.validateFile(this.applicationOutput);
                this.validateFile(this.testApplicationOutput);
                List<File> list = this.splitApks;
                if (list != null) {
                    $this$forEach$iv = list;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (File)element$iv;
                        boolean bl = false;
                        this.validateFile((File)it);
                    }
                }
                List<File> list2 = this.extraApplicationsOutput;
                if (list2 != null) {
                    $this$forEach$iv = list2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (File)element$iv;
                        boolean bl = false;
                        this.validateFile((File)it);
                    }
                }
                List<AndroidTestBundleConfiguration> list3 = this.outputs;
                if (list3 == null) break block8;
                $this$forEach$iv = list3;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File apk;
                    boolean $i$f$forEach2;
                    Iterable $this$forEach$iv2;
                    it = (AndroidTestBundleConfiguration)element$iv;
                    boolean bl = false;
                    this.validateFile(((AndroidTestBundleConfiguration)it).getApplication());
                    this.validateFile(((AndroidTestBundleConfiguration)it).getTestApplication());
                    List<File> list4 = ((AndroidTestBundleConfiguration)it).getSplitApks();
                    if (list4 != null) {
                        $this$forEach$iv2 = list4;
                        $i$f$forEach2 = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            apk = (File)element$iv2;
                            boolean bl2 = false;
                            this.validateFile(apk);
                        }
                    }
                    List<File> list5 = ((AndroidTestBundleConfiguration)it).getExtraApplications();
                    if (list5 == null) continue;
                    $this$forEach$iv2 = list5;
                    $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        apk = (File)element$iv2;
                        boolean bl3 = false;
                        this.validateFile(apk);
                    }
                }
            }
        }

        private final void validateFile(File file) {
            if (file != null) {
                if (!file.exists()) {
                    throw new ConfigurationException(file.getAbsolutePath() + " does not exist");
                }
                if (!file.isFile()) {
                    throw new ConfigurationException(file.getAbsolutePath() + " must be a regular file");
                }
            }
        }

        @Nullable
        public final File component1() {
            return this.androidSdk;
        }

        @Nullable
        public final File component2() {
            return this.applicationOutput;
        }

        @Nullable
        public final File component3() {
            return this.testApplicationOutput;
        }

        @Nullable
        public final List<File> component4() {
            return this.splitApks;
        }

        @Nullable
        public final List<File> component5() {
            return this.extraApplicationsOutput;
        }

        @Nullable
        public final List<AndroidTestBundleConfiguration> component6() {
            return this.outputs;
        }

        public final boolean component7() {
            return this.autoGrantPermission;
        }

        @NotNull
        public final Map<String, String> component8() {
            return this.instrumentationArgs;
        }

        public final boolean component9() {
            return this.applicationPmClear;
        }

        public final boolean component10() {
            return this.testApplicationPmClear;
        }

        public final int component11() {
            return this.adbInitTimeoutMillis;
        }

        @NotNull
        public final String component12() {
            return this.installOptions;
        }

        @NotNull
        public final SerialStrategy component13() {
            return this.serialStrategy;
        }

        @NotNull
        public final ScreenRecordConfiguration component14() {
            return this.screenRecordConfiguration;
        }

        public final long component15() {
            return this.waitForDevicesTimeoutMillis;
        }

        @NotNull
        public final AllureConfiguration component16() {
            return this.allureConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration component17() {
            return this.timeoutConfiguration;
        }

        @NotNull
        public final FileSyncConfiguration component18() {
            return this.fileSyncConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration component19() {
            return this.threadingConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.TestParserConfiguration component20() {
            return this.testParserConfiguration;
        }

        @NotNull
        public final TestAccessConfiguration component21() {
            return this.testAccessConfiguration;
        }

        @NotNull
        public final List<AdbEndpoint> component22() {
            return this.adbServers;
        }

        public final boolean component23() {
            return this.disableWindowAnimation;
        }

        @NotNull
        public final AndroidConfiguration copy(@JsonProperty(value="androidSdk") @Nullable File androidSdk, @JsonProperty(value="applicationApk") @Nullable File applicationOutput, @JsonProperty(value="testApplicationApk") @Nullable File testApplicationOutput, @JsonProperty(value="splitApks") @Nullable List<? extends File> splitApks, @JsonProperty(value="extraApplicationsApk") @Nullable List<? extends File> extraApplicationsOutput, @JsonProperty(value="outputs") @Nullable List<AndroidTestBundleConfiguration> outputs, @JsonProperty(value="autoGrantPermission") boolean autoGrantPermission, @JsonProperty(value="instrumentationArgs") @NotNull Map<String, String> instrumentationArgs, @JsonProperty(value="applicationPmClear") boolean applicationPmClear, @JsonProperty(value="testApplicationPmClear") boolean testApplicationPmClear, @JsonProperty(value="adbInitTimeoutMillis") int adbInitTimeoutMillis, @JsonProperty(value="installOptions") @NotNull String installOptions, @JsonProperty(value="serialStrategy") @NotNull SerialStrategy serialStrategy, @JsonProperty(value="screenRecordConfiguration") @NotNull ScreenRecordConfiguration screenRecordConfiguration, @JsonProperty(value="waitForDevicesTimeoutMillis") long waitForDevicesTimeoutMillis, @JsonProperty(value="allureConfiguration") @NotNull AllureConfiguration allureConfiguration, @JsonProperty(value="timeoutConfiguration") @NotNull com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration timeoutConfiguration, @JsonProperty(value="fileSyncConfiguration") @NotNull FileSyncConfiguration fileSyncConfiguration, @JsonProperty(value="threadingConfiguration") @NotNull com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration threadingConfiguration, @JsonProperty(value="testParserConfiguration") @NotNull com.malinskiy.marathon.config.vendor.android.TestParserConfiguration testParserConfiguration, @JsonProperty(value="testAccessConfiguration") @NotNull TestAccessConfiguration testAccessConfiguration, @JsonProperty(value="adbServers") @NotNull List<AdbEndpoint> adbServers, @JsonProperty(value="disableWindowAnimation") boolean disableWindowAnimation) {
            Intrinsics.checkNotNullParameter(instrumentationArgs, (String)"instrumentationArgs");
            Intrinsics.checkNotNullParameter((Object)installOptions, (String)"installOptions");
            Intrinsics.checkNotNullParameter((Object)((Object)serialStrategy), (String)"serialStrategy");
            Intrinsics.checkNotNullParameter((Object)screenRecordConfiguration, (String)"screenRecordConfiguration");
            Intrinsics.checkNotNullParameter((Object)allureConfiguration, (String)"allureConfiguration");
            Intrinsics.checkNotNullParameter((Object)timeoutConfiguration, (String)"timeoutConfiguration");
            Intrinsics.checkNotNullParameter((Object)fileSyncConfiguration, (String)"fileSyncConfiguration");
            Intrinsics.checkNotNullParameter((Object)threadingConfiguration, (String)"threadingConfiguration");
            Intrinsics.checkNotNullParameter((Object)testParserConfiguration, (String)"testParserConfiguration");
            Intrinsics.checkNotNullParameter((Object)testAccessConfiguration, (String)"testAccessConfiguration");
            Intrinsics.checkNotNullParameter(adbServers, (String)"adbServers");
            return new AndroidConfiguration(androidSdk, applicationOutput, testApplicationOutput, splitApks, extraApplicationsOutput, outputs, autoGrantPermission, instrumentationArgs, applicationPmClear, testApplicationPmClear, adbInitTimeoutMillis, installOptions, serialStrategy, screenRecordConfiguration, waitForDevicesTimeoutMillis, allureConfiguration, timeoutConfiguration, fileSyncConfiguration, threadingConfiguration, testParserConfiguration, testAccessConfiguration, adbServers, disableWindowAnimation);
        }

        public static /* synthetic */ AndroidConfiguration copy$default(AndroidConfiguration androidConfiguration, File file, File file2, File file3, List list, List list2, List list3, boolean bl, Map map, boolean bl2, boolean bl3, int n, String string, SerialStrategy serialStrategy, ScreenRecordConfiguration screenRecordConfiguration, long l, AllureConfiguration allureConfiguration, com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration timeoutConfiguration, FileSyncConfiguration fileSyncConfiguration, com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration threadingConfiguration, com.malinskiy.marathon.config.vendor.android.TestParserConfiguration testParserConfiguration, TestAccessConfiguration testAccessConfiguration, List list4, boolean bl4, int n2, Object object) {
            if ((n2 & 1) != 0) {
                file = androidConfiguration.androidSdk;
            }
            if ((n2 & 2) != 0) {
                file2 = androidConfiguration.applicationOutput;
            }
            if ((n2 & 4) != 0) {
                file3 = androidConfiguration.testApplicationOutput;
            }
            if ((n2 & 8) != 0) {
                list = androidConfiguration.splitApks;
            }
            if ((n2 & 0x10) != 0) {
                list2 = androidConfiguration.extraApplicationsOutput;
            }
            if ((n2 & 0x20) != 0) {
                list3 = androidConfiguration.outputs;
            }
            if ((n2 & 0x40) != 0) {
                bl = androidConfiguration.autoGrantPermission;
            }
            if ((n2 & 0x80) != 0) {
                map = androidConfiguration.instrumentationArgs;
            }
            if ((n2 & 0x100) != 0) {
                bl2 = androidConfiguration.applicationPmClear;
            }
            if ((n2 & 0x200) != 0) {
                bl3 = androidConfiguration.testApplicationPmClear;
            }
            if ((n2 & 0x400) != 0) {
                n = androidConfiguration.adbInitTimeoutMillis;
            }
            if ((n2 & 0x800) != 0) {
                string = androidConfiguration.installOptions;
            }
            if ((n2 & 0x1000) != 0) {
                serialStrategy = androidConfiguration.serialStrategy;
            }
            if ((n2 & 0x2000) != 0) {
                screenRecordConfiguration = androidConfiguration.screenRecordConfiguration;
            }
            if ((n2 & 0x4000) != 0) {
                l = androidConfiguration.waitForDevicesTimeoutMillis;
            }
            if ((n2 & 0x8000) != 0) {
                allureConfiguration = androidConfiguration.allureConfiguration;
            }
            if ((n2 & 0x10000) != 0) {
                timeoutConfiguration = androidConfiguration.timeoutConfiguration;
            }
            if ((n2 & 0x20000) != 0) {
                fileSyncConfiguration = androidConfiguration.fileSyncConfiguration;
            }
            if ((n2 & 0x40000) != 0) {
                threadingConfiguration = androidConfiguration.threadingConfiguration;
            }
            if ((n2 & 0x80000) != 0) {
                testParserConfiguration = androidConfiguration.testParserConfiguration;
            }
            if ((n2 & 0x100000) != 0) {
                testAccessConfiguration = androidConfiguration.testAccessConfiguration;
            }
            if ((n2 & 0x200000) != 0) {
                list4 = androidConfiguration.adbServers;
            }
            if ((n2 & 0x400000) != 0) {
                bl4 = androidConfiguration.disableWindowAnimation;
            }
            return androidConfiguration.copy(file, file2, file3, list, list2, list3, bl, map, bl2, bl3, n, string, serialStrategy, screenRecordConfiguration, l, allureConfiguration, timeoutConfiguration, fileSyncConfiguration, threadingConfiguration, testParserConfiguration, testAccessConfiguration, list4, bl4);
        }

        @NotNull
        public String toString() {
            return "AndroidConfiguration(androidSdk=" + this.androidSdk + ", applicationOutput=" + this.applicationOutput + ", testApplicationOutput=" + this.testApplicationOutput + ", splitApks=" + this.splitApks + ", extraApplicationsOutput=" + this.extraApplicationsOutput + ", outputs=" + this.outputs + ", autoGrantPermission=" + this.autoGrantPermission + ", instrumentationArgs=" + this.instrumentationArgs + ", applicationPmClear=" + this.applicationPmClear + ", testApplicationPmClear=" + this.testApplicationPmClear + ", adbInitTimeoutMillis=" + this.adbInitTimeoutMillis + ", installOptions=" + this.installOptions + ", serialStrategy=" + this.serialStrategy + ", screenRecordConfiguration=" + this.screenRecordConfiguration + ", waitForDevicesTimeoutMillis=" + this.waitForDevicesTimeoutMillis + ", allureConfiguration=" + this.allureConfiguration + ", timeoutConfiguration=" + this.timeoutConfiguration + ", fileSyncConfiguration=" + this.fileSyncConfiguration + ", threadingConfiguration=" + this.threadingConfiguration + ", testParserConfiguration=" + this.testParserConfiguration + ", testAccessConfiguration=" + this.testAccessConfiguration + ", adbServers=" + this.adbServers + ", disableWindowAnimation=" + this.disableWindowAnimation + ")";
        }

        public int hashCode() {
            int result = this.androidSdk == null ? 0 : this.androidSdk.hashCode();
            result = result * 31 + (this.applicationOutput == null ? 0 : this.applicationOutput.hashCode());
            result = result * 31 + (this.testApplicationOutput == null ? 0 : this.testApplicationOutput.hashCode());
            result = result * 31 + (this.splitApks == null ? 0 : ((Object)this.splitApks).hashCode());
            result = result * 31 + (this.extraApplicationsOutput == null ? 0 : ((Object)this.extraApplicationsOutput).hashCode());
            result = result * 31 + (this.outputs == null ? 0 : ((Object)this.outputs).hashCode());
            int n = this.autoGrantPermission ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + ((Object)this.instrumentationArgs).hashCode();
            int n2 = this.applicationPmClear ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            int n3 = this.testApplicationPmClear ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            result = result * 31 + Integer.hashCode(this.adbInitTimeoutMillis);
            result = result * 31 + this.installOptions.hashCode();
            result = result * 31 + this.serialStrategy.hashCode();
            result = result * 31 + this.screenRecordConfiguration.hashCode();
            result = result * 31 + Long.hashCode(this.waitForDevicesTimeoutMillis);
            result = result * 31 + this.allureConfiguration.hashCode();
            result = result * 31 + this.timeoutConfiguration.hashCode();
            result = result * 31 + this.fileSyncConfiguration.hashCode();
            result = result * 31 + this.threadingConfiguration.hashCode();
            result = result * 31 + this.testParserConfiguration.hashCode();
            result = result * 31 + this.testAccessConfiguration.hashCode();
            result = result * 31 + ((Object)this.adbServers).hashCode();
            int n4 = this.disableWindowAnimation ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AndroidConfiguration)) {
                return false;
            }
            AndroidConfiguration androidConfiguration = (AndroidConfiguration)other;
            if (!Intrinsics.areEqual((Object)this.androidSdk, (Object)androidConfiguration.androidSdk)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.applicationOutput, (Object)androidConfiguration.applicationOutput)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.testApplicationOutput, (Object)androidConfiguration.testApplicationOutput)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.splitApks, androidConfiguration.splitApks)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.extraApplicationsOutput, androidConfiguration.extraApplicationsOutput)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.outputs, androidConfiguration.outputs)) {
                return false;
            }
            if (this.autoGrantPermission != androidConfiguration.autoGrantPermission) {
                return false;
            }
            if (!Intrinsics.areEqual(this.instrumentationArgs, androidConfiguration.instrumentationArgs)) {
                return false;
            }
            if (this.applicationPmClear != androidConfiguration.applicationPmClear) {
                return false;
            }
            if (this.testApplicationPmClear != androidConfiguration.testApplicationPmClear) {
                return false;
            }
            if (this.adbInitTimeoutMillis != androidConfiguration.adbInitTimeoutMillis) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.installOptions, (Object)androidConfiguration.installOptions)) {
                return false;
            }
            if (this.serialStrategy != androidConfiguration.serialStrategy) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.screenRecordConfiguration, (Object)androidConfiguration.screenRecordConfiguration)) {
                return false;
            }
            if (this.waitForDevicesTimeoutMillis != androidConfiguration.waitForDevicesTimeoutMillis) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.allureConfiguration, (Object)androidConfiguration.allureConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timeoutConfiguration, (Object)androidConfiguration.timeoutConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fileSyncConfiguration, (Object)androidConfiguration.fileSyncConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.threadingConfiguration, (Object)androidConfiguration.threadingConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.testParserConfiguration, (Object)androidConfiguration.testParserConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.testAccessConfiguration, (Object)androidConfiguration.testAccessConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.adbServers, androidConfiguration.adbServers)) {
                return false;
            }
            return this.disableWindowAnimation == androidConfiguration.disableWindowAnimation;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010w\u001a\u00020xR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\"\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\"\"\u0004\b*\u0010$R\"\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\r\"\u0004\b-\u0010\u000fR\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109R&\u0010:\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002050;X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\"\u0010@\u001a\n\u0012\u0004\u0012\u00020A\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010\r\"\u0004\bC\u0010\u000fR\u001a\u0010D\u001a\u00020EX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\"\u0010P\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\r\"\u0004\bR\u0010\u000fR\u001a\u0010S\u001a\u00020TX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bU\u0010V\"\u0004\bW\u0010XR\u001c\u0010Y\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bZ\u0010\u0019\"\u0004\b[\u0010\u001bR\u001a\u0010\\\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\"\"\u0004\b^\u0010$R\u001a\u0010_\u001a\u00020`X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR\u001a\u0010e\u001a\u00020fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010h\"\u0004\bi\u0010jR\u001a\u0010k\u001a\u00020lX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bm\u0010n\"\u0004\bo\u0010pR\u001a\u0010q\u001a\u00020rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bs\u0010t\"\u0004\bu\u0010v\u00a8\u0006y"}, d2={"Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$AndroidConfigurationBuilder;", "", "()V", "adbInitTimeoutMillis", "", "getAdbInitTimeoutMillis", "()I", "setAdbInitTimeoutMillis", "(I)V", "adbServers", "", "Lcom/malinskiy/marathon/config/vendor/android/AdbEndpoint;", "getAdbServers", "()Ljava/util/List;", "setAdbServers", "(Ljava/util/List;)V", "allureConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/AllureConfiguration;", "getAllureConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/AllureConfiguration;", "setAllureConfiguration", "(Lcom/malinskiy/marathon/config/vendor/android/AllureConfiguration;)V", "androidSdk", "Ljava/io/File;", "getAndroidSdk", "()Ljava/io/File;", "setAndroidSdk", "(Ljava/io/File;)V", "applicationOutput", "getApplicationOutput", "setApplicationOutput", "applicationPmClear", "", "getApplicationPmClear", "()Z", "setApplicationPmClear", "(Z)V", "autoGrantPermission", "getAutoGrantPermission", "setAutoGrantPermission", "disableWindowAnimation", "getDisableWindowAnimation", "setDisableWindowAnimation", "extraApplicationsOutput", "getExtraApplicationsOutput", "setExtraApplicationsOutput", "fileSyncConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/FileSyncConfiguration;", "getFileSyncConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/FileSyncConfiguration;", "setFileSyncConfiguration", "(Lcom/malinskiy/marathon/config/vendor/android/FileSyncConfiguration;)V", "installOptions", "", "getInstallOptions", "()Ljava/lang/String;", "setInstallOptions", "(Ljava/lang/String;)V", "instrumentationArgs", "", "getInstrumentationArgs", "()Ljava/util/Map;", "setInstrumentationArgs", "(Ljava/util/Map;)V", "outputs", "Lcom/malinskiy/marathon/config/vendor/android/AndroidTestBundleConfiguration;", "getOutputs", "setOutputs", "screenRecordConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/ScreenRecordConfiguration;", "getScreenRecordConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/ScreenRecordConfiguration;", "setScreenRecordConfiguration", "(Lcom/malinskiy/marathon/config/vendor/android/ScreenRecordConfiguration;)V", "serialStrategy", "Lcom/malinskiy/marathon/config/vendor/android/SerialStrategy;", "getSerialStrategy", "()Lcom/malinskiy/marathon/config/vendor/android/SerialStrategy;", "setSerialStrategy", "(Lcom/malinskiy/marathon/config/vendor/android/SerialStrategy;)V", "splitApks", "getSplitApks", "setSplitApks", "testAccessConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/TestAccessConfiguration;", "getTestAccessConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/TestAccessConfiguration;", "setTestAccessConfiguration", "(Lcom/malinskiy/marathon/config/vendor/android/TestAccessConfiguration;)V", "testApplicationOutput", "getTestApplicationOutput", "setTestApplicationOutput", "testApplicationPmClear", "getTestApplicationPmClear", "setTestApplicationPmClear", "testParserConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/TestParserConfiguration;", "getTestParserConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/TestParserConfiguration;", "setTestParserConfiguration", "(Lcom/malinskiy/marathon/config/vendor/android/TestParserConfiguration;)V", "threadingConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/ThreadingConfiguration;", "getThreadingConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/ThreadingConfiguration;", "setThreadingConfiguration", "(Lcom/malinskiy/marathon/config/vendor/android/ThreadingConfiguration;)V", "timeoutConfiguration", "Lcom/malinskiy/marathon/config/vendor/android/TimeoutConfiguration;", "getTimeoutConfiguration", "()Lcom/malinskiy/marathon/config/vendor/android/TimeoutConfiguration;", "setTimeoutConfiguration", "(Lcom/malinskiy/marathon/config/vendor/android/TimeoutConfiguration;)V", "waitForDevicesTimeoutMillis", "", "getWaitForDevicesTimeoutMillis", "()J", "setWaitForDevicesTimeoutMillis", "(J)V", "build", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$AndroidConfiguration;", "configuration"})
    public static final class AndroidConfigurationBuilder {
        @Nullable
        private File androidSdk;
        @Nullable
        private File applicationOutput;
        @Nullable
        private File testApplicationOutput;
        @Nullable
        private List<? extends File> extraApplicationsOutput;
        @Nullable
        private List<? extends File> splitApks;
        @Nullable
        private List<AndroidTestBundleConfiguration> outputs;
        private boolean autoGrantPermission;
        @NotNull
        private Map<String, String> instrumentationArgs = MapsKt.emptyMap();
        private boolean applicationPmClear;
        private boolean testApplicationPmClear;
        private int adbInitTimeoutMillis = 30000;
        @NotNull
        private String installOptions = "";
        @NotNull
        private SerialStrategy serialStrategy = SerialStrategy.AUTOMATIC;
        @NotNull
        private ScreenRecordConfiguration screenRecordConfiguration = new ScreenRecordConfiguration(null, null, null, 7, null);
        private long waitForDevicesTimeoutMillis = 30000L;
        @NotNull
        private AllureConfiguration allureConfiguration = new AllureConfiguration(false, null, null, 7, null);
        @NotNull
        private com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration timeoutConfiguration = new com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
        @NotNull
        private FileSyncConfiguration fileSyncConfiguration = new FileSyncConfiguration(null, null, 3, null);
        @NotNull
        private com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration threadingConfiguration = new com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration(0, 0, 0, 7, null);
        @NotNull
        private com.malinskiy.marathon.config.vendor.android.TestParserConfiguration testParserConfiguration = TestParserConfiguration.LocalTestParserConfiguration.INSTANCE;
        @NotNull
        private TestAccessConfiguration testAccessConfiguration = new TestAccessConfiguration(false, false, false, null, 15, null);
        @NotNull
        private List<AdbEndpoint> adbServers = CollectionsKt.listOf((Object)new AdbEndpoint(null, 0, 3, null));
        private boolean disableWindowAnimation = true;

        @Nullable
        public final File getAndroidSdk() {
            return this.androidSdk;
        }

        public final void setAndroidSdk(@Nullable File file) {
            this.androidSdk = file;
        }

        @Nullable
        public final File getApplicationOutput() {
            return this.applicationOutput;
        }

        public final void setApplicationOutput(@Nullable File file) {
            this.applicationOutput = file;
        }

        @Nullable
        public final File getTestApplicationOutput() {
            return this.testApplicationOutput;
        }

        public final void setTestApplicationOutput(@Nullable File file) {
            this.testApplicationOutput = file;
        }

        @Nullable
        public final List<File> getExtraApplicationsOutput() {
            return this.extraApplicationsOutput;
        }

        public final void setExtraApplicationsOutput(@Nullable List<? extends File> list) {
            this.extraApplicationsOutput = list;
        }

        @Nullable
        public final List<File> getSplitApks() {
            return this.splitApks;
        }

        public final void setSplitApks(@Nullable List<? extends File> list) {
            this.splitApks = list;
        }

        @Nullable
        public final List<AndroidTestBundleConfiguration> getOutputs() {
            return this.outputs;
        }

        public final void setOutputs(@Nullable List<AndroidTestBundleConfiguration> list) {
            this.outputs = list;
        }

        public final boolean getAutoGrantPermission() {
            return this.autoGrantPermission;
        }

        public final void setAutoGrantPermission(boolean bl) {
            this.autoGrantPermission = bl;
        }

        @NotNull
        public final Map<String, String> getInstrumentationArgs() {
            return this.instrumentationArgs;
        }

        public final void setInstrumentationArgs(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.instrumentationArgs = map;
        }

        public final boolean getApplicationPmClear() {
            return this.applicationPmClear;
        }

        public final void setApplicationPmClear(boolean bl) {
            this.applicationPmClear = bl;
        }

        public final boolean getTestApplicationPmClear() {
            return this.testApplicationPmClear;
        }

        public final void setTestApplicationPmClear(boolean bl) {
            this.testApplicationPmClear = bl;
        }

        public final int getAdbInitTimeoutMillis() {
            return this.adbInitTimeoutMillis;
        }

        public final void setAdbInitTimeoutMillis(int n) {
            this.adbInitTimeoutMillis = n;
        }

        @NotNull
        public final String getInstallOptions() {
            return this.installOptions;
        }

        public final void setInstallOptions(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.installOptions = string;
        }

        @NotNull
        public final SerialStrategy getSerialStrategy() {
            return this.serialStrategy;
        }

        public final void setSerialStrategy(@NotNull SerialStrategy serialStrategy) {
            Intrinsics.checkNotNullParameter((Object)((Object)serialStrategy), (String)"<set-?>");
            this.serialStrategy = serialStrategy;
        }

        @NotNull
        public final ScreenRecordConfiguration getScreenRecordConfiguration() {
            return this.screenRecordConfiguration;
        }

        public final void setScreenRecordConfiguration(@NotNull ScreenRecordConfiguration screenRecordConfiguration) {
            Intrinsics.checkNotNullParameter((Object)screenRecordConfiguration, (String)"<set-?>");
            this.screenRecordConfiguration = screenRecordConfiguration;
        }

        public final long getWaitForDevicesTimeoutMillis() {
            return this.waitForDevicesTimeoutMillis;
        }

        public final void setWaitForDevicesTimeoutMillis(long l) {
            this.waitForDevicesTimeoutMillis = l;
        }

        @NotNull
        public final AllureConfiguration getAllureConfiguration() {
            return this.allureConfiguration;
        }

        public final void setAllureConfiguration(@NotNull AllureConfiguration allureConfiguration) {
            Intrinsics.checkNotNullParameter((Object)allureConfiguration, (String)"<set-?>");
            this.allureConfiguration = allureConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration getTimeoutConfiguration() {
            return this.timeoutConfiguration;
        }

        public final void setTimeoutConfiguration(@NotNull com.malinskiy.marathon.config.vendor.android.TimeoutConfiguration timeoutConfiguration) {
            Intrinsics.checkNotNullParameter((Object)timeoutConfiguration, (String)"<set-?>");
            this.timeoutConfiguration = timeoutConfiguration;
        }

        @NotNull
        public final FileSyncConfiguration getFileSyncConfiguration() {
            return this.fileSyncConfiguration;
        }

        public final void setFileSyncConfiguration(@NotNull FileSyncConfiguration fileSyncConfiguration) {
            Intrinsics.checkNotNullParameter((Object)fileSyncConfiguration, (String)"<set-?>");
            this.fileSyncConfiguration = fileSyncConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration getThreadingConfiguration() {
            return this.threadingConfiguration;
        }

        public final void setThreadingConfiguration(@NotNull com.malinskiy.marathon.config.vendor.android.ThreadingConfiguration threadingConfiguration) {
            Intrinsics.checkNotNullParameter((Object)threadingConfiguration, (String)"<set-?>");
            this.threadingConfiguration = threadingConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.android.TestParserConfiguration getTestParserConfiguration() {
            return this.testParserConfiguration;
        }

        public final void setTestParserConfiguration(@NotNull com.malinskiy.marathon.config.vendor.android.TestParserConfiguration testParserConfiguration) {
            Intrinsics.checkNotNullParameter((Object)testParserConfiguration, (String)"<set-?>");
            this.testParserConfiguration = testParserConfiguration;
        }

        @NotNull
        public final TestAccessConfiguration getTestAccessConfiguration() {
            return this.testAccessConfiguration;
        }

        public final void setTestAccessConfiguration(@NotNull TestAccessConfiguration testAccessConfiguration) {
            Intrinsics.checkNotNullParameter((Object)testAccessConfiguration, (String)"<set-?>");
            this.testAccessConfiguration = testAccessConfiguration;
        }

        @NotNull
        public final List<AdbEndpoint> getAdbServers() {
            return this.adbServers;
        }

        public final void setAdbServers(@NotNull List<AdbEndpoint> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.adbServers = list;
        }

        public final boolean getDisableWindowAnimation() {
            return this.disableWindowAnimation;
        }

        public final void setDisableWindowAnimation(boolean bl) {
            this.disableWindowAnimation = bl;
        }

        @NotNull
        public final AndroidConfiguration build() {
            return new AndroidConfiguration(this.androidSdk, this.applicationOutput, this.testApplicationOutput, this.splitApks, this.extraApplicationsOutput, this.outputs, this.autoGrantPermission, this.instrumentationArgs, this.applicationPmClear, this.testApplicationPmClear, this.adbInitTimeoutMillis, this.installOptions, this.serialStrategy, this.screenRecordConfiguration, this.waitForDevicesTimeoutMillis, this.allureConfiguration, this.timeoutConfiguration, this.fileSyncConfiguration, this.threadingConfiguration, this.testParserConfiguration, this.testAccessConfiguration, this.adbServers, this.disableWindowAnimation);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$EmptyVendorConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration;", "()V", "configuration"})
    public static final class EmptyVendorConfiguration
    extends VendorConfiguration {
        public EmptyVendorConfiguration() {
            super(null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b:\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u00db\u0001\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\t\u0012\b\b\u0003\u0010\n\u001a\u00020\u000b\u0012\b\b\u0003\u0010\f\u001a\u00020\r\u0012\b\b\u0003\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0003\u0010\u0010\u001a\u00020\u0011\u0012\u0010\b\u0003\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0013\u0012\b\b\u0003\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0003\u0010\u0016\u001a\u00020\u0017\u0012\b\b\u0003\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0003\u0010\u001a\u001a\u00020\u0019\u0012\b\b\u0003\u0010\u001b\u001a\u00020\u001c\u0012\u0014\b\u0003\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\b\b\u0003\u0010 \u001a\u00020\u0019\u0012\b\b\u0003\u0010!\u001a\u00020\"\u0012\b\b\u0003\u0010#\u001a\u00020\u0019\u0012\b\b\u0003\u0010$\u001a\u00020%\u00a2\u0006\u0002\u0010&J\u000b\u0010J\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010K\u001a\u00020\u0015H\u00c6\u0003J\t\u0010L\u001a\u00020\u0017H\u00c6\u0003J\t\u0010M\u001a\u00020\u0019H\u00c6\u0003J\t\u0010N\u001a\u00020\u0019H\u00c6\u0003J\t\u0010O\u001a\u00020\u001cH\u00c6\u0003J\u0015\u0010P\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001eH\u00c6\u0003J\t\u0010Q\u001a\u00020\u0019H\u00c6\u0003J\t\u0010R\u001a\u00020\"H\u00c6\u0003J\t\u0010S\u001a\u00020\u0019H\u00c6\u0003J\t\u0010T\u001a\u00020%H\u00c6\u0003J\u000b\u0010U\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010V\u001a\u00020\u0007H\u00c6\u0003J\t\u0010W\u001a\u00020\tH\u00c6\u0003J\t\u0010X\u001a\u00020\u000bH\u00c6\u0003J\t\u0010Y\u001a\u00020\rH\u00c6\u0003J\t\u0010Z\u001a\u00020\u000fH\u00c6\u0003J\t\u0010[\u001a\u00020\u0011H\u00c6\u0003J\u0011\u0010\\\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0013H\u00c6\u0003J\u00df\u0001\u0010]\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u00072\b\b\u0003\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\u000b2\b\b\u0003\u0010\f\u001a\u00020\r2\b\b\u0003\u0010\u000e\u001a\u00020\u000f2\b\b\u0003\u0010\u0010\u001a\u00020\u00112\u0010\b\u0003\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00132\b\b\u0003\u0010\u0014\u001a\u00020\u00152\b\b\u0003\u0010\u0016\u001a\u00020\u00172\b\b\u0003\u0010\u0018\u001a\u00020\u00192\b\b\u0003\u0010\u001a\u001a\u00020\u00192\b\b\u0003\u0010\u001b\u001a\u00020\u001c2\u0014\b\u0003\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0003\u0010 \u001a\u00020\u00192\b\b\u0003\u0010!\u001a\u00020\"2\b\b\u0003\u0010#\u001a\u00020\u00192\b\b\u0003\u0010$\u001a\u00020%H\u00c6\u0001J\u0013\u0010^\u001a\u00020\u00192\b\u0010_\u001a\u0004\u0018\u00010`H\u00d6\u0003J\t\u0010a\u001a\u00020bH\u00d6\u0001J\t\u0010c\u001a\u00020\u001fH\u00d6\u0001J\u0006\u0010d\u001a\u00020eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010 \u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010*R\u0011\u0010#\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010*R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u001d\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010I\u00a8\u0006f"}, d2={"Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$IOSConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration;", "bundle", "Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration;", "devicesFile", "Ljava/io/File;", "ssh", "Lcom/malinskiy/marathon/config/vendor/apple/SshConfiguration;", "xcresult", "Lcom/malinskiy/marathon/config/vendor/apple/ios/XcresultConfiguration;", "screenRecordConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/ios/ScreenRecordConfiguration;", "xctestrunEnv", "Lcom/malinskiy/marathon/config/vendor/apple/ios/XctestrunEnvConfiguration;", "lifecycleConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/ios/LifecycleConfiguration;", "permissions", "Lcom/malinskiy/marathon/config/vendor/apple/ios/PermissionsConfiguration;", "mediaFiles", "", "timeoutConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/TimeoutConfiguration;", "threadingConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/ThreadingConfiguration;", "hideRunnerOutput", "", "compactOutput", "rsync", "Lcom/malinskiy/marathon/config/vendor/apple/RsyncConfiguration;", "xcodebuildTestArgs", "", "", "dataContainerClear", "testParserConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/TestParserConfiguration;", "deviceLog", "signing", "Lcom/malinskiy/marathon/config/vendor/apple/ios/SigningConfiguration;", "(Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration;Ljava/io/File;Lcom/malinskiy/marathon/config/vendor/apple/SshConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ios/XcresultConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ios/ScreenRecordConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ios/XctestrunEnvConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ios/LifecycleConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ios/PermissionsConfiguration;Ljava/util/List;Lcom/malinskiy/marathon/config/vendor/apple/TimeoutConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ThreadingConfiguration;ZZLcom/malinskiy/marathon/config/vendor/apple/RsyncConfiguration;Ljava/util/Map;ZLcom/malinskiy/marathon/config/vendor/apple/TestParserConfiguration;ZLcom/malinskiy/marathon/config/vendor/apple/ios/SigningConfiguration;)V", "getBundle", "()Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration;", "getCompactOutput", "()Z", "getDataContainerClear", "getDeviceLog", "getDevicesFile", "()Ljava/io/File;", "getHideRunnerOutput", "getLifecycleConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/LifecycleConfiguration;", "getMediaFiles", "()Ljava/util/List;", "getPermissions", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/PermissionsConfiguration;", "getRsync", "()Lcom/malinskiy/marathon/config/vendor/apple/RsyncConfiguration;", "getScreenRecordConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/ScreenRecordConfiguration;", "getSigning", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/SigningConfiguration;", "getSsh", "()Lcom/malinskiy/marathon/config/vendor/apple/SshConfiguration;", "getTestParserConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/TestParserConfiguration;", "getThreadingConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/ThreadingConfiguration;", "getTimeoutConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/TimeoutConfiguration;", "getXcodebuildTestArgs", "()Ljava/util/Map;", "getXcresult", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/XcresultConfiguration;", "getXctestrunEnv", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/XctestrunEnvConfiguration;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class IOSConfiguration
    extends VendorConfiguration {
        @Nullable
        private final AppleTestBundleConfiguration bundle;
        @Nullable
        private final File devicesFile;
        @NotNull
        private final SshConfiguration ssh;
        @NotNull
        private final XcresultConfiguration xcresult;
        @NotNull
        private final com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration screenRecordConfiguration;
        @NotNull
        private final XctestrunEnvConfiguration xctestrunEnv;
        @NotNull
        private final LifecycleConfiguration lifecycleConfiguration;
        @NotNull
        private final PermissionsConfiguration permissions;
        @Nullable
        private final List<File> mediaFiles;
        @NotNull
        private final TimeoutConfiguration timeoutConfiguration;
        @NotNull
        private final ThreadingConfiguration threadingConfiguration;
        private final boolean hideRunnerOutput;
        private final boolean compactOutput;
        @NotNull
        private final RsyncConfiguration rsync;
        @NotNull
        private final Map<String, String> xcodebuildTestArgs;
        private final boolean dataContainerClear;
        @NotNull
        private final TestParserConfiguration testParserConfiguration;
        private final boolean deviceLog;
        @NotNull
        private final SigningConfiguration signing;

        public IOSConfiguration(@JsonProperty(value="bundle") @Nullable AppleTestBundleConfiguration bundle, @JsonProperty(value="devices") @Nullable File devicesFile, @JsonProperty(value="ssh") @NotNull SshConfiguration ssh, @JsonProperty(value="xcresult") @NotNull XcresultConfiguration xcresult, @JsonProperty(value="screenRecordConfiguration") @NotNull com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration screenRecordConfiguration, @JsonProperty(value="xctestrunEnv") @NotNull XctestrunEnvConfiguration xctestrunEnv, @JsonProperty(value="lifecycle") @NotNull LifecycleConfiguration lifecycleConfiguration, @JsonProperty(value="permissions") @NotNull PermissionsConfiguration permissions, @JsonProperty(value="importMedia") @Nullable List<? extends File> mediaFiles, @JsonProperty(value="timeoutConfiguration") @NotNull TimeoutConfiguration timeoutConfiguration, @JsonProperty(value="threadingConfiguration") @NotNull ThreadingConfiguration threadingConfiguration, @JsonProperty(value="hideRunnerOutput") boolean hideRunnerOutput, @JsonProperty(value="compactOutput") boolean compactOutput, @JsonProperty(value="rsync") @NotNull RsyncConfiguration rsync, @JsonProperty(value="xcodebuildTestArgs") @NotNull Map<String, String> xcodebuildTestArgs, @JsonProperty(value="dataContainerClear") boolean dataContainerClear, @JsonProperty(value="testParserConfiguration") @NotNull TestParserConfiguration testParserConfiguration, @JsonProperty(value="deviceLog") boolean deviceLog, @JsonProperty(value="signing") @NotNull SigningConfiguration signing) {
            Intrinsics.checkNotNullParameter((Object)ssh, (String)"ssh");
            Intrinsics.checkNotNullParameter((Object)xcresult, (String)"xcresult");
            Intrinsics.checkNotNullParameter((Object)screenRecordConfiguration, (String)"screenRecordConfiguration");
            Intrinsics.checkNotNullParameter((Object)xctestrunEnv, (String)"xctestrunEnv");
            Intrinsics.checkNotNullParameter((Object)lifecycleConfiguration, (String)"lifecycleConfiguration");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            Intrinsics.checkNotNullParameter((Object)timeoutConfiguration, (String)"timeoutConfiguration");
            Intrinsics.checkNotNullParameter((Object)threadingConfiguration, (String)"threadingConfiguration");
            Intrinsics.checkNotNullParameter((Object)rsync, (String)"rsync");
            Intrinsics.checkNotNullParameter(xcodebuildTestArgs, (String)"xcodebuildTestArgs");
            Intrinsics.checkNotNullParameter((Object)testParserConfiguration, (String)"testParserConfiguration");
            Intrinsics.checkNotNullParameter((Object)signing, (String)"signing");
            super(null);
            this.bundle = bundle;
            this.devicesFile = devicesFile;
            this.ssh = ssh;
            this.xcresult = xcresult;
            this.screenRecordConfiguration = screenRecordConfiguration;
            this.xctestrunEnv = xctestrunEnv;
            this.lifecycleConfiguration = lifecycleConfiguration;
            this.permissions = permissions;
            this.mediaFiles = mediaFiles;
            this.timeoutConfiguration = timeoutConfiguration;
            this.threadingConfiguration = threadingConfiguration;
            this.hideRunnerOutput = hideRunnerOutput;
            this.compactOutput = compactOutput;
            this.rsync = rsync;
            this.xcodebuildTestArgs = xcodebuildTestArgs;
            this.dataContainerClear = dataContainerClear;
            this.testParserConfiguration = testParserConfiguration;
            this.deviceLog = deviceLog;
            this.signing = signing;
        }

        public /* synthetic */ IOSConfiguration(AppleTestBundleConfiguration appleTestBundleConfiguration, File file, SshConfiguration sshConfiguration, XcresultConfiguration xcresultConfiguration, com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration screenRecordConfiguration, XctestrunEnvConfiguration xctestrunEnvConfiguration, LifecycleConfiguration lifecycleConfiguration, PermissionsConfiguration permissionsConfiguration, List list, TimeoutConfiguration timeoutConfiguration, ThreadingConfiguration threadingConfiguration, boolean bl, boolean bl2, RsyncConfiguration rsyncConfiguration, Map map, boolean bl3, TestParserConfiguration testParserConfiguration, boolean bl4, SigningConfiguration signingConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                appleTestBundleConfiguration = null;
            }
            if ((n & 2) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                sshConfiguration = new SshConfiguration(null, null, null, false, false, 31, null);
            }
            if ((n & 8) != 0) {
                xcresultConfiguration = new XcresultConfiguration(null, null, false, null, null, 31, null);
            }
            if ((n & 0x10) != 0) {
                screenRecordConfiguration = new com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration(null, null, null, 7, null);
            }
            if ((n & 0x20) != 0) {
                xctestrunEnvConfiguration = new XctestrunEnvConfiguration(null, null, 3, null);
            }
            if ((n & 0x40) != 0) {
                lifecycleConfiguration = new LifecycleConfiguration(false, null, null, 7, null);
            }
            if ((n & 0x80) != 0) {
                permissionsConfiguration = new PermissionsConfiguration(null, null, 3, null);
            }
            if ((n & 0x100) != 0) {
                list = null;
            }
            if ((n & 0x200) != 0) {
                timeoutConfiguration = new TimeoutConfiguration(null, null, null, null, null, null, null, null, null, null, null, null, null, null, 16383, null);
            }
            if ((n & 0x400) != 0) {
                threadingConfiguration = new ThreadingConfiguration(0, 0, 3, null);
            }
            if ((n & 0x800) != 0) {
                bl = false;
            }
            if ((n & 0x1000) != 0) {
                bl2 = false;
            }
            if ((n & 0x2000) != 0) {
                rsyncConfiguration = new RsyncConfiguration(null, 1, null);
            }
            if ((n & 0x4000) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x8000) != 0) {
                bl3 = false;
            }
            if ((n & 0x10000) != 0) {
                testParserConfiguration = new TestParserConfiguration.NmTestParserConfiguration(null, 1, null);
            }
            if ((n & 0x20000) != 0) {
                bl4 = false;
            }
            if ((n & 0x40000) != 0) {
                signingConfiguration = new SigningConfiguration(null, 1, null);
            }
            this(appleTestBundleConfiguration, file, sshConfiguration, xcresultConfiguration, screenRecordConfiguration, xctestrunEnvConfiguration, lifecycleConfiguration, permissionsConfiguration, list, timeoutConfiguration, threadingConfiguration, bl, bl2, rsyncConfiguration, map, bl3, testParserConfiguration, bl4, signingConfiguration);
        }

        @Nullable
        public final AppleTestBundleConfiguration getBundle() {
            return this.bundle;
        }

        @Nullable
        public final File getDevicesFile() {
            return this.devicesFile;
        }

        @NotNull
        public final SshConfiguration getSsh() {
            return this.ssh;
        }

        @NotNull
        public final XcresultConfiguration getXcresult() {
            return this.xcresult;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration getScreenRecordConfiguration() {
            return this.screenRecordConfiguration;
        }

        @NotNull
        public final XctestrunEnvConfiguration getXctestrunEnv() {
            return this.xctestrunEnv;
        }

        @NotNull
        public final LifecycleConfiguration getLifecycleConfiguration() {
            return this.lifecycleConfiguration;
        }

        @NotNull
        public final PermissionsConfiguration getPermissions() {
            return this.permissions;
        }

        @Nullable
        public final List<File> getMediaFiles() {
            return this.mediaFiles;
        }

        @NotNull
        public final TimeoutConfiguration getTimeoutConfiguration() {
            return this.timeoutConfiguration;
        }

        @NotNull
        public final ThreadingConfiguration getThreadingConfiguration() {
            return this.threadingConfiguration;
        }

        public final boolean getHideRunnerOutput() {
            return this.hideRunnerOutput;
        }

        public final boolean getCompactOutput() {
            return this.compactOutput;
        }

        @NotNull
        public final RsyncConfiguration getRsync() {
            return this.rsync;
        }

        @NotNull
        public final Map<String, String> getXcodebuildTestArgs() {
            return this.xcodebuildTestArgs;
        }

        public final boolean getDataContainerClear() {
            return this.dataContainerClear;
        }

        @NotNull
        public final TestParserConfiguration getTestParserConfiguration() {
            return this.testParserConfiguration;
        }

        public final boolean getDeviceLog() {
            return this.deviceLog;
        }

        @NotNull
        public final SigningConfiguration getSigning() {
            return this.signing;
        }

        public final void validate() {
            this.ssh.validate();
            AppleTestBundleConfiguration appleTestBundleConfiguration = this.bundle;
            if (appleTestBundleConfiguration == null) {
                throw new ConfigurationException("bundles must contain at least one valid entry");
            }
            AppleTestBundleConfiguration testBundleConfiguration = appleTestBundleConfiguration;
            testBundleConfiguration.validate();
        }

        @Nullable
        public final AppleTestBundleConfiguration component1() {
            return this.bundle;
        }

        @Nullable
        public final File component2() {
            return this.devicesFile;
        }

        @NotNull
        public final SshConfiguration component3() {
            return this.ssh;
        }

        @NotNull
        public final XcresultConfiguration component4() {
            return this.xcresult;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration component5() {
            return this.screenRecordConfiguration;
        }

        @NotNull
        public final XctestrunEnvConfiguration component6() {
            return this.xctestrunEnv;
        }

        @NotNull
        public final LifecycleConfiguration component7() {
            return this.lifecycleConfiguration;
        }

        @NotNull
        public final PermissionsConfiguration component8() {
            return this.permissions;
        }

        @Nullable
        public final List<File> component9() {
            return this.mediaFiles;
        }

        @NotNull
        public final TimeoutConfiguration component10() {
            return this.timeoutConfiguration;
        }

        @NotNull
        public final ThreadingConfiguration component11() {
            return this.threadingConfiguration;
        }

        public final boolean component12() {
            return this.hideRunnerOutput;
        }

        public final boolean component13() {
            return this.compactOutput;
        }

        @NotNull
        public final RsyncConfiguration component14() {
            return this.rsync;
        }

        @NotNull
        public final Map<String, String> component15() {
            return this.xcodebuildTestArgs;
        }

        public final boolean component16() {
            return this.dataContainerClear;
        }

        @NotNull
        public final TestParserConfiguration component17() {
            return this.testParserConfiguration;
        }

        public final boolean component18() {
            return this.deviceLog;
        }

        @NotNull
        public final SigningConfiguration component19() {
            return this.signing;
        }

        @NotNull
        public final IOSConfiguration copy(@JsonProperty(value="bundle") @Nullable AppleTestBundleConfiguration bundle, @JsonProperty(value="devices") @Nullable File devicesFile, @JsonProperty(value="ssh") @NotNull SshConfiguration ssh, @JsonProperty(value="xcresult") @NotNull XcresultConfiguration xcresult, @JsonProperty(value="screenRecordConfiguration") @NotNull com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration screenRecordConfiguration, @JsonProperty(value="xctestrunEnv") @NotNull XctestrunEnvConfiguration xctestrunEnv, @JsonProperty(value="lifecycle") @NotNull LifecycleConfiguration lifecycleConfiguration, @JsonProperty(value="permissions") @NotNull PermissionsConfiguration permissions, @JsonProperty(value="importMedia") @Nullable List<? extends File> mediaFiles, @JsonProperty(value="timeoutConfiguration") @NotNull TimeoutConfiguration timeoutConfiguration, @JsonProperty(value="threadingConfiguration") @NotNull ThreadingConfiguration threadingConfiguration, @JsonProperty(value="hideRunnerOutput") boolean hideRunnerOutput, @JsonProperty(value="compactOutput") boolean compactOutput, @JsonProperty(value="rsync") @NotNull RsyncConfiguration rsync, @JsonProperty(value="xcodebuildTestArgs") @NotNull Map<String, String> xcodebuildTestArgs, @JsonProperty(value="dataContainerClear") boolean dataContainerClear, @JsonProperty(value="testParserConfiguration") @NotNull TestParserConfiguration testParserConfiguration, @JsonProperty(value="deviceLog") boolean deviceLog, @JsonProperty(value="signing") @NotNull SigningConfiguration signing) {
            Intrinsics.checkNotNullParameter((Object)ssh, (String)"ssh");
            Intrinsics.checkNotNullParameter((Object)xcresult, (String)"xcresult");
            Intrinsics.checkNotNullParameter((Object)screenRecordConfiguration, (String)"screenRecordConfiguration");
            Intrinsics.checkNotNullParameter((Object)xctestrunEnv, (String)"xctestrunEnv");
            Intrinsics.checkNotNullParameter((Object)lifecycleConfiguration, (String)"lifecycleConfiguration");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            Intrinsics.checkNotNullParameter((Object)timeoutConfiguration, (String)"timeoutConfiguration");
            Intrinsics.checkNotNullParameter((Object)threadingConfiguration, (String)"threadingConfiguration");
            Intrinsics.checkNotNullParameter((Object)rsync, (String)"rsync");
            Intrinsics.checkNotNullParameter(xcodebuildTestArgs, (String)"xcodebuildTestArgs");
            Intrinsics.checkNotNullParameter((Object)testParserConfiguration, (String)"testParserConfiguration");
            Intrinsics.checkNotNullParameter((Object)signing, (String)"signing");
            return new IOSConfiguration(bundle, devicesFile, ssh, xcresult, screenRecordConfiguration, xctestrunEnv, lifecycleConfiguration, permissions, mediaFiles, timeoutConfiguration, threadingConfiguration, hideRunnerOutput, compactOutput, rsync, xcodebuildTestArgs, dataContainerClear, testParserConfiguration, deviceLog, signing);
        }

        public static /* synthetic */ IOSConfiguration copy$default(IOSConfiguration iOSConfiguration, AppleTestBundleConfiguration appleTestBundleConfiguration, File file, SshConfiguration sshConfiguration, XcresultConfiguration xcresultConfiguration, com.malinskiy.marathon.config.vendor.apple.ios.ScreenRecordConfiguration screenRecordConfiguration, XctestrunEnvConfiguration xctestrunEnvConfiguration, LifecycleConfiguration lifecycleConfiguration, PermissionsConfiguration permissionsConfiguration, List list, TimeoutConfiguration timeoutConfiguration, ThreadingConfiguration threadingConfiguration, boolean bl, boolean bl2, RsyncConfiguration rsyncConfiguration, Map map, boolean bl3, TestParserConfiguration testParserConfiguration, boolean bl4, SigningConfiguration signingConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                appleTestBundleConfiguration = iOSConfiguration.bundle;
            }
            if ((n & 2) != 0) {
                file = iOSConfiguration.devicesFile;
            }
            if ((n & 4) != 0) {
                sshConfiguration = iOSConfiguration.ssh;
            }
            if ((n & 8) != 0) {
                xcresultConfiguration = iOSConfiguration.xcresult;
            }
            if ((n & 0x10) != 0) {
                screenRecordConfiguration = iOSConfiguration.screenRecordConfiguration;
            }
            if ((n & 0x20) != 0) {
                xctestrunEnvConfiguration = iOSConfiguration.xctestrunEnv;
            }
            if ((n & 0x40) != 0) {
                lifecycleConfiguration = iOSConfiguration.lifecycleConfiguration;
            }
            if ((n & 0x80) != 0) {
                permissionsConfiguration = iOSConfiguration.permissions;
            }
            if ((n & 0x100) != 0) {
                list = iOSConfiguration.mediaFiles;
            }
            if ((n & 0x200) != 0) {
                timeoutConfiguration = iOSConfiguration.timeoutConfiguration;
            }
            if ((n & 0x400) != 0) {
                threadingConfiguration = iOSConfiguration.threadingConfiguration;
            }
            if ((n & 0x800) != 0) {
                bl = iOSConfiguration.hideRunnerOutput;
            }
            if ((n & 0x1000) != 0) {
                bl2 = iOSConfiguration.compactOutput;
            }
            if ((n & 0x2000) != 0) {
                rsyncConfiguration = iOSConfiguration.rsync;
            }
            if ((n & 0x4000) != 0) {
                map = iOSConfiguration.xcodebuildTestArgs;
            }
            if ((n & 0x8000) != 0) {
                bl3 = iOSConfiguration.dataContainerClear;
            }
            if ((n & 0x10000) != 0) {
                testParserConfiguration = iOSConfiguration.testParserConfiguration;
            }
            if ((n & 0x20000) != 0) {
                bl4 = iOSConfiguration.deviceLog;
            }
            if ((n & 0x40000) != 0) {
                signingConfiguration = iOSConfiguration.signing;
            }
            return iOSConfiguration.copy(appleTestBundleConfiguration, file, sshConfiguration, xcresultConfiguration, screenRecordConfiguration, xctestrunEnvConfiguration, lifecycleConfiguration, permissionsConfiguration, list, timeoutConfiguration, threadingConfiguration, bl, bl2, rsyncConfiguration, map, bl3, testParserConfiguration, bl4, signingConfiguration);
        }

        @NotNull
        public String toString() {
            return "IOSConfiguration(bundle=" + this.bundle + ", devicesFile=" + this.devicesFile + ", ssh=" + this.ssh + ", xcresult=" + this.xcresult + ", screenRecordConfiguration=" + this.screenRecordConfiguration + ", xctestrunEnv=" + this.xctestrunEnv + ", lifecycleConfiguration=" + this.lifecycleConfiguration + ", permissions=" + this.permissions + ", mediaFiles=" + this.mediaFiles + ", timeoutConfiguration=" + this.timeoutConfiguration + ", threadingConfiguration=" + this.threadingConfiguration + ", hideRunnerOutput=" + this.hideRunnerOutput + ", compactOutput=" + this.compactOutput + ", rsync=" + this.rsync + ", xcodebuildTestArgs=" + this.xcodebuildTestArgs + ", dataContainerClear=" + this.dataContainerClear + ", testParserConfiguration=" + this.testParserConfiguration + ", deviceLog=" + this.deviceLog + ", signing=" + this.signing + ")";
        }

        public int hashCode() {
            int result = this.bundle == null ? 0 : this.bundle.hashCode();
            result = result * 31 + (this.devicesFile == null ? 0 : this.devicesFile.hashCode());
            result = result * 31 + this.ssh.hashCode();
            result = result * 31 + this.xcresult.hashCode();
            result = result * 31 + this.screenRecordConfiguration.hashCode();
            result = result * 31 + this.xctestrunEnv.hashCode();
            result = result * 31 + this.lifecycleConfiguration.hashCode();
            result = result * 31 + this.permissions.hashCode();
            result = result * 31 + (this.mediaFiles == null ? 0 : ((Object)this.mediaFiles).hashCode());
            result = result * 31 + this.timeoutConfiguration.hashCode();
            result = result * 31 + this.threadingConfiguration.hashCode();
            int n = this.hideRunnerOutput ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.compactOutput ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.rsync.hashCode();
            result = result * 31 + ((Object)this.xcodebuildTestArgs).hashCode();
            int n3 = this.dataContainerClear ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            result = result * 31 + this.testParserConfiguration.hashCode();
            int n4 = this.deviceLog ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            result = result * 31 + this.signing.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IOSConfiguration)) {
                return false;
            }
            IOSConfiguration iOSConfiguration = (IOSConfiguration)other;
            if (!Intrinsics.areEqual((Object)this.bundle, (Object)iOSConfiguration.bundle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.devicesFile, (Object)iOSConfiguration.devicesFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ssh, (Object)iOSConfiguration.ssh)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.xcresult, (Object)iOSConfiguration.xcresult)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.screenRecordConfiguration, (Object)iOSConfiguration.screenRecordConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.xctestrunEnv, (Object)iOSConfiguration.xctestrunEnv)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.lifecycleConfiguration, (Object)iOSConfiguration.lifecycleConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.permissions, (Object)iOSConfiguration.permissions)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.mediaFiles, iOSConfiguration.mediaFiles)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timeoutConfiguration, (Object)iOSConfiguration.timeoutConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.threadingConfiguration, (Object)iOSConfiguration.threadingConfiguration)) {
                return false;
            }
            if (this.hideRunnerOutput != iOSConfiguration.hideRunnerOutput) {
                return false;
            }
            if (this.compactOutput != iOSConfiguration.compactOutput) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rsync, (Object)iOSConfiguration.rsync)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.xcodebuildTestArgs, iOSConfiguration.xcodebuildTestArgs)) {
                return false;
            }
            if (this.dataContainerClear != iOSConfiguration.dataContainerClear) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.testParserConfiguration, (Object)iOSConfiguration.testParserConfiguration)) {
                return false;
            }
            if (this.deviceLog != iOSConfiguration.deviceLog) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.signing, (Object)iOSConfiguration.signing);
        }

        public IOSConfiguration() {
            this(null, null, null, null, null, null, null, null, null, null, null, false, false, null, null, false, null, false, null, 524287, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b*\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0097\u0001\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\t\u0012\b\b\u0003\u0010\n\u001a\u00020\u000b\u0012\b\b\u0003\u0010\f\u001a\u00020\r\u0012\b\b\u0003\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0003\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0003\u0010\u0012\u001a\u00020\u0011\u0012\b\b\u0003\u0010\u0013\u001a\u00020\u0014\u0012\u0014\b\u0003\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u0012\b\b\u0003\u0010\u0018\u001a\u00020\u0019\u0012\b\b\u0003\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJ\u000b\u00106\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u00107\u001a\u00020\u0014H\u00c6\u0003J\u0015\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016H\u00c6\u0003J\t\u00109\u001a\u00020\u0019H\u00c6\u0003J\t\u0010:\u001a\u00020\u001bH\u00c6\u0003J\u000b\u0010;\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010<\u001a\u00020\u0007H\u00c6\u0003J\t\u0010=\u001a\u00020\tH\u00c6\u0003J\t\u0010>\u001a\u00020\u000bH\u00c6\u0003J\t\u0010?\u001a\u00020\rH\u00c6\u0003J\t\u0010@\u001a\u00020\u000fH\u00c6\u0003J\t\u0010A\u001a\u00020\u0011H\u00c6\u0003J\t\u0010B\u001a\u00020\u0011H\u00c6\u0003J\u009b\u0001\u0010C\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u00072\b\b\u0003\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\u000b2\b\b\u0003\u0010\f\u001a\u00020\r2\b\b\u0003\u0010\u000e\u001a\u00020\u000f2\b\b\u0003\u0010\u0010\u001a\u00020\u00112\b\b\u0003\u0010\u0012\u001a\u00020\u00112\b\b\u0003\u0010\u0013\u001a\u00020\u00142\u0014\b\u0003\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00162\b\b\u0003\u0010\u0018\u001a\u00020\u00192\b\b\u0003\u0010\u001a\u001a\u00020\u001bH\u00c6\u0001J\u0013\u0010D\u001a\u00020\u00112\b\u0010E\u001a\u0004\u0018\u00010FH\u00d6\u0003J\t\u0010G\u001a\u00020HH\u00d6\u0001J\t\u0010I\u001a\u00020\u0017H\u00d6\u0001J\u0006\u0010J\u001a\u00020KR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010 R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006L"}, d2={"Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$MacosConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration;", "bundle", "Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration;", "devicesFile", "Ljava/io/File;", "ssh", "Lcom/malinskiy/marathon/config/vendor/apple/SshConfiguration;", "xcresult", "Lcom/malinskiy/marathon/config/vendor/apple/ios/XcresultConfiguration;", "xctestrunEnv", "Lcom/malinskiy/marathon/config/vendor/apple/ios/XctestrunEnvConfiguration;", "timeoutConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/TimeoutConfiguration;", "threadingConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/ThreadingConfiguration;", "hideRunnerOutput", "", "compactOutput", "rsync", "Lcom/malinskiy/marathon/config/vendor/apple/RsyncConfiguration;", "xcodebuildTestArgs", "", "", "testParserConfiguration", "Lcom/malinskiy/marathon/config/vendor/apple/TestParserConfiguration;", "permissions", "Lcom/malinskiy/marathon/config/vendor/apple/macos/PermissionsConfiguration;", "(Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration;Ljava/io/File;Lcom/malinskiy/marathon/config/vendor/apple/SshConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ios/XcresultConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ios/XctestrunEnvConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/TimeoutConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/ThreadingConfiguration;ZZLcom/malinskiy/marathon/config/vendor/apple/RsyncConfiguration;Ljava/util/Map;Lcom/malinskiy/marathon/config/vendor/apple/TestParserConfiguration;Lcom/malinskiy/marathon/config/vendor/apple/macos/PermissionsConfiguration;)V", "getBundle", "()Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration;", "getCompactOutput", "()Z", "getDevicesFile", "()Ljava/io/File;", "getHideRunnerOutput", "getPermissions", "()Lcom/malinskiy/marathon/config/vendor/apple/macos/PermissionsConfiguration;", "getRsync", "()Lcom/malinskiy/marathon/config/vendor/apple/RsyncConfiguration;", "getSsh", "()Lcom/malinskiy/marathon/config/vendor/apple/SshConfiguration;", "getTestParserConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/TestParserConfiguration;", "getThreadingConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/ThreadingConfiguration;", "getTimeoutConfiguration", "()Lcom/malinskiy/marathon/config/vendor/apple/TimeoutConfiguration;", "getXcodebuildTestArgs", "()Ljava/util/Map;", "getXcresult", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/XcresultConfiguration;", "getXctestrunEnv", "()Lcom/malinskiy/marathon/config/vendor/apple/ios/XctestrunEnvConfiguration;", "component1", "component10", "component11", "component12", "component13", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "toString", "validate", "", "configuration"})
    public static final class MacosConfiguration
    extends VendorConfiguration {
        @Nullable
        private final AppleTestBundleConfiguration bundle;
        @Nullable
        private final File devicesFile;
        @NotNull
        private final SshConfiguration ssh;
        @NotNull
        private final XcresultConfiguration xcresult;
        @NotNull
        private final XctestrunEnvConfiguration xctestrunEnv;
        @NotNull
        private final TimeoutConfiguration timeoutConfiguration;
        @NotNull
        private final ThreadingConfiguration threadingConfiguration;
        private final boolean hideRunnerOutput;
        private final boolean compactOutput;
        @NotNull
        private final RsyncConfiguration rsync;
        @NotNull
        private final Map<String, String> xcodebuildTestArgs;
        @NotNull
        private final TestParserConfiguration testParserConfiguration;
        @NotNull
        private final com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration permissions;

        public MacosConfiguration(@JsonProperty(value="bundle") @Nullable AppleTestBundleConfiguration bundle, @JsonProperty(value="devices") @Nullable File devicesFile, @JsonProperty(value="ssh") @NotNull SshConfiguration ssh, @JsonProperty(value="xcresult") @NotNull XcresultConfiguration xcresult, @JsonProperty(value="xctestrunEnv") @NotNull XctestrunEnvConfiguration xctestrunEnv, @JsonProperty(value="timeoutConfiguration") @NotNull TimeoutConfiguration timeoutConfiguration, @JsonProperty(value="threadingConfiguration") @NotNull ThreadingConfiguration threadingConfiguration, @JsonProperty(value="hideRunnerOutput") boolean hideRunnerOutput, @JsonProperty(value="compactOutput") boolean compactOutput, @JsonProperty(value="rsync") @NotNull RsyncConfiguration rsync, @JsonProperty(value="xcodebuildTestArgs") @NotNull Map<String, String> xcodebuildTestArgs, @JsonProperty(value="testParserConfiguration") @NotNull TestParserConfiguration testParserConfiguration, @JsonProperty(value="permissions") @NotNull com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration permissions) {
            Intrinsics.checkNotNullParameter((Object)ssh, (String)"ssh");
            Intrinsics.checkNotNullParameter((Object)xcresult, (String)"xcresult");
            Intrinsics.checkNotNullParameter((Object)xctestrunEnv, (String)"xctestrunEnv");
            Intrinsics.checkNotNullParameter((Object)timeoutConfiguration, (String)"timeoutConfiguration");
            Intrinsics.checkNotNullParameter((Object)threadingConfiguration, (String)"threadingConfiguration");
            Intrinsics.checkNotNullParameter((Object)rsync, (String)"rsync");
            Intrinsics.checkNotNullParameter(xcodebuildTestArgs, (String)"xcodebuildTestArgs");
            Intrinsics.checkNotNullParameter((Object)testParserConfiguration, (String)"testParserConfiguration");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            super(null);
            this.bundle = bundle;
            this.devicesFile = devicesFile;
            this.ssh = ssh;
            this.xcresult = xcresult;
            this.xctestrunEnv = xctestrunEnv;
            this.timeoutConfiguration = timeoutConfiguration;
            this.threadingConfiguration = threadingConfiguration;
            this.hideRunnerOutput = hideRunnerOutput;
            this.compactOutput = compactOutput;
            this.rsync = rsync;
            this.xcodebuildTestArgs = xcodebuildTestArgs;
            this.testParserConfiguration = testParserConfiguration;
            this.permissions = permissions;
        }

        public /* synthetic */ MacosConfiguration(AppleTestBundleConfiguration appleTestBundleConfiguration, File file, SshConfiguration sshConfiguration, XcresultConfiguration xcresultConfiguration, XctestrunEnvConfiguration xctestrunEnvConfiguration, TimeoutConfiguration timeoutConfiguration, ThreadingConfiguration threadingConfiguration, boolean bl, boolean bl2, RsyncConfiguration rsyncConfiguration, Map map, TestParserConfiguration testParserConfiguration, com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration permissionsConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                appleTestBundleConfiguration = null;
            }
            if ((n & 2) != 0) {
                file = null;
            }
            if ((n & 4) != 0) {
                sshConfiguration = new SshConfiguration(null, null, null, false, false, 31, null);
            }
            if ((n & 8) != 0) {
                xcresultConfiguration = new XcresultConfiguration(null, null, false, null, null, 31, null);
            }
            if ((n & 0x10) != 0) {
                xctestrunEnvConfiguration = new XctestrunEnvConfiguration(null, null, 3, null);
            }
            if ((n & 0x20) != 0) {
                timeoutConfiguration = new TimeoutConfiguration(null, null, null, null, null, null, null, null, null, null, null, null, null, null, 16383, null);
            }
            if ((n & 0x40) != 0) {
                threadingConfiguration = new ThreadingConfiguration(0, 0, 3, null);
            }
            if ((n & 0x80) != 0) {
                bl = false;
            }
            if ((n & 0x100) != 0) {
                bl2 = false;
            }
            if ((n & 0x200) != 0) {
                rsyncConfiguration = new RsyncConfiguration(null, 1, null);
            }
            if ((n & 0x400) != 0) {
                map = MapsKt.emptyMap();
            }
            if ((n & 0x800) != 0) {
                testParserConfiguration = new TestParserConfiguration.NmTestParserConfiguration(null, 1, null);
            }
            if ((n & 0x1000) != 0) {
                permissionsConfiguration = new com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration(null, 1, null);
            }
            this(appleTestBundleConfiguration, file, sshConfiguration, xcresultConfiguration, xctestrunEnvConfiguration, timeoutConfiguration, threadingConfiguration, bl, bl2, rsyncConfiguration, map, testParserConfiguration, permissionsConfiguration);
        }

        @Nullable
        public final AppleTestBundleConfiguration getBundle() {
            return this.bundle;
        }

        @Nullable
        public final File getDevicesFile() {
            return this.devicesFile;
        }

        @NotNull
        public final SshConfiguration getSsh() {
            return this.ssh;
        }

        @NotNull
        public final XcresultConfiguration getXcresult() {
            return this.xcresult;
        }

        @NotNull
        public final XctestrunEnvConfiguration getXctestrunEnv() {
            return this.xctestrunEnv;
        }

        @NotNull
        public final TimeoutConfiguration getTimeoutConfiguration() {
            return this.timeoutConfiguration;
        }

        @NotNull
        public final ThreadingConfiguration getThreadingConfiguration() {
            return this.threadingConfiguration;
        }

        public final boolean getHideRunnerOutput() {
            return this.hideRunnerOutput;
        }

        public final boolean getCompactOutput() {
            return this.compactOutput;
        }

        @NotNull
        public final RsyncConfiguration getRsync() {
            return this.rsync;
        }

        @NotNull
        public final Map<String, String> getXcodebuildTestArgs() {
            return this.xcodebuildTestArgs;
        }

        @NotNull
        public final TestParserConfiguration getTestParserConfiguration() {
            return this.testParserConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration getPermissions() {
            return this.permissions;
        }

        public final void validate() {
            this.ssh.validate();
            AppleTestBundleConfiguration appleTestBundleConfiguration = this.bundle;
            if (appleTestBundleConfiguration == null) {
                throw new ConfigurationException("bundles must contain at least one valid entry");
            }
            AppleTestBundleConfiguration testBundleConfiguration = appleTestBundleConfiguration;
            testBundleConfiguration.validate();
        }

        @Nullable
        public final AppleTestBundleConfiguration component1() {
            return this.bundle;
        }

        @Nullable
        public final File component2() {
            return this.devicesFile;
        }

        @NotNull
        public final SshConfiguration component3() {
            return this.ssh;
        }

        @NotNull
        public final XcresultConfiguration component4() {
            return this.xcresult;
        }

        @NotNull
        public final XctestrunEnvConfiguration component5() {
            return this.xctestrunEnv;
        }

        @NotNull
        public final TimeoutConfiguration component6() {
            return this.timeoutConfiguration;
        }

        @NotNull
        public final ThreadingConfiguration component7() {
            return this.threadingConfiguration;
        }

        public final boolean component8() {
            return this.hideRunnerOutput;
        }

        public final boolean component9() {
            return this.compactOutput;
        }

        @NotNull
        public final RsyncConfiguration component10() {
            return this.rsync;
        }

        @NotNull
        public final Map<String, String> component11() {
            return this.xcodebuildTestArgs;
        }

        @NotNull
        public final TestParserConfiguration component12() {
            return this.testParserConfiguration;
        }

        @NotNull
        public final com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration component13() {
            return this.permissions;
        }

        @NotNull
        public final MacosConfiguration copy(@JsonProperty(value="bundle") @Nullable AppleTestBundleConfiguration bundle, @JsonProperty(value="devices") @Nullable File devicesFile, @JsonProperty(value="ssh") @NotNull SshConfiguration ssh, @JsonProperty(value="xcresult") @NotNull XcresultConfiguration xcresult, @JsonProperty(value="xctestrunEnv") @NotNull XctestrunEnvConfiguration xctestrunEnv, @JsonProperty(value="timeoutConfiguration") @NotNull TimeoutConfiguration timeoutConfiguration, @JsonProperty(value="threadingConfiguration") @NotNull ThreadingConfiguration threadingConfiguration, @JsonProperty(value="hideRunnerOutput") boolean hideRunnerOutput, @JsonProperty(value="compactOutput") boolean compactOutput, @JsonProperty(value="rsync") @NotNull RsyncConfiguration rsync, @JsonProperty(value="xcodebuildTestArgs") @NotNull Map<String, String> xcodebuildTestArgs, @JsonProperty(value="testParserConfiguration") @NotNull TestParserConfiguration testParserConfiguration, @JsonProperty(value="permissions") @NotNull com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration permissions) {
            Intrinsics.checkNotNullParameter((Object)ssh, (String)"ssh");
            Intrinsics.checkNotNullParameter((Object)xcresult, (String)"xcresult");
            Intrinsics.checkNotNullParameter((Object)xctestrunEnv, (String)"xctestrunEnv");
            Intrinsics.checkNotNullParameter((Object)timeoutConfiguration, (String)"timeoutConfiguration");
            Intrinsics.checkNotNullParameter((Object)threadingConfiguration, (String)"threadingConfiguration");
            Intrinsics.checkNotNullParameter((Object)rsync, (String)"rsync");
            Intrinsics.checkNotNullParameter(xcodebuildTestArgs, (String)"xcodebuildTestArgs");
            Intrinsics.checkNotNullParameter((Object)testParserConfiguration, (String)"testParserConfiguration");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return new MacosConfiguration(bundle, devicesFile, ssh, xcresult, xctestrunEnv, timeoutConfiguration, threadingConfiguration, hideRunnerOutput, compactOutput, rsync, xcodebuildTestArgs, testParserConfiguration, permissions);
        }

        public static /* synthetic */ MacosConfiguration copy$default(MacosConfiguration macosConfiguration, AppleTestBundleConfiguration appleTestBundleConfiguration, File file, SshConfiguration sshConfiguration, XcresultConfiguration xcresultConfiguration, XctestrunEnvConfiguration xctestrunEnvConfiguration, TimeoutConfiguration timeoutConfiguration, ThreadingConfiguration threadingConfiguration, boolean bl, boolean bl2, RsyncConfiguration rsyncConfiguration, Map map, TestParserConfiguration testParserConfiguration, com.malinskiy.marathon.config.vendor.apple.macos.PermissionsConfiguration permissionsConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                appleTestBundleConfiguration = macosConfiguration.bundle;
            }
            if ((n & 2) != 0) {
                file = macosConfiguration.devicesFile;
            }
            if ((n & 4) != 0) {
                sshConfiguration = macosConfiguration.ssh;
            }
            if ((n & 8) != 0) {
                xcresultConfiguration = macosConfiguration.xcresult;
            }
            if ((n & 0x10) != 0) {
                xctestrunEnvConfiguration = macosConfiguration.xctestrunEnv;
            }
            if ((n & 0x20) != 0) {
                timeoutConfiguration = macosConfiguration.timeoutConfiguration;
            }
            if ((n & 0x40) != 0) {
                threadingConfiguration = macosConfiguration.threadingConfiguration;
            }
            if ((n & 0x80) != 0) {
                bl = macosConfiguration.hideRunnerOutput;
            }
            if ((n & 0x100) != 0) {
                bl2 = macosConfiguration.compactOutput;
            }
            if ((n & 0x200) != 0) {
                rsyncConfiguration = macosConfiguration.rsync;
            }
            if ((n & 0x400) != 0) {
                map = macosConfiguration.xcodebuildTestArgs;
            }
            if ((n & 0x800) != 0) {
                testParserConfiguration = macosConfiguration.testParserConfiguration;
            }
            if ((n & 0x1000) != 0) {
                permissionsConfiguration = macosConfiguration.permissions;
            }
            return macosConfiguration.copy(appleTestBundleConfiguration, file, sshConfiguration, xcresultConfiguration, xctestrunEnvConfiguration, timeoutConfiguration, threadingConfiguration, bl, bl2, rsyncConfiguration, map, testParserConfiguration, permissionsConfiguration);
        }

        @NotNull
        public String toString() {
            return "MacosConfiguration(bundle=" + this.bundle + ", devicesFile=" + this.devicesFile + ", ssh=" + this.ssh + ", xcresult=" + this.xcresult + ", xctestrunEnv=" + this.xctestrunEnv + ", timeoutConfiguration=" + this.timeoutConfiguration + ", threadingConfiguration=" + this.threadingConfiguration + ", hideRunnerOutput=" + this.hideRunnerOutput + ", compactOutput=" + this.compactOutput + ", rsync=" + this.rsync + ", xcodebuildTestArgs=" + this.xcodebuildTestArgs + ", testParserConfiguration=" + this.testParserConfiguration + ", permissions=" + this.permissions + ")";
        }

        public int hashCode() {
            int result = this.bundle == null ? 0 : this.bundle.hashCode();
            result = result * 31 + (this.devicesFile == null ? 0 : this.devicesFile.hashCode());
            result = result * 31 + this.ssh.hashCode();
            result = result * 31 + this.xcresult.hashCode();
            result = result * 31 + this.xctestrunEnv.hashCode();
            result = result * 31 + this.timeoutConfiguration.hashCode();
            result = result * 31 + this.threadingConfiguration.hashCode();
            int n = this.hideRunnerOutput ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.compactOutput ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            result = result * 31 + this.rsync.hashCode();
            result = result * 31 + ((Object)this.xcodebuildTestArgs).hashCode();
            result = result * 31 + this.testParserConfiguration.hashCode();
            result = result * 31 + this.permissions.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MacosConfiguration)) {
                return false;
            }
            MacosConfiguration macosConfiguration = (MacosConfiguration)other;
            if (!Intrinsics.areEqual((Object)this.bundle, (Object)macosConfiguration.bundle)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.devicesFile, (Object)macosConfiguration.devicesFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ssh, (Object)macosConfiguration.ssh)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.xcresult, (Object)macosConfiguration.xcresult)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.xctestrunEnv, (Object)macosConfiguration.xctestrunEnv)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.timeoutConfiguration, (Object)macosConfiguration.timeoutConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.threadingConfiguration, (Object)macosConfiguration.threadingConfiguration)) {
                return false;
            }
            if (this.hideRunnerOutput != macosConfiguration.hideRunnerOutput) {
                return false;
            }
            if (this.compactOutput != macosConfiguration.compactOutput) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rsync, (Object)macosConfiguration.rsync)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.xcodebuildTestArgs, macosConfiguration.xcodebuildTestArgs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.testParserConfiguration, (Object)macosConfiguration.testParserConfiguration)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.permissions, (Object)macosConfiguration.permissions);
        }

        public MacosConfiguration() {
            this(null, null, null, null, null, null, null, false, false, null, null, null, null, 8191, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/malinskiy/marathon/config/vendor/VendorConfiguration$StubVendorConfiguration;", "Lcom/malinskiy/marathon/config/vendor/VendorConfiguration;", "()V", "configuration"})
    public static final class StubVendorConfiguration
    extends VendorConfiguration {
        @NotNull
        public static final StubVendorConfiguration INSTANCE = new StubVendorConfiguration();

        private StubVendorConfiguration() {
            super(null);
        }
    }
}

