/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.vendor.apple;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.malinskiy.marathon.config.exceptions.ConfigurationException;
import com.malinskiy.marathon.config.vendor.apple.AppleTestBundleConfiguration;
import com.malinskiy.marathon.config.vendor.apple.TestType;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 52\u00020\u0001:\u00015B]\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0003\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u0012\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bH\u00c2\u0003Ja\u0010%\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0010\b\u0003\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00062\n\b\u0003\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\b\u001a\u0004\u0018\u00010\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bH\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0002J\"\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010*\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'H\u0002J\"\u0010/\u001a\u0004\u0018\u00010\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020'H\u0002J\t\u00101\u001a\u000202H\u00d6\u0001J\t\u00103\u001a\u00020-H\u00d6\u0001J\u0006\u0010.\u001a\u000204R \u0010\r\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000f\"\u0004\b\u0018\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u00038\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000f\"\u0004\b\u001e\u0010\u0011\u00a8\u00066"}, d2={"Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration;", "", "application", "Ljava/io/File;", "testApplication", "extraApplications", "", "derivedDataDir", "testType", "Lcom/malinskiy/marathon/config/vendor/apple/TestType;", "tempDirFor", "Lkotlin/Function1;", "(Ljava/io/File;Ljava/io/File;Ljava/util/List;Ljava/io/File;Lcom/malinskiy/marathon/config/vendor/apple/TestType;Lkotlin/jvm/functions/Function1;)V", "app", "getApp", "()Ljava/io/File;", "setApp", "(Ljava/io/File;)V", "getApplication", "getDerivedDataDir", "getExtraApplications", "()Ljava/util/List;", "testApp", "getTestApp", "setTestApp", "getTestApplication", "getTestType", "()Lcom/malinskiy/marathon/config/vendor/apple/TestType;", "xctest", "getXctest", "setXctest", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "extract", "file", "extractAndFindDirectory", "extension", "", "validate", "findDirectoryInDirectory", "directory", "hashCode", "", "toString", "", "Companion", "configuration"})
@SourceDebugExtension(value={"SMAP\nAppleTestBundleConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppleTestBundleConfiguration.kt\ncom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1313#2,2:158\n766#3:160\n857#3,2:161\n766#3:165\n857#3,2:166\n37#4,2:163\n37#4,2:168\n1#5:170\n*S KotlinDebug\n*F\n+ 1 AppleTestBundleConfiguration.kt\ncom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration\n*L\n88#1:158,2\n131#1:160\n131#1:161,2\n137#1:165\n137#1:166,2\n132#1:163,2\n138#1:168,2\n*E\n"})
public final class AppleTestBundleConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File application;
    @Nullable
    private final File testApplication;
    @Nullable
    private final List<File> extraApplications;
    @Nullable
    private final File derivedDataDir;
    @Nullable
    private final TestType testType;
    @NotNull
    private final Function1<File, File> tempDirFor;
    @JsonIgnore
    @Nullable
    private File app;
    @JsonIgnore
    @Nullable
    private File testApp;
    @JsonIgnore
    public File xctest;
    @NotNull
    private static final Set<String> IGNORED;

    public AppleTestBundleConfiguration(@JsonProperty(value="application") @Nullable File application, @JsonProperty(value="testApplication") @Nullable File testApplication, @JsonProperty(value="extraApplications") @Nullable List<? extends File> extraApplications, @JsonProperty(value="derivedDataDir") @Nullable File derivedDataDir, @JsonProperty(value="testType") @Nullable TestType testType, @NotNull Function1<? super File, ? extends File> tempDirFor) {
        Intrinsics.checkNotNullParameter(tempDirFor, (String)"tempDirFor");
        this.application = application;
        this.testApplication = testApplication;
        this.extraApplications = extraApplications;
        this.derivedDataDir = derivedDataDir;
        this.testType = testType;
        this.tempDirFor = tempDirFor;
    }

    public /* synthetic */ AppleTestBundleConfiguration(File file, File file2, List list, File file3, TestType testType, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            file2 = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            file3 = null;
        }
        if ((n & 0x10) != 0) {
            testType = null;
        }
        if ((n & 0x20) != 0) {
            function1 = 1.INSTANCE;
        }
        this(file, file2, list, file3, testType, (Function1<? super File, ? extends File>)function1);
    }

    @Nullable
    public final File getApplication() {
        return this.application;
    }

    @Nullable
    public final File getTestApplication() {
        return this.testApplication;
    }

    @Nullable
    public final List<File> getExtraApplications() {
        return this.extraApplications;
    }

    @Nullable
    public final File getDerivedDataDir() {
        return this.derivedDataDir;
    }

    @Nullable
    public final TestType getTestType() {
        return this.testType;
    }

    @Nullable
    public final File getApp() {
        return this.app;
    }

    public final void setApp(@Nullable File file) {
        this.app = file;
    }

    @Nullable
    public final File getTestApp() {
        return this.testApp;
    }

    public final void setTestApp(@Nullable File file) {
        this.testApp = file;
    }

    @NotNull
    public final File getXctest() {
        File file = this.xctest;
        if (file != null) {
            return file;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"xctest");
        return null;
    }

    public final void setXctest(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.xctest = file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void validate() {
        if (this.application != null && this.testApplication != null) {
            File file;
            Object[] objectArray;
            if (this.application.isFile() && SetsKt.setOf((Object[])(objectArray = new String[]{"ipa", "zip"})).contains(FilesKt.getExtension((File)this.application))) {
                file = this.extractAndFindDirectory(this.application, "app", true);
            } else {
                if (!this.application.isDirectory() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.application), (Object)"app")) throw new ConfigurationException("application should be .ipa/.zip archive or a .app folder");
                file = this.application;
            }
            this.app = file;
            if (this.testApplication.isFile() && SetsKt.setOf((Object[])(objectArray = new String[]{"ipa", "zip"})).contains(FilesKt.getExtension((File)this.testApplication))) {
                File extracted = this.extract(this.testApplication);
                File possibleTestApp = this.findDirectoryInDirectory(extracted, "app", false);
                if (possibleTestApp != null) {
                    this.testApp = possibleTestApp;
                    File file2 = this.findDirectoryInDirectory(possibleTestApp, "xctest", true);
                    if (file2 == null) {
                        throw new ConfigurationException("Unable to find xctest bundle");
                    }
                    this.setXctest(file2);
                    return;
                } else {
                    File file3 = this.findDirectoryInDirectory(extracted, "xctest", true);
                    if (file3 == null) {
                        throw new ConfigurationException("Unable to find xctest bundle");
                    }
                    this.setXctest(file3);
                }
                return;
            } else if (this.testApplication.isDirectory() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.testApplication), (Object)"app")) {
                this.testApp = this.testApplication;
                File file4 = this.findDirectoryInDirectory(this.testApplication, "xctest", true);
                if (file4 == null) {
                    throw new ConfigurationException("Unable to find xctest bundle");
                }
                this.setXctest(file4);
                return;
            } else {
                if (!this.testApplication.isDirectory() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)this.testApplication), (Object)"xctest")) throw new ConfigurationException("test application should be .ipa/.zip archive or a .app/.xctest folder");
                this.setXctest(this.testApplication);
            }
            return;
        } else {
            if (this.derivedDataDir == null) throw new ConfigurationException("please specify your application and test application either with files or provide derived data folder");
            File file = this.findDirectoryInDirectory(this.derivedDataDir, "xctest", true);
            if (file == null) {
                throw new ConfigurationException("Unable to find xctest bundle");
            }
            this.setXctest(file);
            this.app = this.findDirectoryInDirectory(this.derivedDataDir, "app", true);
        }
    }

    private final File findDirectoryInDirectory(File directory, String extension, boolean validate) {
        List found = null;
        found = new ArrayList();
        Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)directory);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl = false;
            if (!it.isDirectory() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)it), (Object)extension)) continue;
            found.add(it);
        }
        if (found.isEmpty() && validate) {
            throw new ConfigurationException("Unable to find an " + extension + " directory in " + directory.getAbsolutePath());
        }
        if (found.size() == 2) {
            File file;
            File a = (File)CollectionsKt.removeFirst((List)found);
            File b = (File)CollectionsKt.removeFirst((List)found);
            Path path = FilesKt.relativeTo((File)a, (File)b).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            Path path2 = (Path)CollectionsKt.firstOrNull((Iterable)path);
            if (Intrinsics.areEqual((Object)(path2 != null ? ((Object)path2).toString() : null), (Object)"Watch")) {
                file = b;
            } else {
                Path path3 = FilesKt.relativeTo((File)b, (File)a).toPath();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toPath(...)");
                Path path4 = (Path)CollectionsKt.firstOrNull((Iterable)path3);
                if (Intrinsics.areEqual((Object)(path4 != null ? ((Object)path4).toString() : null), (Object)"Watch")) {
                    file = a;
                } else {
                    throw new ConfigurationException("Ambiguous " + extension + " configuration in derived data folder [" + CollectionsKt.joinToString$default((Iterable)found, null, null, null, (int)0, null, (Function1)findDirectoryInDirectory.2.INSTANCE, (int)31, null) + "]. Please specify parameters explicitly");
                }
            }
            return file;
        }
        if (found.size() > 2) {
            throw new ConfigurationException("Ambiguous " + extension + " configuration in derived data folder [" + CollectionsKt.joinToString$default((Iterable)found, null, null, null, (int)0, null, (Function1)findDirectoryInDirectory.3.INSTANCE, (int)31, null) + "]. Please specify parameters explicitly");
        }
        return (File)CollectionsKt.firstOrNull((List)found);
    }

    private final File extractAndFindDirectory(File file, String extension, boolean validate) {
        File extracted = this.extract(file);
        return this.findDirectoryInDirectory(extracted, extension, validate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final File extract(File file) {
        File dst = (File)this.tempDirFor.invoke((Object)file);
        Closeable closeable = new ZipFile(file);
        Throwable throwable = null;
        try {
            ZipFile zipFile = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Iterator iterator = CollectionsKt.iterator(enumeration);
            while (iterator.hasNext()) {
                String[] $this$filterTo$iv$iv;
                String[] $i$f$filter22;
                Object element$iv$iv2;
                Object object;
                ZipEntry entry = (ZipEntry)iterator.next();
                if (IGNORED.contains(entry.getName())) continue;
                if (entry.isDirectory()) {
                    void $this$filterTo$iv$iv2;
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    String[] stringArray = new String[]{"/"};
                    Object $this$filter$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$filter22 = false;
                    object = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                        String it = (String)element$iv$iv2;
                        boolean bl2 = false;
                        boolean bl3 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                        if (!bl3) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    List subpath = (List)destination$iv$iv;
                    String string2 = dst.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    $this$filter$iv = string2;
                    Collection $this$toTypedArray$iv = subpath;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    $i$f$filter22 = thisCollection$iv.toArray(new String[0]);
                    $i$f$filter22 = Arrays.copyOf($i$f$filter22, $i$f$filter22.length);
                    Path path = Paths.get((String)$this$filter$iv, Arrays.copyOf($i$f$filter22, $i$f$filter22.length));
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                    path.toFile().mkdirs();
                    continue;
                }
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String fileName = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null);
                String string3 = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                $i$f$filter22 = new String[]{"/"};
                Iterable $this$filter$iv = StringsKt.split$default((CharSequence)StringsKt.substringBeforeLast$default((String)string3, (String)"/", null, (int)2, null), (String[])$i$f$filter22, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$filter = false;
                Iterable $i$f$toTypedArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                element$iv$iv2 = $this$filterTo$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    Object element$iv$iv3 = element$iv$iv2.next();
                    String it = (String)element$iv$iv3;
                    boolean bl4 = false;
                    boolean bl5 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                    if (!bl5) continue;
                    destination$iv$iv.add(element$iv$iv3);
                }
                List parent = (List)destination$iv$iv;
                String string4 = dst.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                object = string4;
                Collection $this$toTypedArray$iv = parent;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$filterTo$iv$iv = thisCollection$iv.toArray(new String[0]);
                $this$filterTo$iv$iv = Arrays.copyOf($this$filterTo$iv$iv, $this$filterTo$iv$iv.length);
                Path path = Paths.get((String)object, Arrays.copyOf($this$filterTo$iv$iv, $this$filterTo$iv$iv.length));
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Object $this$extract_u24lambda_u246_u24lambda_u243 = object = path.toFile();
                boolean bl6 = false;
                ((File)$this$extract_u24lambda_u246_u24lambda_u243).mkdirs();
                Object parentFile = object;
                object = new FileOutputStream(new File((File)parentFile, fileName));
                Throwable throwable2 = null;
                try {
                    long l;
                    FileOutputStream outStream = (FileOutputStream)object;
                    boolean bl7 = false;
                    Closeable closeable2 = zipFile.getInputStream(entry);
                    Throwable throwable3 = null;
                    try {
                        InputStream inStream = (InputStream)closeable2;
                        boolean bl8 = false;
                        Intrinsics.checkNotNull((Object)inStream);
                        l = ByteStreamsKt.copyTo$default((InputStream)inStream, (OutputStream)outStream, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                    }
                    long l2 = l;
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return dst;
    }

    @Nullable
    public final File component1() {
        return this.application;
    }

    @Nullable
    public final File component2() {
        return this.testApplication;
    }

    @Nullable
    public final List<File> component3() {
        return this.extraApplications;
    }

    @Nullable
    public final File component4() {
        return this.derivedDataDir;
    }

    @Nullable
    public final TestType component5() {
        return this.testType;
    }

    private final Function1<File, File> component6() {
        return this.tempDirFor;
    }

    @NotNull
    public final AppleTestBundleConfiguration copy(@JsonProperty(value="application") @Nullable File application, @JsonProperty(value="testApplication") @Nullable File testApplication, @JsonProperty(value="extraApplications") @Nullable List<? extends File> extraApplications, @JsonProperty(value="derivedDataDir") @Nullable File derivedDataDir, @JsonProperty(value="testType") @Nullable TestType testType, @NotNull Function1<? super File, ? extends File> tempDirFor) {
        Intrinsics.checkNotNullParameter(tempDirFor, (String)"tempDirFor");
        return new AppleTestBundleConfiguration(application, testApplication, extraApplications, derivedDataDir, testType, tempDirFor);
    }

    public static /* synthetic */ AppleTestBundleConfiguration copy$default(AppleTestBundleConfiguration appleTestBundleConfiguration, File file, File file2, List list, File file3, TestType testType, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            file = appleTestBundleConfiguration.application;
        }
        if ((n & 2) != 0) {
            file2 = appleTestBundleConfiguration.testApplication;
        }
        if ((n & 4) != 0) {
            list = appleTestBundleConfiguration.extraApplications;
        }
        if ((n & 8) != 0) {
            file3 = appleTestBundleConfiguration.derivedDataDir;
        }
        if ((n & 0x10) != 0) {
            testType = appleTestBundleConfiguration.testType;
        }
        if ((n & 0x20) != 0) {
            function1 = appleTestBundleConfiguration.tempDirFor;
        }
        return appleTestBundleConfiguration.copy(file, file2, list, file3, testType, function1);
    }

    @NotNull
    public String toString() {
        return "AppleTestBundleConfiguration(application=" + this.application + ", testApplication=" + this.testApplication + ", extraApplications=" + this.extraApplications + ", derivedDataDir=" + this.derivedDataDir + ", testType=" + this.testType + ", tempDirFor=" + this.tempDirFor + ")";
    }

    public int hashCode() {
        int result = this.application == null ? 0 : this.application.hashCode();
        result = result * 31 + (this.testApplication == null ? 0 : this.testApplication.hashCode());
        result = result * 31 + (this.extraApplications == null ? 0 : ((Object)this.extraApplications).hashCode());
        result = result * 31 + (this.derivedDataDir == null ? 0 : this.derivedDataDir.hashCode());
        result = result * 31 + (this.testType == null ? 0 : this.testType.hashCode());
        result = result * 31 + this.tempDirFor.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppleTestBundleConfiguration)) {
            return false;
        }
        AppleTestBundleConfiguration appleTestBundleConfiguration = (AppleTestBundleConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.application, (Object)appleTestBundleConfiguration.application)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.testApplication, (Object)appleTestBundleConfiguration.testApplication)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.extraApplications, appleTestBundleConfiguration.extraApplications)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.derivedDataDir, (Object)appleTestBundleConfiguration.derivedDataDir)) {
            return false;
        }
        if (this.testType != appleTestBundleConfiguration.testType) {
            return false;
        }
        return Intrinsics.areEqual(this.tempDirFor, appleTestBundleConfiguration.tempDirFor);
    }

    public AppleTestBundleConfiguration() {
        this(null, null, null, null, null, null, 63, null);
    }

    static {
        Object[] objectArray = new String[]{"__MACOSX", ".DS_Store"};
        IGNORED = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/malinskiy/marathon/config/vendor/apple/AppleTestBundleConfiguration$Companion;", "", "()V", "IGNORED", "", "", "getIGNORED", "()Ljava/util/Set;", "configuration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getIGNORED() {
            return IGNORED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

