/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon.config.vendor.apple;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.malinskiy.marathon.config.vendor.apple.SshAuthentication;
import java.io.File;
import java.io.FileNotFoundException;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0003\u0010\b\u001a\u00020\t\u0012\b\b\u0003\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J?\u0010\u001a\u001a\u00020\u00002\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u00072\b\b\u0003\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0006\u0010!\u001a\u00020\"R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006#"}, d2={"Lcom/malinskiy/marathon/config/vendor/apple/SshConfiguration;", "", "authentication", "Lcom/malinskiy/marathon/config/vendor/apple/SshAuthentication;", "knownHostsPath", "Ljava/io/File;", "keepAliveInterval", "Ljava/time/Duration;", "debug", "", "shareWorkerConnection", "(Lcom/malinskiy/marathon/config/vendor/apple/SshAuthentication;Ljava/io/File;Ljava/time/Duration;ZZ)V", "getAuthentication", "()Lcom/malinskiy/marathon/config/vendor/apple/SshAuthentication;", "getDebug", "()Z", "getKeepAliveInterval", "()Ljava/time/Duration;", "getKnownHostsPath", "()Ljava/io/File;", "getShareWorkerConnection", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "validate", "", "configuration"})
public final class SshConfiguration {
    @Nullable
    private final SshAuthentication authentication;
    @Nullable
    private final File knownHostsPath;
    @NotNull
    private final Duration keepAliveInterval;
    private final boolean debug;
    private final boolean shareWorkerConnection;

    public SshConfiguration(@JsonProperty(value="authentication") @Nullable SshAuthentication authentication, @JsonProperty(value="knownHostsPath") @Nullable File knownHostsPath, @JsonProperty(value="keepAliveInterval") @NotNull Duration keepAliveInterval, @JsonProperty(value="debug") boolean debug, @JsonProperty(value="shareWorkerConnection") boolean shareWorkerConnection) {
        Intrinsics.checkNotNullParameter((Object)keepAliveInterval, (String)"keepAliveInterval");
        this.authentication = authentication;
        this.knownHostsPath = knownHostsPath;
        this.keepAliveInterval = keepAliveInterval;
        this.debug = debug;
        this.shareWorkerConnection = shareWorkerConnection;
    }

    public /* synthetic */ SshConfiguration(SshAuthentication sshAuthentication, File file, Duration duration, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sshAuthentication = null;
        }
        if ((n & 2) != 0) {
            file = null;
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(60L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(sshAuthentication, file, duration, bl, bl2);
    }

    @Nullable
    public final SshAuthentication getAuthentication() {
        return this.authentication;
    }

    @Nullable
    public final File getKnownHostsPath() {
        return this.knownHostsPath;
    }

    @NotNull
    public final Duration getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public final boolean getDebug() {
        return this.debug;
    }

    public final boolean getShareWorkerConnection() {
        return this.shareWorkerConnection;
    }

    public final void validate() {
        SshAuthentication sshAuthentication = this.authentication;
        if (sshAuthentication != null) {
            SshAuthentication it = sshAuthentication;
            boolean bl = false;
            SshAuthentication sshAuthentication2 = it;
            if (!(sshAuthentication2 instanceof SshAuthentication.PasswordAuthentication) && sshAuthentication2 instanceof SshAuthentication.PublicKeyAuthentication && !((SshAuthentication.PublicKeyAuthentication)it).getKey().exists()) {
                throw new FileNotFoundException("Private key not found at " + ((SshAuthentication.PublicKeyAuthentication)it).getKey().getAbsolutePath());
            }
        }
        File file = this.knownHostsPath;
        boolean bl = file != null ? !file.exists() : false;
        if (bl) {
            throw new FileNotFoundException("knownhosts file not found at " + this.knownHostsPath);
        }
    }

    @Nullable
    public final SshAuthentication component1() {
        return this.authentication;
    }

    @Nullable
    public final File component2() {
        return this.knownHostsPath;
    }

    @NotNull
    public final Duration component3() {
        return this.keepAliveInterval;
    }

    public final boolean component4() {
        return this.debug;
    }

    public final boolean component5() {
        return this.shareWorkerConnection;
    }

    @NotNull
    public final SshConfiguration copy(@JsonProperty(value="authentication") @Nullable SshAuthentication authentication, @JsonProperty(value="knownHostsPath") @Nullable File knownHostsPath, @JsonProperty(value="keepAliveInterval") @NotNull Duration keepAliveInterval, @JsonProperty(value="debug") boolean debug, @JsonProperty(value="shareWorkerConnection") boolean shareWorkerConnection) {
        Intrinsics.checkNotNullParameter((Object)keepAliveInterval, (String)"keepAliveInterval");
        return new SshConfiguration(authentication, knownHostsPath, keepAliveInterval, debug, shareWorkerConnection);
    }

    public static /* synthetic */ SshConfiguration copy$default(SshConfiguration sshConfiguration, SshAuthentication sshAuthentication, File file, Duration duration, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            sshAuthentication = sshConfiguration.authentication;
        }
        if ((n & 2) != 0) {
            file = sshConfiguration.knownHostsPath;
        }
        if ((n & 4) != 0) {
            duration = sshConfiguration.keepAliveInterval;
        }
        if ((n & 8) != 0) {
            bl = sshConfiguration.debug;
        }
        if ((n & 0x10) != 0) {
            bl2 = sshConfiguration.shareWorkerConnection;
        }
        return sshConfiguration.copy(sshAuthentication, file, duration, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "SshConfiguration(authentication=" + this.authentication + ", knownHostsPath=" + this.knownHostsPath + ", keepAliveInterval=" + this.keepAliveInterval + ", debug=" + this.debug + ", shareWorkerConnection=" + this.shareWorkerConnection + ")";
    }

    public int hashCode() {
        int result = this.authentication == null ? 0 : this.authentication.hashCode();
        result = result * 31 + (this.knownHostsPath == null ? 0 : this.knownHostsPath.hashCode());
        result = result * 31 + this.keepAliveInterval.hashCode();
        int n = this.debug ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        int n2 = this.shareWorkerConnection ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result = result * 31 + n2;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SshConfiguration)) {
            return false;
        }
        SshConfiguration sshConfiguration = (SshConfiguration)other;
        if (!Intrinsics.areEqual((Object)this.authentication, (Object)sshConfiguration.authentication)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.knownHostsPath, (Object)sshConfiguration.knownHostsPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.keepAliveInterval, (Object)sshConfiguration.keepAliveInterval)) {
            return false;
        }
        if (this.debug != sshConfiguration.debug) {
            return false;
        }
        return this.shareWorkerConnection == sshConfiguration.shareWorkerConnection;
    }

    public SshConfiguration() {
        this(null, null, null, false, false, 31, null);
    }
}

