/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon;

import com.malinskiy.marathon.AnalyticsConfig;
import com.malinskiy.marathon.GraphiteConfig;
import com.malinskiy.marathon.InfluxConfig;
import com.malinskiy.marathon.RetentionPolicy;
import com.malinskiy.marathon.execution.AnalyticsConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0002\u00a8\u0006\u0006"}, d2={"toAnalyticsConfiguration", "Lcom/malinskiy/marathon/execution/AnalyticsConfiguration;", "Lcom/malinskiy/marathon/AnalyticsConfig;", "toRetentionPolicy", "Lcom/malinskiy/marathon/execution/AnalyticsConfiguration$InfluxDbConfiguration$RetentionPolicyConfiguration;", "Lcom/malinskiy/marathon/RetentionPolicy;", "marathon-gradle-plugin"})
public final class AnalyticsConfigKt {
    @NotNull
    public static final AnalyticsConfiguration toAnalyticsConfiguration(@NotNull AnalyticsConfig $this$toAnalyticsConfiguration) {
        AnalyticsConfiguration analyticsConfiguration;
        Intrinsics.checkNotNullParameter((Object)$this$toAnalyticsConfiguration, (String)"$this$toAnalyticsConfiguration");
        InfluxConfig influx = $this$toAnalyticsConfiguration.getInflux();
        GraphiteConfig graphite = $this$toAnalyticsConfiguration.getGraphite();
        if (influx != null) {
            String string = influx.getDbName();
            String string2 = influx.getUser();
            String string3 = influx.getPassword();
            String string4 = influx.getUrl();
            RetentionPolicy retentionPolicy = influx.getRetentionPolicy();
            if (retentionPolicy == null || (retentionPolicy = AnalyticsConfigKt.toRetentionPolicy(retentionPolicy)) == null) {
                retentionPolicy = AnalyticsConfiguration.InfluxDbConfiguration.RetentionPolicyConfiguration.Companion.getDefault();
            }
            RetentionPolicy retentionPolicy2 = retentionPolicy;
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            String string8 = string;
            analyticsConfiguration = (AnalyticsConfiguration)new AnalyticsConfiguration.InfluxDbConfiguration(string5, string7, string6, string8, (AnalyticsConfiguration.InfluxDbConfiguration.RetentionPolicyConfiguration)retentionPolicy2);
        } else if (graphite != null) {
            String string = graphite.getPort();
            analyticsConfiguration = (AnalyticsConfiguration)new AnalyticsConfiguration.GraphiteConfiguration(graphite.getHost(), string != null ? StringsKt.toIntOrNull((String)string) : null, graphite.getPrefix());
        } else {
            analyticsConfiguration = (AnalyticsConfiguration)AnalyticsConfiguration.DisabledAnalytics.INSTANCE;
        }
        return analyticsConfiguration;
    }

    private static final AnalyticsConfiguration.InfluxDbConfiguration.RetentionPolicyConfiguration toRetentionPolicy(RetentionPolicy $this$toRetentionPolicy) {
        return new AnalyticsConfiguration.InfluxDbConfiguration.RetentionPolicyConfiguration($this$toRetentionPolicy.getName(), $this$toRetentionPolicy.getDuration(), $this$toRetentionPolicy.getShardDuration(), $this$toRetentionPolicy.getReplicationFactor(), $this$toRetentionPolicy.isDefault());
    }
}

