/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.marathon;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestedExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.TestVariant;
import com.malinskiy.marathon.MarathonExtension;
import com.malinskiy.marathon.MarathonPlugin;
import com.malinskiy.marathon.MarathonPluginKt;
import com.malinskiy.marathon.MarathonRunTask;
import com.malinskiy.marathon.config.AppType;
import com.malinskiy.marathon.exceptions.ExceptionsReporter;
import com.malinskiy.marathon.exceptions.ExceptionsReporterFactory;
import com.malinskiy.marathon.extensions.GradleExtensionsKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.kotlin.dsl.GroovyInteroperabilityKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/malinskiy/marathon/MarathonPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "marathon-gradle-plugin"})
public final class MarathonPlugin
implements Plugin<Project> {
    private static final String TASK_PREFIX = "marathon";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        MarathonPluginKt.access$getLog$p().info((Function0)apply.1.INSTANCE);
        Object object = project.getExtensions().create(TASK_PREFIX, MarathonExtension.class, new Object[]{project});
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.creat\u2026ion::class.java, project)");
        MarathonExtension extension = (MarathonExtension)object;
        project.afterEvaluate((Action)new Action<Project>(extension, project){
            final /* synthetic */ MarathonExtension $extension;
            final /* synthetic */ Project $project;

            public final void execute(@NotNull Project $this$afterEvaluate) {
                MarathonExtension marathonExtension;
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$receiver");
                ExceptionsReporter exceptionsReporter = ExceptionsReporterFactory.Companion.get(Intrinsics.areEqual((Object)this.$extension.getBugsnag(), (Object)false) ^ true);
                exceptionsReporter.start(AppType.GRADLE_PLUGIN);
                AppPlugin appPlugin = (AppPlugin)this.$project.getPlugins().findPlugin(AppPlugin.class);
                LibraryPlugin libraryPlugin = (LibraryPlugin)this.$project.getPlugins().findPlugin(LibraryPlugin.class);
                if (appPlugin == null && libraryPlugin == null) {
                    throw (Throwable)new IllegalStateException("Android plugin is not found");
                }
                Task task = this.$project.task("marathon", GroovyInteroperabilityKt.closureOf((Object)$this$afterEvaluate, (Function1)apply.marathonTask.1.INSTANCE));
                Intrinsics.checkNotNullExpressionValue((Object)task, (String)"project.task(TASK_PREFIX\u2026d devices\"\n            })");
                Task marathonTask2 = task;
                AppExtension appExtension = (AppExtension)$this$afterEvaluate.getExtensions().findByType(AppExtension.class);
                LibraryExtension libraryExtension = (LibraryExtension)$this$afterEvaluate.getExtensions().findByType(LibraryExtension.class);
                if (appExtension == null && libraryExtension == null) {
                    throw (Throwable)new IllegalStateException("No TestedExtension is found");
                }
                AppExtension appExtension2 = appExtension;
                TestedExtension testedExtension = appExtension2 != null ? (TestedExtension)appExtension2 : (TestedExtension)libraryExtension;
                Object object = $this$afterEvaluate.getExtensions().getByName("marathon");
                if (!(object instanceof MarathonExtension)) {
                    object = null;
                }
                if ((marathonExtension = (MarathonExtension)object) == null) {
                    marathonExtension = new MarathonExtension(this.$project);
                }
                MarathonExtension conf = marathonExtension;
                TestedExtension testedExtension2 = testedExtension;
                Intrinsics.checkNotNull((Object)testedExtension2);
                testedExtension2.getTestVariants().all((Action)new Action<TestVariant>(this, conf, testedExtension, exceptionsReporter, marathonTask2){
                    final /* synthetic */ apply.2 this$0;
                    final /* synthetic */ MarathonExtension $conf;
                    final /* synthetic */ TestedExtension $testedExtension;
                    final /* synthetic */ ExceptionsReporter $exceptionsReporter;
                    final /* synthetic */ Task $marathonTask;

                    public final void execute(@NotNull TestVariant $this$all) {
                        Intrinsics.checkNotNullParameter((Object)$this$all, (String)"$receiver");
                        MarathonPluginKt.access$getLog$p().info((Function0)new Function0<Object>($this$all){
                            final /* synthetic */ TestVariant $this_all;

                            @Nullable
                            public final Object invoke() {
                                StringBuilder stringBuilder = new StringBuilder().append("Applying marathon for ");
                                TestVariant testVariant = this.$this_all;
                                Intrinsics.checkNotNullExpressionValue((Object)testVariant, (String)"this");
                                return stringBuilder.append(testVariant.getBaseName()).toString();
                            }
                            {
                                this.$this_all = testVariant;
                                super(0);
                            }
                        });
                        MarathonRunTask testTaskForVariant = com.malinskiy.marathon.MarathonPlugin$Companion.access$createTask(MarathonPlugin.Companion, $this$all, this.this$0.$project, this.$conf, this.$testedExtension.getSdkDirectory(), this.$exceptionsReporter);
                        this.$marathonTask.dependsOn(new Object[]{testTaskForVariant});
                    }
                    {
                        this.this$0 = var1_1;
                        this.$conf = marathonExtension;
                        this.$testedExtension = testedExtension;
                        this.$exceptionsReporter = exceptionsReporter;
                        this.$marathonTask = task;
                    }
                });
            }
            {
                this.$extension = marathonExtension;
                this.$project = project;
            }
        });
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/malinskiy/marathon/MarathonPlugin$Companion;", "", "()V", "TASK_PREFIX", "", "checkTestVariants", "", "testVariant", "Lcom/android/build/gradle/api/TestVariant;", "checkTestedVariants", "baseVariantOutput", "Lcom/android/build/gradle/api/BaseVariantOutput;", "createTask", "Lcom/malinskiy/marathon/MarathonRunTask;", "variant", "project", "Lorg/gradle/api/Project;", "config", "Lcom/malinskiy/marathon/MarathonExtension;", "sdkDirectory", "Ljava/io/File;", "exceptionsReporter", "Lcom/malinskiy/marathon/exceptions/ExceptionsReporter;", "marathon-gradle-plugin"})
    public static final class Companion {
        private final MarathonRunTask createTask(TestVariant variant, Project project, MarathonExtension config, File sdkDirectory, ExceptionsReporter exceptionsReporter) {
            this.checkTestVariants(variant);
            TaskContainer taskContainer = project.getTasks();
            StringBuilder stringBuilder = new StringBuilder().append(MarathonPlugin.TASK_PREFIX);
            String string = variant.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
            Task task = taskContainer.create(stringBuilder.append(StringsKt.capitalize((String)string)).toString(), MarathonRunTask.class);
            Intrinsics.checkNotNullExpressionValue((Object)task, (String)"project.tasks.create(\"$T\u2026athonRunTask::class.java)");
            MarathonRunTask marathonTask2 = (MarathonRunTask)task;
            BaseVariant baseVariant = variant.getTestedVariant();
            Intrinsics.checkNotNullExpressionValue((Object)baseVariant, (String)"variant.testedVariant");
            baseVariant.getOutputs().all((Action)new Action<BaseVariantOutput>(marathonTask2, variant, config, sdkDirectory, exceptionsReporter){
                final /* synthetic */ MarathonRunTask $marathonTask;
                final /* synthetic */ TestVariant $variant;
                final /* synthetic */ MarathonExtension $config;
                final /* synthetic */ File $sdkDirectory;
                final /* synthetic */ ExceptionsReporter $exceptionsReporter;

                public final void execute(@NotNull BaseVariantOutput $this$all) {
                    Intrinsics.checkNotNullParameter((Object)$this$all, (String)"$receiver");
                    BaseVariantOutput testedOutput = $this$all;
                    MarathonPluginKt.access$getLog$p().info((Function0)new Function0<Object>(testedOutput){
                        final /* synthetic */ BaseVariantOutput $testedOutput;

                        @Nullable
                        public final Object invoke() {
                            return "Processing output " + this.$testedOutput;
                        }
                        {
                            this.$testedOutput = baseVariantOutput;
                            super(0);
                        }
                    });
                    com.malinskiy.marathon.MarathonPlugin$Companion.access$checkTestedVariants(MarathonPlugin.Companion, testedOutput);
                    this.$marathonTask.configure(GroovyInteroperabilityKt.closureOf((Object)$this$all, (Function1)((Function1)new Function1<MarathonRunTask, Unit>(this){
                        final /* synthetic */ createTask.1 this$0;

                        public final void invoke(@NotNull MarathonRunTask $this$closureOf) {
                            Intrinsics.checkNotNullParameter((Object)((Object)$this$closureOf), (String)"$receiver");
                            $this$closureOf.setGroup("verification");
                            $this$closureOf.setDescription("Runs instrumentation tests on all the connected devices for '" + this.this$0.$variant.getName() + "' " + "variation and generates a report with screenshots");
                            $this$closureOf.getFlavorName().set((Object)this.this$0.$variant.getName());
                            $this$closureOf.getApplicationVariant().set((Object)this.this$0.$variant.getTestedVariant());
                            $this$closureOf.getTestVariant().set((Object)this.this$0.$variant);
                            $this$closureOf.getMarathonExtension().set((Object)this.this$0.$config);
                            $this$closureOf.getSdk().set(this.this$0.$sdkDirectory);
                            $this$closureOf.getOutputs().upToDateWhen((Spec)Companion.createTask.1.INSTANCE);
                            $this$closureOf.getExceptionsTracker().set((Object)this.this$0.$exceptionsReporter);
                            GradleExtensionsKt.executeGradleCompat((Function0)new Function0<Unit>(this, $this$closureOf){
                                final /* synthetic */ createTask.2 this$0;
                                final /* synthetic */ MarathonRunTask $this_closureOf;

                                public final void invoke() {
                                    Object[] objectArray = new Object[2];
                                    BaseVariant baseVariant = this.this$0.this$0.$variant.getTestedVariant();
                                    Intrinsics.checkNotNullExpressionValue((Object)baseVariant, (String)"variant.testedVariant");
                                    objectArray[0] = baseVariant.getAssembleProvider();
                                    objectArray[1] = this.this$0.this$0.$variant.getAssembleProvider();
                                    this.$this_closureOf.dependsOn(objectArray);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$this_closureOf = marathonRunTask;
                                    super(0);
                                }
                            }, CollectionsKt.listOf((Object)new Function0<Unit>(this, $this$closureOf){
                                final /* synthetic */ createTask.2 this$0;
                                final /* synthetic */ MarathonRunTask $this_closureOf;

                                public final void invoke() {
                                    Object[] objectArray = new Object[2];
                                    BaseVariant baseVariant = this.this$0.this$0.$variant.getTestedVariant();
                                    Intrinsics.checkNotNullExpressionValue((Object)baseVariant, (String)"variant.testedVariant");
                                    objectArray[0] = baseVariant.getAssemble();
                                    objectArray[1] = this.this$0.this$0.$variant.getAssemble();
                                    this.$this_closureOf.dependsOn(objectArray);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$this_closureOf = marathonRunTask;
                                    super(0);
                                }
                            }));
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    })));
                }
                {
                    this.$marathonTask = marathonRunTask;
                    this.$variant = testVariant;
                    this.$config = marathonExtension;
                    this.$sdkDirectory = file;
                    this.$exceptionsReporter = exceptionsReporter;
                }
            });
            return marathonTask2;
        }

        private final void checkTestVariants(TestVariant testVariant) {
            if (testVariant.getOutputs().size() > 1) {
                throw (Throwable)new UnsupportedOperationException("The Marathon plugin does not support abi/density splits for test APKs");
            }
        }

        private final void checkTestedVariants(BaseVariantOutput baseVariantOutput) {
            if (baseVariantOutput.getOutputs().size() > 1) {
                throw (Throwable)new UnsupportedOperationException("The Marathon plugin does not support abi splits for app APKs, but supports testing via a universal APK. Add the flag \"universalApk true\" in the android.splits.abi configuration.");
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ MarathonRunTask access$createTask(Companion $this, TestVariant variant, Project project, MarathonExtension config, File sdkDirectory, ExceptionsReporter exceptionsReporter) {
            return $this.createTask(variant, project, config, sdkDirectory, exceptionsReporter);
        }

        public static final /* synthetic */ void access$checkTestedVariants(Companion $this, BaseVariantOutput baseVariantOutput) {
            $this.checkTestedVariants(baseVariantOutput);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

