/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.materialicons;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import com.malinskiy.materialicons.Iconify;
import com.malinskiy.materialicons.Utils;

public class IconDrawable
extends Drawable {
    public static final int ANDROID_ACTIONBAR_ICON_SIZE_DP = 24;
    private final Context context;
    private final Iconify.IconValue icon;
    private TextPaint paint;
    private int size = -1;
    private int alpha = 255;

    public IconDrawable(Context context, Iconify.IconValue icon) {
        this.context = context;
        this.icon = icon;
        this.paint = new TextPaint();
        this.paint.setTypeface(Iconify.getTypeface(context));
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setTextAlign(Paint.Align.CENTER);
        this.paint.setUnderlineText(false);
        this.paint.setColor(-16777216);
        this.paint.setAntiAlias(true);
    }

    public IconDrawable actionBarSize() {
        return this.sizeDp(24);
    }

    public IconDrawable sizeRes(int dimenRes) {
        return this.sizePx(this.context.getResources().getDimensionPixelSize(dimenRes));
    }

    public IconDrawable sizeDp(int size) {
        return this.sizePx(Utils.convertDpToPx(this.context, size));
    }

    public IconDrawable sizePx(int size) {
        this.size = size;
        this.setBounds(0, 0, size, size);
        this.invalidateSelf();
        return this;
    }

    public IconDrawable color(int color) {
        this.paint.setColor(color);
        this.invalidateSelf();
        return this;
    }

    public IconDrawable colorRes(int colorRes) {
        this.paint.setColor(this.context.getResources().getColor(colorRes));
        this.invalidateSelf();
        return this;
    }

    public IconDrawable alpha(int alpha) {
        this.setAlpha(alpha);
        this.invalidateSelf();
        return this;
    }

    public int getIntrinsicHeight() {
        return this.size;
    }

    public int getIntrinsicWidth() {
        return this.size;
    }

    public void draw(Canvas canvas) {
        this.paint.setTextSize((float)this.getBounds().height());
        Rect textBounds = new Rect();
        String textValue = String.valueOf(this.icon.character);
        this.paint.getTextBounds(textValue, 0, 1, textBounds);
        float textBottom = (float)(this.getBounds().height() - textBounds.height()) / 2.0f + (float)textBounds.height() - (float)textBounds.bottom;
        canvas.drawText(textValue, (float)this.getBounds().width() / 2.0f, textBottom, (Paint)this.paint);
    }

    public boolean isStateful() {
        return true;
    }

    public boolean setState(int[] stateSet) {
        int oldValue = this.paint.getAlpha();
        int newValue = Utils.isEnabled(stateSet) ? this.alpha : this.alpha / 2;
        this.paint.setAlpha(newValue);
        return oldValue != newValue;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.paint.setColorFilter(cf);
    }

    public void clearColorFilter() {
        this.paint.setColorFilter(null);
    }

    public int getOpacity() {
        return this.alpha;
    }

    public void setStyle(Paint.Style style) {
        this.paint.setStyle(style);
    }
}

