/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.materialicons;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import com.malinskiy.materialicons.Iconify;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class Utils {
    public static final String ICON_FONT_FOLDER = "icon_tmp";
    public static final String NAME_PREFIX = "{zmdi";

    private Utils() {
    }

    static int convertDpToPx(Context context, float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    static boolean isEnabled(int[] stateSet) {
        for (int state : stateSet) {
            if (state != 16842910) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File resourceToFile(Context context, String resourceName) throws IOException {
        File file;
        File f = null;
        f = context.getFilesDir() == null ? new File(context.getCacheDir(), ICON_FONT_FOLDER) : new File(context.getFilesDir(), ICON_FONT_FOLDER);
        if (!f.exists() && !f.mkdirs()) {
            Log.e((String)Iconify.TAG, (String)"Font folder creation failed");
            throw new IllegalStateException("Cannot create Iconify font destination folder");
        }
        File outPath = new File(f, resourceName);
        if (outPath.exists()) {
            return outPath;
        }
        BufferedOutputStream bos = null;
        InputStream inputStream = null;
        try {
            inputStream = Iconify.class.getClassLoader().getResourceAsStream(resourceName);
            byte[] buffer = new byte[inputStream.available()];
            bos = new BufferedOutputStream(new FileOutputStream(outPath));
            int l = 0;
            while ((l = inputStream.read(buffer)) > 0) {
                bos.write(buffer, 0, l);
            }
            file = outPath;
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(bos);
            Utils.closeQuietly(inputStream);
            throw throwable;
        }
        Utils.closeQuietly(bos);
        Utils.closeQuietly(inputStream);
        return file;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static StringBuilder replaceIcons(StringBuilder text) {
        int startIndex = text.indexOf(NAME_PREFIX);
        if (startIndex == -1) {
            return text;
        }
        int endIndex = text.substring(startIndex).indexOf("}") + startIndex + 1;
        String iconString = text.substring(startIndex + 1, endIndex - 1);
        iconString = iconString.replaceAll("-", "_");
        try {
            Iconify.IconValue value = Iconify.IconValue.valueOf(iconString);
            String iconValue = String.valueOf(value.character);
            text = text.replace(startIndex, endIndex, iconValue);
            return Utils.replaceIcons(text);
        }
        catch (IllegalArgumentException e) {
            Log.w((String)Iconify.TAG, (String)("Wrong icon name: " + iconString));
            return text;
        }
    }
}

