/*
 * Decompiled with CFR 0.152.
 */
package com.malinskiy.materialicons.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import com.malinskiy.materialicons.Iconify;
import com.malinskiy.materialicons.R;

public class IconTextView
extends TextView {
    public IconTextView(Context context) {
        super(context);
        this.init(null);
    }

    public IconTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public IconTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        boolean hackyPreview = false;
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.IconTextView, 0, 0);
        try {
            hackyPreview = a.getBoolean(R.styleable.IconTextView_hacky_preview, false);
        }
        finally {
            a.recycle();
        }
        if (!this.isInEditMode()) {
            Iconify.addIcons(this);
        } else if (hackyPreview) {
            Iconify.addIconsEditMode(this);
        } else {
            this.setText(this.getText());
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(Iconify.compute(text), type);
    }
}

