/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal;

import com.mammb.code.jpostal.MunicipalId;
import com.mammb.code.jpostal.PostalCode;
import java.io.Serializable;
import java.util.Objects;

public class Address
implements Serializable {
    private final PostalCode code;
    private final MunicipalId municipalId;
    private final String prefecture;
    private final String city;
    private final String town;
    private final String street;

    private Address(PostalCode code, MunicipalId municipalId, String prefecture, String city, String town, String street) {
        this.code = Objects.requireNonNull(code);
        this.municipalId = Objects.requireNonNull(municipalId);
        this.prefecture = Objects.isNull(prefecture) ? "" : prefecture;
        this.city = Objects.isNull(city) ? "" : city;
        this.town = Objects.isNull(town) ? "" : town;
        this.street = Objects.isNull(street) ? "" : street;
    }

    public static Address of(PostalCode code, MunicipalId municipalId, String prefecture, String city, String town, String street) {
        return new Address(code, municipalId, prefecture, city, town, street);
    }

    public PostalCode getCode() {
        return this.code;
    }

    public MunicipalId getMunicipalId() {
        return this.municipalId;
    }

    public String getPrefecture() {
        return this.prefecture;
    }

    public String getCity() {
        return this.city;
    }

    public String getTown() {
        return this.town;
    }

    public String getStreet() {
        return this.street;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return this.code.equals(address.code) && this.municipalId.equals(address.municipalId) && this.prefecture.equals(address.prefecture) && this.city.equals(address.city) && this.town.equals(address.town) && this.street.equals(address.street);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.municipalId, this.prefecture, this.city, this.town, this.street);
    }

    public String toString() {
        return "Address{code=" + this.code + ", municipalId='" + this.municipalId + "', prefecture='" + this.prefecture + "', city='" + this.city + "', town='" + this.town + "', street='" + this.street + "'}";
    }

    public String toJsonString() {
        return String.format("{'code': '%s', 'prefectureCode': '%s', 'municipalityCode': '%s', 'prefecture': '%s', 'city': '%s', 'town': '%s', 'street': '%s'}".replace("'", "\""), this.code.getCode(), this.municipalId.getPrefCode(), this.municipalId.getMunicipalCode(), this.prefecture, this.city, this.town, this.street);
    }
}

