/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal;

import com.mammb.code.jpostal.Postal;
import com.mammb.code.jpostal.server.PostalServer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class App {
    private static final System.Logger log = System.getLogger(App.class.getName());

    public static void main(String[] args) {
        if (args != null && args.length > 1 && args[0].equals("-o")) {
            App.writeCsv(args[1]);
            System.exit(0);
        }
        Postal postal = Postal.of().useLegacySource(false).fineAddressSupport(true).leftMatchSupport(true).leftMatchLimitCount(20).officeSourceSupport(false).autoUpdateSupport(true);
        log.log(System.Logger.Level.INFO, "initializing...");
        postal.initialize();
        log.log(System.Logger.Level.INFO, "initialized");
        log.log(System.Logger.Level.INFO, "start server..");
        PostalServer server = PostalServer.of(postal);
        server.start();
        log.log(System.Logger.Level.INFO, "http://localhost:8080/postal/console.html");
    }

    private static void writeCsv(String pathString) {
        Path path;
        if (pathString == null || !pathString.endsWith(".csv")) {
            log.log(System.Logger.Level.ERROR, "illegal path [{0}]", pathString);
            System.exit(1);
        }
        if (Files.isDirectory(path = Path.of(pathString, new String[0]), new LinkOption[0]) || !path.toString().endsWith(".csv")) {
            log.log(System.Logger.Level.ERROR, "Illegal path.[{0}]", path);
            System.exit(1);
        }
        if (Files.exists(path, new LinkOption[0])) {
            log.log(System.Logger.Level.ERROR, "File already exists.[{0}]", path);
            System.exit(1);
        }
        Postal postal = Postal.of();
        log.log(System.Logger.Level.INFO, "initializing...");
        postal.initialize();
        log.log(System.Logger.Level.INFO, "initialized");
        log.log(System.Logger.Level.INFO, "write csv [{0}]", path.toString());
        postal.writerCsv(path);
    }
}

