/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal;

import java.io.Serializable;
import java.util.Objects;

public class MunicipalId
implements Serializable {
    private String prefCode;
    private String municipalCode;

    private MunicipalId(String prefCode, String municipalCode) {
        Objects.requireNonNull(prefCode);
        Objects.requireNonNull(municipalCode);
        if (prefCode.length() != 2) {
            throw new IllegalArgumentException("Illegal length of prefecture code");
        }
        if (municipalCode.length() != 3) {
            throw new IllegalArgumentException("Illegal length of municipality code");
        }
        this.prefCode = prefCode;
        this.municipalCode = municipalCode;
    }

    public static MunicipalId of(String prefCode, String municipalCode) {
        return new MunicipalId(prefCode, municipalCode);
    }

    public static MunicipalId of(String code) {
        Objects.requireNonNull(code);
        if (code.length() == 5) {
            return new MunicipalId(code.substring(0, 2), code.substring(2));
        }
        if (code.length() == 6) {
            MunicipalId id = new MunicipalId(code.substring(0, 2), code.substring(2, 5));
            if (id.getCheckDigit() != Integer.parseInt(code.substring(5))) {
                throw new IllegalArgumentException("Illegal check digit");
            }
            return id;
        }
        throw new IllegalArgumentException("Illegal format");
    }

    public int getCheckDigit() {
        int a = Integer.parseInt(this.prefCode.substring(0, 1));
        int b = Integer.parseInt(this.prefCode.substring(1, 2));
        int c = Integer.parseInt(this.municipalCode.substring(0, 1));
        int d = Integer.parseInt(this.municipalCode.substring(1, 2));
        int e = Integer.parseInt(this.municipalCode.substring(2, 3));
        int sp = a * 6 + b * 5 + c * 4 + d * 3 + e * 2;
        return (11 - sp % 11) % 10;
    }

    public String getCode() {
        return this.prefCode + this.municipalCode + this.getCheckDigit();
    }

    public String getPrefCode() {
        return this.prefCode;
    }

    public String getMunicipalCode() {
        return this.municipalCode;
    }

    public String toString() {
        return "MunicipalId{prefCode='" + this.prefCode + "', municipalCode='" + this.municipalCode + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MunicipalId that = (MunicipalId)o;
        return this.prefCode.equals(that.prefCode) && this.municipalCode.equals(that.municipalCode);
    }

    public int hashCode() {
        return Objects.hash(this.prefCode, this.municipalCode);
    }
}

