/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal;

import com.mammb.code.jpostal.Address;
import com.mammb.code.jpostal.PostalCode;
import com.mammb.code.jpostal.source.AutoUpdater;
import com.mammb.code.jpostal.source.PostalSource;
import com.mammb.code.jpostal.source.PostalSourceFetcher;
import com.mammb.code.jpostal.source.PostalSourceReader;
import com.mammb.code.jpostal.source.Settings;
import com.mammb.code.jpostal.source.SourceLine;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;

public class Postal {
    private static final System.Logger log = System.getLogger(Postal.class.getName());
    private final Map<PostalCode, Collection<Address>> map = new HashMap<PostalCode, Collection<Address>>();
    private final NavigableSet<String> index = new TreeSet<String>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Settings settings;
    private final AutoUpdater autoUpdater;

    private Postal(Settings settings) {
        this.settings = settings;
        this.autoUpdater = AutoUpdater.of(this);
    }

    public static Postal of() {
        return new Postal(Settings.of());
    }

    public Postal fineAddressSupport(boolean support) {
        this.settings.fineAddressSupport(support);
        return this;
    }

    public Postal leftMatchSupport(boolean support) {
        this.settings.leftMatchSupport(support);
        return this;
    }

    public Postal officeSourceSupport(boolean support) {
        this.settings.officeSourceSupport(support);
        return this;
    }

    public Postal autoUpdateSupport(boolean support) {
        this.settings.autoUpdateSupport(support);
        return this;
    }

    public Postal leftMatchLimitCount(int count) {
        this.settings.leftMatchLimitCount(count);
        return this;
    }

    public Postal useLegacySource(boolean legacySource) {
        this.settings.useLegacySource(legacySource);
        return this;
    }

    public void initialize() {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.build(this.settings.standardSource(), true);
            this.build(this.settings.officeSource(), true);
            if (this.settings.autoUpdateSupport()) {
                this.autoUpdater.schedule();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public void initializeAll() {
        Lock writeLock = this.lock.writeLock();
        try {
            writeLock.lock();
            this.index.clear();
            this.map.clear();
            this.build(this.settings.standardSource(), false);
            this.build(this.settings.officeSource(), false);
            if (this.settings.autoUpdateSupport()) {
                this.autoUpdater.schedule();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Address> get(PostalCode code) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            Collection<Address> collection = this.map.get(code);
            return collection;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Address> get(String query) {
        Lock readLock = this.lock.readLock();
        try {
            readLock.lock();
            if (!this.settings.leftMatchSupport() || query.length() == 7) {
                Collection<Address> collection = this.get(PostalCode.of(query));
                return collection;
            }
            List<Address> list = this.leftMatch(query, this.settings.leftMatchLimitCount());
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public boolean leftMatchSupport() {
        return this.settings.leftMatchSupport();
    }

    public void writerCsv(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (Address address : this.map.values().stream().flatMap(Collection::stream).sorted(Comparator.comparing(Address::getCode)).collect(Collectors.toList())) {
                writer.write(address.getCode().getCode());
                writer.write(",");
                writer.write(address.getMunicipalId().getCode());
                writer.write(",");
                writer.write(address.getPrefecture());
                writer.write(",");
                writer.write(address.getCity());
                writer.write(",");
                writer.write(address.getTown());
                writer.write(",");
                writer.write(address.getStreet());
                writer.newLine();
            }
            writer.flush();
        }
        catch (IOException e) {
            log.log(System.Logger.Level.ERROR, "IOException", (Throwable)e);
            System.exit(1);
        }
    }

    private List<Address> leftMatch(String query, int limit) {
        String code;
        ArrayList<Address> candidates = new ArrayList<Address>();
        Iterator iterator = this.index.tailSet(query).iterator();
        while (iterator.hasNext() && (code = (String)iterator.next()).startsWith(query)) {
            candidates.addAll(this.map.get(PostalCode.of(code)));
            if (candidates.size() < limit) continue;
            return candidates.subList(0, limit);
        }
        return candidates;
    }

    private void build(PostalSource source, boolean recycleFetchedFile) {
        if (Objects.isNull(source)) {
            return;
        }
        Path path = recycleFetchedFile ? PostalSourceFetcher.recycleOf(source).fetch() : PostalSourceFetcher.of(source).fetch();
        try (PostalSourceReader reader = source.reader(path);){
            while (true) {
                SourceLine line;
                if (Objects.isNull(line = reader.readNext())) {
                    log.log(System.Logger.Level.INFO, "imported " + source + ". [" + this.map.size() + "]");
                    break;
                }
                line.getAddress().forEach(this::put);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void put(Address address) {
        PostalCode code = address.getCode();
        if (this.map.containsKey(code)) {
            this.map.get(code).add(address);
        } else {
            LinkedHashSet<Address> list = new LinkedHashSet<Address>();
            list.add(address);
            this.map.put(code, list);
        }
        if (this.settings.leftMatchSupport()) {
            this.index.add(code.getCode());
        }
    }
}

