/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal;

import java.io.Serializable;
import java.util.Objects;

public class PostalCode
implements Serializable,
Comparable<PostalCode> {
    private final String code;

    private PostalCode(String code) {
        Objects.requireNonNull(code);
        String string = this.code = code.contains("-") ? code.replace("-", "") : code;
        if (!this.code.chars().allMatch(Character::isDigit)) {
            throw new IllegalArgumentException(code);
        }
    }

    public static PostalCode of(String code) {
        return new PostalCode(code);
    }

    public String getCode() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostalCode that = (PostalCode)o;
        return this.code.equals(that.code);
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    public String toString() {
        return "PostalCode{code='" + this.code + "'}";
    }

    @Override
    public int compareTo(PostalCode other) {
        return this.code.compareTo(other.code);
    }
}

