/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.server;

import com.mammb.code.jpostal.Address;
import com.mammb.code.jpostal.Postal;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class PostalHandler
implements HttpHandler {
    private static final System.Logger log = System.getLogger(PostalHandler.class.getName());
    private final String contextRoot;
    private final Postal postal;
    private final Pattern pattern;

    PostalHandler(String contextRoot, Postal postal) {
        this.contextRoot = contextRoot;
        this.postal = postal;
        this.pattern = this.postal.leftMatchSupport() ? Pattern.compile(contextRoot + "/([0-9\\-]++)") : Pattern.compile(contextRoot + "/(\\d{7}|\\d{3}-\\d{4})");
    }

    @Override
    public void handle(HttpExchange exchange) {
        try {
            String code;
            Collection<Address> addresses;
            String path = exchange.getRequestURI().normalize().getPath();
            if (path.equals(this.contextRoot + "/console.html")) {
                this.writePage("/console.html", exchange);
                return;
            }
            StringBuilder sb = new StringBuilder();
            Matcher matcher = this.pattern.matcher(path);
            if (matcher.find() && Objects.nonNull(addresses = this.postal.get(code = matcher.group(1).replace("-", ""))) && addresses.size() > 0) {
                sb.append("[");
                for (Address address : addresses) {
                    sb.append(address.toJsonString());
                    sb.append(", ");
                }
                sb.delete(sb.length() - 2, sb.length());
                sb.append("]");
            }
            this.writeResponse(200, sb.toString(), exchange);
        }
        catch (Exception e) {
            log.log(System.Logger.Level.ERROR, e.getMessage(), (Throwable)e);
            this.writeResponse(500, "Server Error.", exchange);
        }
    }

    private void writeResponse(int rCode, String res, HttpExchange exchange) {
        byte[] bytes = res.getBytes(StandardCharsets.UTF_8);
        try (OutputStream os = exchange.getResponseBody();){
            exchange.getResponseHeaders().set("Content-Type", "application/json; charset=" + StandardCharsets.UTF_8);
            exchange.sendResponseHeaders(rCode, bytes.length);
            os.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writePage(String path, HttpExchange exchange) {
        try (InputStream is = this.getClass().getResourceAsStream(path);
             OutputStream os = exchange.getResponseBody();){
            byte[] bytes = is.readAllBytes();
            exchange.getResponseHeaders().set("Content-Type", "text/html; charset=" + StandardCharsets.UTF_8.toString());
            exchange.sendResponseHeaders(200, bytes.length);
            os.write(bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

