/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.server;

import com.mammb.code.jpostal.Postal;
import com.mammb.code.jpostal.server.PostalHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;

public class PostalServer {
    private static final System.Logger log = System.getLogger(PostalServer.class.getName());
    private final HttpServer server;

    private PostalServer(Postal postal, int port) {
        try {
            String contextRoot = "/postal";
            this.server = HttpServer.create(new InetSocketAddress(port), 0);
            this.server.createContext(contextRoot, new PostalHandler(contextRoot, postal));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PostalServer of(Postal postal) {
        return new PostalServer(postal, 8080);
    }

    public static PostalServer of(Postal postal, int port) {
        return new PostalServer(postal, port);
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        if (Objects.nonNull(this.server)) {
            this.server.stop(0);
        }
    }
}

