/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.Postal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class AutoUpdater {
    private static final System.Logger log = System.getLogger(AutoUpdater.class.getName());
    private final ScheduledExecutorService executor;
    private final Postal postal;

    private AutoUpdater(Postal postal) {
        this.postal = postal;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public static AutoUpdater of(Postal postal) {
        return new AutoUpdater(postal);
    }

    public void schedule() {
        LocalDate date = LocalDate.now().withDayOfMonth(1).plusMonths(1L);
        LocalDateTime dt = date.atStartOfDay().plusMinutes(new Random().nextInt(60));
        log.log(System.Logger.Level.INFO, "next update scheduled - " + dt);
        this.executor.schedule(this.postal::initializeAll, ChronoUnit.SECONDS.between(LocalDateTime.now(), dt), TimeUnit.SECONDS);
    }
}

