/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.Address;
import com.mammb.code.jpostal.MunicipalId;
import com.mammb.code.jpostal.PostalCode;
import com.mammb.code.jpostal.source.SourceLine;
import com.mammb.code.jpostal.source.Strings;
import java.util.List;
import java.util.Objects;

public class OfficeSourceLine
implements SourceLine {
    private String mccd;
    private String code;
    private String pref;
    private String city;
    private String town;
    private String street;

    private OfficeSourceLine(String str) {
        if (Objects.isNull(str) || str.length() == 0) {
            return;
        }
        List<String> line = Strings.split(str, ',');
        if (line.size() != 13) {
            throw new RuntimeException("Illegal format. [" + str + "]");
        }
        this.mccd = Strings.strip(line.get(0), '\"');
        this.code = Strings.strip(line.get(7), '\"');
        this.pref = Strings.strip(line.get(3), '\"');
        this.city = Strings.strip(line.get(4), '\"');
        this.town = Strings.strip(line.get(5), '\"');
        this.street = Strings.strip(line.get(6), '\"');
    }

    public static OfficeSourceLine of(String record) {
        return new OfficeSourceLine(record);
    }

    public String toString() {
        return String.join((CharSequence)",", this.mccd, this.code, this.pref, this.city, this.town, "");
    }

    @Override
    public List<Address> getAddress() {
        return List.of(Address.of(PostalCode.of(this.code), MunicipalId.of(this.mccd), this.pref, this.city, this.town, this.street));
    }
}

