/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.source.OfficeSourceLineReader;
import com.mammb.code.jpostal.source.PostalSourceReader;
import com.mammb.code.jpostal.source.StandardSourceLineReader;
import com.mammb.code.jpostal.source.StandardUtfSourceLineReader;
import com.mammb.code.jpostal.source.TownEditor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public interface PostalSource {
    public String url();

    public PostalSourceReader reader(Path var1);

    public void with(List<TownEditor> var1);

    public static PostalSource standardSource() {
        return new PostalSource(){
            private final List<TownEditor> editors = new ArrayList<TownEditor>();

            @Override
            public String url() {
                return "https://www.post.japanpost.jp/zipcode/dl/kogaki/zip/ken_all.zip";
            }

            @Override
            public PostalSourceReader reader(Path path) {
                return StandardSourceLineReader.of(path, this.editors);
            }

            @Override
            public void with(List<TownEditor> editors) {
                this.editors.addAll(editors);
            }
        };
    }

    public static PostalSource standardUtfSource() {
        return new PostalSource(){
            private final List<TownEditor> editors = new ArrayList<TownEditor>();

            @Override
            public String url() {
                return "https://www.post.japanpost.jp/zipcode/utf_all.csv";
            }

            @Override
            public PostalSourceReader reader(Path path) {
                return StandardUtfSourceLineReader.of(path, this.editors);
            }

            @Override
            public void with(List<TownEditor> editors) {
                this.editors.addAll(editors);
            }
        };
    }

    public static PostalSource officeSource() {
        return new PostalSource(){

            @Override
            public String url() {
                return "https://www.post.japanpost.jp/zipcode/dl/jigyosyo/zip/jigyosyo.zip";
            }

            @Override
            public PostalSourceReader reader(Path path) {
                return OfficeSourceLineReader.of(path);
            }

            @Override
            public void with(List<TownEditor> editors) {
            }
        };
    }
}

