/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.source.PostalSource;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class PostalSourceFetcher {
    private final Path baseDir;
    private final boolean recycle;
    private final String sourceUrl;

    private PostalSourceFetcher(Path baseDir, String sourceUrl, boolean recycle) {
        this.baseDir = baseDir;
        this.recycle = recycle;
        this.sourceUrl = sourceUrl;
    }

    public static PostalSourceFetcher of(PostalSource postalSource) {
        return new PostalSourceFetcher(Paths.get("./", new String[0]), postalSource.url(), false);
    }

    public static PostalSourceFetcher recycleOf(PostalSource postalSource) {
        return new PostalSourceFetcher(Paths.get("./", new String[0]), postalSource.url(), true);
    }

    public Path fetch() {
        Path path = this.baseDir.resolve(PostalSourceFetcher.fetchedPath(this.sourceUrl));
        if (!this.recycle || !Files.exists(path, new LinkOption[0])) {
            path = PostalSourceFetcher.fetch(this.sourceUrl, path);
        }
        return path.endsWith(".zip") ? PostalSourceFetcher.unzip(path) : path;
    }

    private static Path fetchedPath(String url) {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        return Paths.get(fileName, new String[0]);
    }

    private static Path fetch(String url, Path toPath) {
        try (ReadableByteChannel rbc = Channels.newChannel(new URL(url).openStream());
             FileOutputStream os = new FileOutputStream(toPath.toFile());){
            os.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return toPath;
    }

    private static Path unzip(Path zipPath) {
        try {
            Path tempDir = Files.createTempDirectory(PostalSource.class.getSimpleName() + ".", new FileAttribute[0]);
            PostalSourceFetcher.unzip(zipPath, tempDir, StandardCharsets.UTF_8);
            return Files.list(tempDir).filter(p -> p.getFileName().toString().toLowerCase().endsWith(".csv")).findFirst().orElseThrow();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void unzip(Path zipPath, Path unzipLocation, Charset charset) throws IOException {
        if (!Files.exists(unzipLocation, new LinkOption[0])) {
            Files.createDirectories(unzipLocation, new FileAttribute[0]);
        }
        try (ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(zipPath, new OpenOption[0]), charset);){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                Path filePath = unzipLocation.resolve(entry.getName());
                if (!entry.isDirectory()) {
                    PostalSourceFetcher.unzipFiles(zipInputStream, filePath);
                } else {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
    }

    private static void unzipFiles(ZipInputStream zipInputStream, Path unzipFilePath) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(Paths.get(unzipFilePath.toAbsolutePath().toString(), new String[0]), new OpenOption[0]));){
            int read;
            byte[] bytesIn = new byte[5120];
            while ((read = zipInputStream.read(bytesIn)) != -1) {
                bos.write(bytesIn, 0, read);
            }
        }
    }
}

