/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.source.SourceLine;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public abstract class PostalSourceReader
implements Closeable {
    private final BufferedReader bufferedReader;

    protected PostalSourceReader(Path path, Charset charset) {
        Objects.requireNonNull(path);
        try {
            this.bufferedReader = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), charset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract SourceLine readNext();

    protected String readLine() {
        try {
            return this.bufferedReader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.bufferedReader.close();
    }
}

