/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.source.PostalSource;
import com.mammb.code.jpostal.source.TownEditor;

public class Settings {
    private boolean leftMatchSupport = true;
    private boolean officeSourceSupport = false;
    private boolean autoUpdateSupport = false;
    private boolean fineAddressSupport = true;
    private int leftMatchLimitCount = 20;
    private boolean useLegacySource = false;

    public static Settings of() {
        return new Settings();
    }

    public void useLegacySource(boolean legacy) {
        this.useLegacySource = legacy;
    }

    public void leftMatchSupport(boolean support) {
        this.leftMatchSupport = support;
    }

    public void fineAddressSupport(boolean support) {
        this.fineAddressSupport = support;
    }

    public void autoUpdateSupport(boolean support) {
        this.autoUpdateSupport = support;
    }

    public void officeSourceSupport(boolean support) {
        this.officeSourceSupport = support;
    }

    public void leftMatchLimitCount(int count) {
        this.leftMatchLimitCount = count;
    }

    public PostalSource standardSource() {
        PostalSource postalSource = this.useLegacySource ? PostalSource.standardSource() : PostalSource.standardUtfSource();
        postalSource.with(this.fineAddressSupport ? TownEditor.standardEditors() : TownEditor.simpleEditors());
        return postalSource;
    }

    public PostalSource officeSource() {
        return this.officeSourceSupport ? PostalSource.officeSource() : null;
    }

    public boolean leftMatchSupport() {
        return this.leftMatchSupport;
    }

    public boolean autoUpdateSupport() {
        return this.autoUpdateSupport;
    }

    public int leftMatchLimitCount() {
        return this.leftMatchLimitCount;
    }
}

