/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.Address;
import com.mammb.code.jpostal.MunicipalId;
import com.mammb.code.jpostal.PostalCode;
import com.mammb.code.jpostal.source.SourceLine;
import com.mammb.code.jpostal.source.Strings;
import java.util.List;
import java.util.Objects;

class StandardSourceLine
implements SourceLine {
    String mccd;
    String code;
    String pref;
    String city;
    String town;
    private int openCount;
    private int closeCount;

    private StandardSourceLine(String str) {
        if (Objects.isNull(str) || str.length() == 0) {
            return;
        }
        List<String> line = Strings.split(str, ',');
        if (line.size() != 15) {
            throw new RuntimeException("Illegal format. [" + str + "]");
        }
        this.mccd = line.get(0);
        this.code = Strings.strip(line.get(2), '\"');
        this.pref = Strings.strip(line.get(6), '\"');
        this.city = Strings.strip(line.get(7), '\"');
        this.town = Strings.strip(line.get(8), '\"');
        this.openCount = Strings.countMatches(this.town, '\uff08');
        this.closeCount = Strings.countMatches(this.town, '\uff09');
    }

    public static StandardSourceLine of(String record) {
        return new StandardSourceLine(record);
    }

    public boolean canMarge(StandardSourceLine that) {
        return this.code.equals(that.code) && this.pref.equals(that.pref) && this.city.equals(that.city) && this.openCount > this.closeCount;
    }

    public StandardSourceLine marge(StandardSourceLine that) {
        if (!this.town.equals(that.town)) {
            this.town = this.town + that.town;
        }
        this.openCount += that.openCount;
        this.closeCount += that.closeCount;
        return this;
    }

    @Override
    public List<Address> getAddress() {
        return List.of(Address.of(PostalCode.of(this.code), MunicipalId.of(this.mccd), this.pref, this.city, this.town, ""));
    }
}

