/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.Address;
import com.mammb.code.jpostal.MunicipalId;
import com.mammb.code.jpostal.PostalCode;
import com.mammb.code.jpostal.source.SourceLine;
import com.mammb.code.jpostal.source.StandardSourceLine;
import com.mammb.code.jpostal.source.TownEditor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class StandardSourceLineEditor
implements SourceLine {
    private static final System.Logger log = System.getLogger(StandardSourceLineEditor.class.getName());
    private final StandardSourceLine peer;
    private final List<TownEditor> rules;

    private StandardSourceLineEditor(StandardSourceLine peer, List<TownEditor> rules) {
        this.peer = peer;
        this.rules = rules;
    }

    public static StandardSourceLineEditor of(StandardSourceLine origin, List<TownEditor> rules) {
        return new StandardSourceLineEditor(origin, rules);
    }

    private List<String> towns() {
        return this.towns(this.rules.iterator(), Collections.singletonList(this.peer.town));
    }

    private List<String> towns(Iterator<TownEditor> iterator, List<String> list) {
        if (iterator.hasNext()) {
            TownEditor editor = iterator.next();
            List<String> edited = list.stream().map(town -> editor.apply((String)town, this.peer)).flatMap(Collection::stream).collect(Collectors.toList());
            if (edited.isEmpty()) {
                return edited;
            }
            return this.towns(iterator, edited);
        }
        return list;
    }

    @Override
    public List<Address> getAddress() {
        ArrayList<Address> list = new ArrayList<Address>();
        for (String town : this.towns()) {
            if (town.contains("\uff08") && town.contains("\uff09")) {
                list.add(Address.of(PostalCode.of(this.peer.code), MunicipalId.of(this.peer.mccd), this.peer.pref, this.peer.city, town.substring(0, town.indexOf(65288)), town.substring(town.indexOf(65288) + 1, town.indexOf(65289))));
                continue;
            }
            list.add(Address.of(PostalCode.of(this.peer.code), MunicipalId.of(this.peer.mccd), this.peer.pref, this.peer.city, town, ""));
        }
        return list;
    }
}

