/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.source.PostalSourceReader;
import com.mammb.code.jpostal.source.SourceLine;
import com.mammb.code.jpostal.source.StandardSourceLine;
import com.mammb.code.jpostal.source.StandardSourceLineEditor;
import com.mammb.code.jpostal.source.TownEditor;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class StandardSourceLineReader
extends PostalSourceReader {
    private StandardSourceLine buffered = null;
    private final List<TownEditor> editors;

    private StandardSourceLineReader(Path path, List<TownEditor> editors) {
        super(Objects.requireNonNull(path), Charset.forName("Shift_JIS"));
        this.editors = Objects.isNull(editors) || editors.isEmpty() ? TownEditor.standardEditors() : editors;
    }

    public static StandardSourceLineReader of(Path path, List<TownEditor> editors) {
        return new StandardSourceLineReader(path, editors);
    }

    public static StandardSourceLineReader of(Path path) {
        return new StandardSourceLineReader(path, null);
    }

    @Override
    public SourceLine readNext() {
        StandardSourceLine current;
        while (true) {
            String line;
            if (Objects.isNull(line = this.readLine())) {
                StandardSourceLine ret = this.buffered;
                this.buffered = null;
                return Objects.nonNull(ret) ? StandardSourceLineEditor.of(ret, this.editors) : null;
            }
            current = StandardSourceLine.of(line);
            if (Objects.isNull(this.buffered)) {
                this.buffered = current;
                continue;
            }
            if (!this.buffered.canMarge(current)) break;
            this.buffered.marge(current);
        }
        StandardSourceLine ret = this.buffered;
        this.buffered = current;
        return StandardSourceLineEditor.of(ret, this.editors);
    }
}

