/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.source.PostalSourceReader;
import com.mammb.code.jpostal.source.SourceLine;
import com.mammb.code.jpostal.source.StandardSourceLine;
import com.mammb.code.jpostal.source.StandardSourceLineEditor;
import com.mammb.code.jpostal.source.TownEditor;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public class StandardUtfSourceLineReader
extends PostalSourceReader {
    private final List<TownEditor> editors;

    private StandardUtfSourceLineReader(Path path, List<TownEditor> editors) {
        super(Objects.requireNonNull(path), StandardCharsets.UTF_8);
        this.editors = Objects.isNull(editors) || editors.isEmpty() ? TownEditor.standardEditors() : editors;
    }

    public static StandardUtfSourceLineReader of(Path path, List<TownEditor> editors) {
        return new StandardUtfSourceLineReader(path, editors);
    }

    public static StandardUtfSourceLineReader of(Path path) {
        return new StandardUtfSourceLineReader(path, null);
    }

    @Override
    public SourceLine readNext() {
        String line = this.readLine();
        return Objects.isNull(line) ? null : StandardSourceLineEditor.of(StandardSourceLine.of(line), this.editors);
    }
}

