/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class Strings {
    private Strings() {
    }

    public static String strip(String str, char separatorChar) {
        if (Strings.isEmpty(str)) {
            return str;
        }
        if (str.charAt(0) == separatorChar && str.charAt(str.length() - 1) == separatorChar) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    public static List<String> split(String str, char separatorChar) {
        if (Strings.isEmpty(str)) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        int len = str.length();
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list;
    }

    public static int countMatches(String str, char ch) {
        if (Strings.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (ch != str.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isEmpty(String str) {
        return Objects.isNull(str) || str.isEmpty();
    }
}

