/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.jpostal.source;

import com.mammb.code.jpostal.source.StandardSourceLine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public interface TownEditor {
    public static final List<String> empty = List.of("");

    public List<String> apply(String var1, StandardSourceLine var2);

    public static List<TownEditor> standardEditors() {
        return Arrays.asList((town, org) -> town.contains("\u4ee5\u4e0b\u306b\u63b2\u8f09\u304c\u306a\u3044\u5834\u5408") ? empty : TownEditor.keep(town), (town, org) -> town.contains("\u306e\u6b21\u306b\u756a\u5730\u304c\u304f\u308b\u5834\u5408") ? empty : TownEditor.keep(town), (town, org) -> TownEditor.endsWithExact(town, "\u4e00\u5186", org.city) ? empty : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u5168\u57df\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.contains("\uff08\u9ad8\u5c64\u68df\uff09") ? TownEditor.remove(town, "\uff08\u9ad8\u5c64\u68df\uff09") : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u5730\u968e\u30fb\u968e\u5c64\u4e0d\u660e\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u6b21\u306e\u30d3\u30eb\u3092\u9664\u304f\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.matches(".*\uff08[\uff10-\uff19]+\u968e\uff09") ? TownEditor.extractParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u4e01\u76ee\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u5404\u753a\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u756a\u5730\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u7121\u756a\u5730\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\uff08\u305d\u306e\u4ed6\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u3092\u9664\u304f\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u4ee5\u4e0b\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u4ee5\u5185\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u4ee5\u964d\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u4ee5\u5916\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u25cb\u25cb\u5c4b\u6577\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> TownEditor.split(town), (town, org) -> town.endsWith("\u3092\u542b\u3080\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u305d\u306e\u4ed6\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u4ee5\u4e0a\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.endsWith("\u300d\u4ee5\u5916\uff09") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.contains("\u756a\u5730\u4ee5\u4e0a") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.contains("\u300c") && town.contains("\u300d") ? TownEditor.removeSqBrackets(town) : TownEditor.keep(town), (town, org) -> town.matches(".*\uff08.*\u30fb.*\uff09.*") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.matches(".*\uff08.*\u301c.*\uff09.*") ? TownEditor.removeParen(town) : TownEditor.keep(town), (town, org) -> town.matches(".*\u7b2c.*\u5730\u5272\u301c\u7b2c.*\u5730\u5272.*") ? List.of(town.replaceAll("\u7b2c.*\u5730\u5272\u301c\u7b2c.*\u5730\u5272", "")) : TownEditor.keep(town), (town, org) -> town.matches(".*\u5730\u5272\u301c.*\u5730\u5272.*") ? List.of(town.replaceAll("[\uff10-\uff19]+\u5730\u5272\u301c.*", "")) : TownEditor.keep(town), (town, org) -> town.contains("\u5730\u5272\u3001") ? Arrays.asList(town.split("\u3001")) : TownEditor.keep(town), (town, org) -> town.startsWith("\u7532\u3001\u4e59") ? Arrays.asList(town.split("\u3001")) : TownEditor.keep(town));
    }

    public static List<TownEditor> simpleEditors() {
        return Arrays.asList((town, org) -> town.contains("\u4ee5\u4e0b\u306b\u63b2\u8f09\u304c\u306a\u3044\u5834\u5408") ? empty : TownEditor.keep(town), (town, org) -> town.contains("\u306e\u6b21\u306b\u756a\u5730\u304c\u304f\u308b\u5834\u5408") ? empty : TownEditor.keep(town), (town, org) -> TownEditor.endsWithExact(town, "\u4e00\u5186", org.city) ? empty : TownEditor.keep(town), (town, org) -> town.matches(".*\uff08[\uff10-\uff19]+\u968e\uff09") ? TownEditor.extractParen(town) : TownEditor.keep(town), (town, org) -> town.matches(".*\u7b2c.*\u5730\u5272\u301c\u7b2c.*\u5730\u5272.*") ? List.of(town.replaceAll("\u7b2c.*\u5730\u5272\u301c\u7b2c.*\u5730\u5272", "")) : TownEditor.keep(town), (town, org) -> town.matches(".*\u5730\u5272\u301c.*\u5730\u5272.*") ? List.of(town.replaceAll("[\uff10-\uff19]+\u5730\u5272\u301c.*", "")) : TownEditor.keep(town), (town, org) -> town.contains("\u5730\u5272\u3001") ? Arrays.asList(town.split("\u3001")) : TownEditor.keep(town), (town, org) -> town.startsWith("\u7532\u3001\u4e59") ? Arrays.asList(town.split("\u3001")) : TownEditor.keep(town), (town, org) -> TownEditor.hasParen(town) ? TownEditor.removeParen(town) : TownEditor.keep(town));
    }

    private static List<String> keep(String input) {
        return Collections.singletonList(input);
    }

    private static List<String> split(String input) {
        if (!TownEditor.hasParen(input)) {
            return List.of(input);
        }
        String content = input.substring(input.indexOf(65288));
        if (!content.contains("\u3001")) {
            return List.of(input);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String str : TownEditor.splitExcludeSqBrackets(content)) {
            String prefix1 = input.substring(0, input.indexOf(65288));
            String prefix2 = str.startsWith("\uff08") ? "" : "\uff08";
            String suffix1 = input.endsWith("\u756a\u5730\uff09") && str.matches(".*[\uff10-\uff19]$") ? "\u756a\u5730" : "";
            suffix1 = input.endsWith("\u4e01\u76ee\uff09") && str.matches(".*[\uff10-\uff19]$") ? "\u4e01\u76ee" : suffix1;
            String suffix2 = str.endsWith("\uff09") ? "" : "\uff09";
            list.add(prefix1 + prefix2 + str + suffix1 + suffix2);
        }
        return list;
    }

    private static boolean hasParen(String input) {
        return input.contains("\uff08") && input.contains("\uff09");
    }

    private static boolean endsWithExact(String input, String str, String parent) {
        return input.endsWith(str) && !input.equals(str) && parent.endsWith(input.replace(str, ""));
    }

    private static List<String> extractParen(String input) {
        return List.of(input.replace("\uff08", "").replace("\uff09", ""));
    }

    private static List<String> removeSqBrackets(String input) {
        return List.of(input.replaceFirst("\u300c.*\u300d", ""));
    }

    private static List<String> removeParen(String input) {
        return List.of(input.substring(0, input.lastIndexOf("\uff08")));
    }

    private static List<String> remove(String input, String str) {
        return List.of(input.replace(str, ""));
    }

    private static List<String> splitExcludeSqBrackets(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        int len = str.length();
        boolean match = false;
        boolean inSqb = false;
        while (i < len) {
            char chr = str.charAt(i);
            if (chr == '\u300c') {
                inSqb = true;
            } else if (inSqb && chr == '\u300d') {
                inSqb = false;
            }
            if (!inSqb && chr == '\u3001') {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list;
    }
}

