/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable;

import com.mammb.code.piecetable.Document;
import com.mammb.code.piecetable.Found;
import com.mammb.code.piecetable.edit.TextEditImpl;
import com.mammb.code.piecetable.text.DocumentImpl;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public interface TextEdit {
    public void insert(int var1, int var2, String var3);

    public String delete(int var1, int var2, int var3);

    public String backspace(int var1, int var2, int var3);

    public String replace(int var1, int var2, int var3, String var4);

    public String getText(int var1);

    public List<Pos> undo();

    public List<Pos> redo();

    public void flush();

    public void clear();

    public List<Found> findAll(String var1);

    public Optional<Found> findNext(String var1, int var2, int var3);

    public int rows();

    public long rawSize();

    public Charset charset();

    public Path path();

    public void save(Path var1);

    public static TextEdit of() {
        return new TextEditImpl(Document.of());
    }

    public static TextEdit of(Path path) {
        return new TextEditImpl(DocumentImpl.of(path));
    }

    public static TextEdit of(Document document) {
        return new TextEditImpl(document);
    }

    public record Pos(int row, int col) {
    }
}

