/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.core;

import com.mammb.code.piecetable.core.Buffer;
import com.mammb.code.piecetable.core.ByteArray;

public interface AppendBuffer
extends Buffer {
    public void append(byte[] var1);

    public void clear();

    public static AppendBuffer of() {
        return new AppendBuffer(){
            private final ByteArray elements = ByteArray.of();

            @Override
            public void append(byte[] bytes) {
                this.elements.add(bytes);
            }

            @Override
            public void clear() {
                this.elements.clear();
            }

            @Override
            public byte get(long index) {
                return this.elements.get(Math.toIntExact(index));
            }

            @Override
            public byte[] bytes(long rawStart, long rawEnd) {
                return this.elements.get(Math.toIntExact(rawStart), Math.toIntExact(rawEnd));
            }

            @Override
            public long length() {
                return this.elements.length();
            }
        };
    }
}

