/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;

public interface Buffer {
    public byte get(long var1);

    public byte[] bytes(long var1, long var3);

    public long length();

    default public boolean isEmpty() {
        return this.length() == 0L;
    }

    default public long write(WritableByteChannel channel, ByteBuffer buf, long offset, long length) throws IOException {
        int n;
        long from = offset;
        long to = offset + length;
        for (long i = from; i < to; i += (long)n) {
            long m = Math.min(i + (long)buf.remaining(), to);
            buf.put(this.bytes(i, m));
            buf.flip();
            n = channel.write(buf);
            buf.compact();
            if (n > 0) continue;
            break;
        }
        return to - from;
    }

    public static Buffer of(final byte[] bytes) {
        return new Buffer(){
            private final byte[] elements;
            {
                this.elements = bytes;
            }

            @Override
            public byte get(long index) {
                return this.elements[Math.toIntExact(index)];
            }

            @Override
            public byte[] bytes(long startIndex, long endIndex) {
                return Arrays.copyOfRange(this.elements, Math.toIntExact(startIndex), Math.toIntExact(endIndex));
            }

            @Override
            public long length() {
                return this.elements.length;
            }
        };
    }
}

