/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.core;

import java.io.Serializable;
import java.util.Arrays;

public class ByteArray
implements Serializable {
    private static final byte[] EMPTY = new byte[0];
    private byte[] bytes;
    private int length;

    private ByteArray(byte[] bytes, int length) {
        this.bytes = bytes;
        this.length = length;
    }

    public static ByteArray of() {
        return new ByteArray(EMPTY, 0);
    }

    public static ByteArray of(byte[] bytes) {
        return new ByteArray(Arrays.copyOf(bytes, bytes.length), bytes.length);
    }

    public void add(byte value) {
        if (this.length == this.bytes.length) {
            this.bytes = this.grow(this.length + 1);
        }
        this.bytes[this.length++] = value;
    }

    public void add(byte[] values) {
        if (this.length + values.length > this.bytes.length) {
            this.bytes = this.grow(this.length + values.length);
        }
        System.arraycopy(values, 0, this.bytes, this.length, values.length);
        this.length += values.length;
    }

    public byte get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index[%d], length[%d]".formatted(index, this.length));
        }
        return this.bytes[index];
    }

    public byte[] get() {
        return Arrays.copyOf(this.bytes, this.length);
    }

    public byte[] get(int from, int to) {
        if (from < 0 || to > this.length || from > to) {
            throw new IndexOutOfBoundsException("from[%d], to[%d], length[%d]".formatted(from, to, this.length));
        }
        return Arrays.copyOfRange(this.bytes, from, to);
    }

    public void clear() {
        this.bytes = EMPTY;
        this.length = 0;
    }

    public int length() {
        return this.length;
    }

    public int capacity() {
        return this.bytes.length;
    }

    private byte[] grow(int minCapacity) {
        int oldCapacity = this.bytes.length;
        if (this.length == 0 || this.bytes == EMPTY) {
            this.bytes = new byte[Math.max(10, minCapacity)];
            return this.bytes;
        }
        this.bytes = Arrays.copyOf(this.bytes, ByteArray.newCapacity(oldCapacity, minCapacity - oldCapacity, Math.min(512, oldCapacity >> 1)));
        return this.bytes;
    }

    public static int newCapacity(int oldLength, int minGrowth, int prefGrowth) {
        int softMaxArrayLength = 0x7FFFFFF7;
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= softMaxArrayLength) {
            return prefLength;
        }
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length %d %d is too large".formatted(oldLength, minGrowth));
        }
        return Math.max(minLength, softMaxArrayLength);
    }
}

