/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.core;

import com.mammb.code.piecetable.core.Buffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public record Piece(Buffer target, long bufIndex, long length) {
    public long end() {
        return this.bufIndex + this.length;
    }

    public Piece[] split(long offset) {
        if (offset < 0L || offset > this.length) {
            throw new RuntimeException("Illegal offset value. offset[%s], length[%s]".formatted(offset, this.length));
        }
        if (offset == 0L || offset == this.length) {
            return new Piece[]{this};
        }
        return new Piece[]{new Piece(this.target, this.bufIndex, offset), new Piece(this.target, this.bufIndex + offset, this.length - offset)};
    }

    public byte[] bytes(long offset, int len) {
        if (offset < 0L || offset + (long)len > this.length) {
            throw new RuntimeException("Illegal index. offset[%s], len[%s]".formatted(offset, len));
        }
        return this.target.bytes(this.bufIndex + offset, this.bufIndex + offset + (long)len);
    }

    public byte[] bytes() {
        return this.target.bytes(this.bufIndex, this.bufIndex + this.length);
    }

    long writeTo(WritableByteChannel channel, ByteBuffer buf) throws IOException {
        return this.target.write(channel, buf, this.bufIndex, this.length);
    }
}

