/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.edit;

import com.mammb.code.piecetable.Document;
import com.mammb.code.piecetable.Found;
import com.mammb.code.piecetable.TextEdit;
import com.mammb.code.piecetable.edit.Edit;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class TextEditImpl
implements TextEdit {
    private final Deque<Edit> deque = new ArrayDeque<Edit>();
    private final Deque<Edit> undo = new ArrayDeque<Edit>();
    private final Deque<Edit> redo = new ArrayDeque<Edit>();
    private final Map<Integer, String> dryBuffer = new HashMap<Integer, String>();
    private final Document doc;

    public TextEditImpl(Document doc) {
        this.doc = doc;
    }

    @Override
    public void insert(int row, int col, String text) {
        this.push(this.insertEdit(row, col, text, System.currentTimeMillis()));
    }

    @Override
    public String delete(int row, int col, int len) {
        Edit.Del e = this.deleteEdit(row, col, len, System.currentTimeMillis());
        this.push(e);
        return e.text();
    }

    @Override
    public String backspace(int row, int col, int len) {
        Edit.Del e = this.backspaceEdit(row, col, len, System.currentTimeMillis());
        this.push(e);
        return e.text();
    }

    @Override
    public String replace(int row, int col, int len, String text) {
        Record e;
        long occurredOn = System.currentTimeMillis();
        String ret = "";
        if (len == 0) {
            e = this.insertEdit(row, col, text, occurredOn);
        } else if (len > 0) {
            Edit.Del del = this.deleteEdit(row, col, len, occurredOn);
            e = new Edit.Cmp(List.of(del, this.insertEdit(row, col, text, occurredOn)), occurredOn);
            ret = del.text();
        } else {
            Edit.Del bs = this.backspaceEdit(row, col, -len, occurredOn);
            e = new Edit.Cmp(List.of(bs, this.insertEdit(bs.to().row(), bs.to().col(), text, occurredOn)), occurredOn);
            ret = bs.text();
        }
        this.push((Edit)((Object)e));
        return ret;
    }

    @Override
    public String getText(int row) {
        if (!this.deque.isEmpty() && this.dryBuffer.isEmpty()) {
            this.dryApply();
        }
        if (this.dryBuffer.containsKey(row)) {
            return this.dryBuffer.get(row);
        }
        return this.doc.getText(row).toString();
    }

    @Override
    public List<TextEdit.Pos> undo() {
        this.flush();
        Optional<Edit> undo = this.undoEdit();
        if (undo.isEmpty()) {
            return List.of();
        }
        Edit edit = undo.get();
        Objects.requireNonNull(edit);
        Edit edit2 = edit;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.ConcreteEdit.class, Edit.Cmp.class}, (Object)edit2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Edit.ConcreteEdit e = (Edit.ConcreteEdit)edit2;
                yield List.of(e.to());
            }
            case 1 -> {
                Edit.Cmp e = (Edit.Cmp)edit2;
                yield e.edits().stream().map(Edit.ConcreteEdit::to).toList();
            }
        };
    }

    @Override
    public List<TextEdit.Pos> redo() {
        this.flush();
        Optional<Edit> redo = this.redoEdit();
        if (redo.isEmpty()) {
            return List.of();
        }
        Edit edit = redo.get();
        Objects.requireNonNull(edit);
        Edit edit2 = edit;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.ConcreteEdit.class, Edit.Cmp.class}, (Object)edit2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Edit.ConcreteEdit e = (Edit.ConcreteEdit)edit2;
                yield List.of(e.to());
            }
            case 1 -> {
                Edit.Cmp e = (Edit.Cmp)edit2;
                yield e.edits().stream().map(Edit.ConcreteEdit::to).toList();
            }
        };
    }

    @Override
    public void flush() {
        while (!this.deque.isEmpty()) {
            Edit edit = this.deque.pop();
            this.apply(edit);
            this.undo.push(edit.flip());
            this.redo.clear();
        }
        this.dryBuffer.clear();
    }

    @Override
    public void clear() {
        this.flush();
        this.undo.clear();
        this.redo.clear();
    }

    @Override
    public List<Found> findAll(String text) {
        this.flush();
        return this.doc.findAll(text);
    }

    @Override
    public Optional<Found> findNext(String text, int row, int col) {
        this.flush();
        return this.doc.findNext(text, row, col);
    }

    @Override
    public int rows() {
        return this.doc.rows();
    }

    @Override
    public long rawSize() {
        this.flush();
        return this.doc.rawSize();
    }

    @Override
    public Charset charset() {
        return this.doc.charset();
    }

    @Override
    public Path path() {
        return this.doc.path();
    }

    @Override
    public void save(Path path) {
        this.flush();
        this.doc.save(path);
    }

    Edit.Ins insertEdit(int row, int col, String text, long occurredOn) {
        int index = text.lastIndexOf(10);
        if (index < 0) {
            return new Edit.Ins(new TextEdit.Pos(row, col), new TextEdit.Pos(row, col + text.length()), text, occurredOn);
        }
        int nRow = row + (int)text.chars().mapToLong(c -> c == 10 ? 1L : 0L).sum();
        int nCol = text.substring(index + 1).length();
        return new Edit.Ins(new TextEdit.Pos(row, col), new TextEdit.Pos(nRow, nCol), text, occurredOn);
    }

    Edit.Del deleteEdit(int row, int col, int len, long occurredOn) {
        String rowText = this.getText(row);
        if (rowText.length() > col + len) {
            return new Edit.Del(new TextEdit.Pos(row, col), new TextEdit.Pos(row, col), rowText.substring(col, col + len), occurredOn);
        }
        StringBuilder sb = new StringBuilder(rowText.substring(col));
        len -= sb.length();
        for (int nRow = row + 1; nRow < this.doc.rows(); ++nRow) {
            rowText = this.getText(nRow);
            if (len - rowText.length() <= 0) {
                sb.append(rowText, 0, len);
                break;
            }
            len -= rowText.length();
            sb.append(rowText);
        }
        return new Edit.Del(new TextEdit.Pos(row, col), new TextEdit.Pos(row, col), sb.toString(), occurredOn);
    }

    Edit.Del backspaceEdit(int row, int col, int len, long occurredOn) {
        String rowText = this.getText(row);
        if (col - len >= 0) {
            return new Edit.Del(new TextEdit.Pos(row, col), new TextEdit.Pos(row, col - len), rowText.substring(col - len, col), occurredOn);
        }
        StringBuilder sb = new StringBuilder(rowText.substring(0, col));
        int nRow = row - 1;
        len -= col;
        while (true) {
            if (len - (rowText = this.getText(nRow)).length() <= 0) break;
            len -= rowText.length();
            --nRow;
            sb.insert(0, rowText);
        }
        int nCol = rowText.length() - len;
        sb.insert(0, rowText.substring(nCol));
        return new Edit.Del(new TextEdit.Pos(row, col), new TextEdit.Pos(nRow, nCol), sb.toString(), occurredOn);
    }

    private void push(Edit edit) {
        Optional<Edit> merged;
        Edit last = this.deque.peekLast();
        if (last != null && (merged = last.merge(edit)).isPresent()) {
            this.deque.removeLast();
            this.flush();
            this.deque.push(merged.get());
            return;
        }
        this.flush();
        this.deque.push(edit);
        Edit edit2 = edit;
        Objects.requireNonNull(edit2);
        Edit edit3 = edit2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.ConcreteEdit.class, Edit.Cmp.class}, (Object)edit3, n)) {
                case 0: {
                    Edit.ConcreteEdit e = (Edit.ConcreteEdit)edit3;
                    if (!e.text().contains("\n")) {
                        n = 1;
                        continue block4;
                    }
                    this.flush();
                    break block4;
                }
                case 1: {
                    Edit.Cmp e = (Edit.Cmp)edit3;
                    if (!e.edits().stream().map(Edit.ConcreteEdit::text).anyMatch(s -> s.contains("\n"))) {
                        n = 2;
                        continue block4;
                    }
                    this.flush();
                    break block4;
                }
            }
            break;
        }
    }

    private Optional<Edit> undoEdit() {
        this.flush();
        if (this.undo.isEmpty()) {
            return Optional.empty();
        }
        Edit edit = this.undo.pop();
        this.apply(edit);
        this.redo.push(edit.flip());
        return Optional.of(edit);
    }

    private Optional<Edit> redoEdit() {
        this.flush();
        if (this.redo.isEmpty()) {
            return Optional.empty();
        }
        Edit edit = this.redo.pop();
        this.apply(edit);
        this.undo.push(edit.flip());
        return Optional.of(edit);
    }

    private void apply(Edit edit) {
        Edit edit2 = edit;
        Objects.requireNonNull(edit2);
        Edit edit3 = edit2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.Ins.class, Edit.Del.class, Edit.Cmp.class}, (Object)edit3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Edit.Ins e = (Edit.Ins)edit3;
                this.doc.insert(e.min().row(), e.min().col(), e.text());
                break;
            }
            case 1: {
                Edit.Del e = (Edit.Del)edit3;
                this.doc.delete(e.min().row(), e.min().col(), e.text());
                break;
            }
            case 2: {
                Edit.Cmp e = (Edit.Cmp)edit3;
                e.edits().forEach(this::apply);
            }
        }
    }

    private void dryApply() {
        this.dryBuffer.clear();
        this.deque.forEach(this::dryApply);
    }

    private void dryApply(Edit edit) {
        Edit edit2 = edit;
        Objects.requireNonNull(edit2);
        Edit edit3 = edit2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.Ins.class, Edit.Del.class, Edit.Cmp.class}, (Object)edit3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Edit.Ins e = (Edit.Ins)edit3;
                Object row = this.dryBuffer.get(e.from().row());
                if (row == null) {
                    row = this.doc.getText(e.from().row()).toString();
                }
                row = ((String)row).substring(0, e.min().col()) + e.text() + ((String)row).substring(e.min().col());
                this.dryBuffer.put(e.from().row(), (String)row);
                break;
            }
            case 1: {
                Edit.Del e = (Edit.Del)edit3;
                Object row = this.dryBuffer.get(e.from().row());
                if (row == null) {
                    row = this.doc.getText(e.from().row()).toString();
                }
                row = ((String)row).substring(0, e.min().col()) + ((String)row).substring(e.min().col() + e.text().length());
                this.dryBuffer.put(e.from().row(), (String)row);
                break;
            }
            case 2: {
                Edit.Cmp e = (Edit.Cmp)edit3;
                e.edits().forEach(this::dryApply);
            }
        }
    }

    Document getDoc() {
        return this.doc;
    }

    Map<Integer, String> getDryBuffer() {
        return this.dryBuffer;
    }

    Deque<Edit> getDeque() {
        return this.deque;
    }

    Deque<Edit> getUndo() {
        return this.undo;
    }

    Deque<Edit> getRedo() {
        return this.redo;
    }

    void testPush(Edit edit) {
        this.push(edit);
    }

    void testDryApply() {
        this.dryApply();
    }

    void testDryApply(Edit edit) {
        this.dryApply(edit);
    }
}

