/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.text;

import com.mammb.code.piecetable.CharsetMatch;
import com.mammb.code.piecetable.Document;
import com.mammb.code.piecetable.Found;
import com.mammb.code.piecetable.PieceTable;
import com.mammb.code.piecetable.text.Reader;
import com.mammb.code.piecetable.text.RowIndex;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class DocumentImpl
implements Document {
    private PieceTable pt;
    private Path path;
    private Charset charset;
    private RowIndex index;
    private byte[] bom;

    DocumentImpl(PieceTable pt, Path path, Reader reader) {
        this.pt = pt;
        this.path = path;
        if (reader == null) {
            this.index = RowIndex.of();
            this.charset = StandardCharsets.UTF_8;
            this.bom = new byte[0];
        } else {
            this.index = reader.index();
            this.charset = reader.charset();
            this.bom = reader.bom();
        }
    }

    public static DocumentImpl of() {
        return new DocumentImpl(PieceTable.of(), null, null);
    }

    public static DocumentImpl of(Path path) {
        return new DocumentImpl(PieceTable.of(path), path, Reader.of(path));
    }

    public static DocumentImpl of(Path path, Charset charset) {
        return new DocumentImpl(PieceTable.of(path), path, Reader.of(path, charset));
    }

    public static DocumentImpl of(Path path, CharsetMatch ... charsetMatches) {
        return new DocumentImpl(PieceTable.of(path), path, Reader.of(path, charsetMatches));
    }

    @Override
    public void insert(int row, int col, CharSequence cs) {
        col = this.getText(row).toString().substring(0, col).getBytes(this.charset).length;
        this.insert(row, col, cs.toString().getBytes(this.charset));
    }

    @Override
    public void delete(int row, int col, CharSequence cs) {
        col = this.getText(row).toString().substring(0, col).getBytes(this.charset).length;
        this.delete(row, col, cs.toString().getBytes(this.charset).length);
    }

    @Override
    public CharSequence getText(int row) {
        return new String(this.get(row), this.charset);
    }

    @Override
    public void insert(int row, int rawCol, byte[] bytes) {
        this.pt.insert(this.index.get(row) + (long)(rawCol += row == 0 ? this.bom.length : 0), bytes);
        this.index.insert(row, rawCol, bytes);
    }

    @Override
    public void delete(int row, int rawCol, int rawLen) {
        this.pt.delete(this.index.get(row) + (long)(rawCol += row == 0 ? this.bom.length : 0), rawLen);
        this.index.delete(row, rawCol, rawLen);
    }

    @Override
    public byte[] get(int row, int rawCol, int rawLen) {
        return this.pt.get(this.index.get(row) + (long)(rawCol += row == 0 ? this.bom.length : 0), rawLen);
    }

    @Override
    public byte[] get(int row) {
        long col = this.index.get(row);
        int len = Math.toIntExact(this.index.get(row + 1) - (col += row == 0 ? (long)this.bom.length : 0L));
        return this.pt.get(col, len);
    }

    @Override
    public CharSequence getText(int row, int rawCol, int rawLen) {
        return new String(this.get(row, rawCol, rawLen), this.charset);
    }

    @Override
    public List<Found> findAll(CharSequence cs) {
        return this.search(cs, 0, 0, Short.MAX_VALUE);
    }

    @Override
    public Optional<Found> findNext(CharSequence cs, int row, int col) {
        col = this.getText(row).toString().substring(0, col).getBytes().length;
        return this.search(cs, row, col, Short.MAX_VALUE).stream().findFirst();
    }

    @Override
    public int rows() {
        return this.index.rowSize();
    }

    @Override
    public long rawSize() {
        return this.pt.length() - (long)this.bom.length;
    }

    @Override
    public Charset charset() {
        return this.charset;
    }

    @Override
    public Path path() {
        return this.path;
    }

    @Override
    public void save(Path path) {
        this.pt.save(path);
    }

    private List<Found> search(CharSequence cs, int fromRow, int fromCol, int maxFound) {
        ArrayList<Found> founds = new ArrayList<Found>();
        byte[] str = cs.toString().getBytes(this.charset);
        byte first = str[0];
        for (int row = fromRow; row < this.rows(); ++row) {
            int colOffset;
            byte[] value = this.get(row);
            int max = value.length - str.length;
            for (int col = colOffset = row == fromRow ? fromCol : 0; col <= max; ++col) {
                if (value[col] != first) {
                    while (++col <= max && value[col] != first) {
                    }
                }
                if (col > max) continue;
                int j = col + 1;
                int end = j + str.length - 1;
                int k = 1;
                while (j < end && value[j] == str[k]) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                founds.add(new Found(row, col, str.length));
                if (founds.size() >= maxFound) {
                    return founds;
                }
                col += str.length;
            }
        }
        return founds;
    }
}

