/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable;

import com.mammb.code.piecetable.Document;
import com.mammb.code.piecetable.Found;
import com.mammb.code.piecetable.edit.TextEditImpl;
import com.mammb.code.piecetable.text.DocumentImpl;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public interface TextEdit {
    public Pos insert(int var1, int var2, String var3);

    public List<Pos> insert(List<Pos> var1, String var2);

    public String delete(int var1, int var2);

    public String delete(int var1, int var2, int var3);

    public List<Pos> delete(List<Pos> var1);

    public Pos backspace(int var1, int var2);

    public Pos backspace(int var1, int var2, int var3);

    public List<Pos> backspace(List<Pos> var1);

    public Pos replace(int var1, int var2, int var3, String var4);

    default public Pos replace(int startRow, int startCol, int endRow, int endCol, String text) {
        return this.replace(new Pos(startRow, startCol), new Pos(endRow, endCol), text);
    }

    default public Pos replace(Pos start, Pos end, String text) {
        return this.replace(start.row(), start.col(), this.getText(start, end).length() * (int)Math.signum(end.compareTo(start)), text);
    }

    public List<Pos> undo();

    public List<Pos> redo();

    public String getText(int var1);

    public String getText(int var1, int var2);

    default public String getText(int startRow, int startCol, int endRow, int endCol) {
        return this.getText(new Pos(startRow, startCol), new Pos(endRow, endCol));
    }

    public String getText(Pos var1, Pos var2);

    public List<String> getTexts(Pos var1, Pos var2);

    public void flush();

    public void clear();

    public List<Found> findAll(String var1);

    public Optional<Found> findNext(String var1, int var2, int var3);

    public int rows();

    public long rawSize();

    public Charset charset();

    public Path path();

    public void save(Path var1);

    public static TextEdit of() {
        return new TextEditImpl(Document.of());
    }

    public static TextEdit of(Path path) {
        return new TextEditImpl(DocumentImpl.of(path));
    }

    public static TextEdit of(Document document) {
        return new TextEditImpl(document);
    }

    public record Pos(int row, int col) implements Comparable<Pos>
    {
        @Override
        public int compareTo(Pos that) {
            int c = Integer.compare(this.row, that.row);
            return c == 0 ? Integer.compare(this.col, that.col) : c;
        }
    }

    public record Range(Pos from, Pos to) {
    }
}

