/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.core;

import com.mammb.code.piecetable.core.Buffer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public class ChannelBuffer
implements Buffer,
Closeable {
    private static final short PREF_BUF_SIZE = 8192;
    private static final byte[] EMPTY = new byte[0];
    private final SeekableByteChannel ch;
    private final long length;
    private byte[] buffer;
    private long offset;

    private ChannelBuffer(SeekableByteChannel ch) {
        try {
            this.length = ch.size();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.ch = ch;
        this.buffer = EMPTY;
        this.offset = 0L;
    }

    public static ChannelBuffer of(Path path) {
        try {
            return new ChannelBuffer(FileChannel.open(path, StandardOpenOption.READ));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte get(long index) {
        if (index < 0L || index >= this.length) {
            throw new IndexOutOfBoundsException("index[%d], length[%d]".formatted(index, this.length));
        }
        if (this.buffer == EMPTY || index < this.offset || index >= this.offset + (long)this.buffer.length) {
            this.fillBuffer(index, Math.addExact(index, 8192L));
        }
        return this.buffer[Math.toIntExact(index - this.offset)];
    }

    @Override
    public byte[] bytes(long from, long to) {
        if (from < 0L || to > this.length || from > to) {
            throw new IndexOutOfBoundsException("from[%d], to[%d], length[%d]".formatted(from, to, this.length));
        }
        if (this.buffer == EMPTY || from < this.offset || to > this.offset + (long)this.buffer.length) {
            this.fillBuffer(from, to);
            if (this.buffer.length > 0x200000) {
                byte[] ret = this.buffer;
                this.buffer = Arrays.copyOf(this.buffer, 8192);
                return ret;
            }
        }
        return Arrays.copyOfRange(this.buffer, Math.toIntExact(from - this.offset), Math.toIntExact(to - this.offset));
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    private void fillBuffer(long from, long to) {
        try {
            ByteBuffer bb = ByteBuffer.allocate(Math.toIntExact(Math.max(to - from, 8192L)));
            this.ch.position(from);
            this.ch.read(bb);
            bb.flip();
            this.buffer = Arrays.copyOf(bb.array(), bb.limit());
            this.offset = from;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

