/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.core;

import com.mammb.code.piecetable.PieceTable;
import com.mammb.code.piecetable.core.AppendBuffer;
import com.mammb.code.piecetable.core.ByteArray;
import com.mammb.code.piecetable.core.ChannelBuffer;
import com.mammb.code.piecetable.core.Piece;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

public class PieceTableImpl
implements PieceTable {
    private final AppendBuffer appendBuffer = AppendBuffer.of();
    private final List<Piece> pieces = new ArrayList<Piece>();
    private final TreeMap<Long, PiecePoint> indices = new TreeMap();
    private long length = 0L;

    PieceTableImpl(Piece initial) {
        if (initial != null) {
            this.pieces.add(initial);
            this.length = initial.length();
        }
    }

    public static PieceTableImpl of() {
        return new PieceTableImpl(null);
    }

    public static PieceTableImpl of(Path path) {
        ChannelBuffer cb = ChannelBuffer.of(path);
        return new PieceTableImpl(new Piece(cb, 0L, cb.length()));
    }

    @Override
    public void insert(long pos, byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        if (pos < 0L || pos > this.length) {
            throw new IndexOutOfBoundsException("pos[%d], length[%d]".formatted(pos, this.length));
        }
        Piece newPiece = new Piece(this.appendBuffer, this.appendBuffer.length(), bytes.length);
        this.appendBuffer.append(bytes);
        PiecePoint point = this.at(pos);
        if (point == null) {
            this.pieces.add(newPiece);
        } else if (point.position == pos) {
            this.pieces.add(point.tableIndex, newPiece);
            this.indices.tailMap(point.position).clear();
        } else {
            Piece[] splits = point.piece.split(pos - point.position());
            this.pieces.remove(point.tableIndex);
            this.pieces.addAll(point.tableIndex, List.of(splits[0], newPiece, splits[1]));
            this.indices.tailMap(point.position).clear();
        }
        this.length += (long)bytes.length;
    }

    @Override
    public void delete(long pos, int len) {
        if (len <= 0) {
            return;
        }
        if (pos < 0L || pos >= this.length) {
            throw new IndexOutOfBoundsException("pos[%d], length[%d]".formatted(pos, this.length));
        }
        PiecePoint[] range = this.range(pos, pos + (long)len - 1L);
        for (int i = range.length - 1; i >= 0; --i) {
            this.pieces.remove(range[i].tableIndex);
        }
        PiecePoint from = range[0];
        this.indices.tailMap(from.position).clear();
        PiecePoint to = range[range.length - 1];
        if (to.endPosition() != pos + (long)len) {
            this.pieces.add(from.tableIndex, to.piece.split(pos + (long)len - to.position)[1]);
        }
        if (from.position != pos) {
            this.pieces.add(from.tableIndex, from.piece.split(pos - from.position)[0]);
        }
        this.length -= (long)len;
    }

    @Override
    public byte[] get(long pos, int len) {
        if (len <= 0) {
            return new byte[0];
        }
        PiecePoint[] range = this.range(pos, pos + (long)len - 1L);
        if (range.length == 0) {
            return new byte[0];
        }
        byte[] ret = new byte[len];
        int start = Math.toIntExact(pos - range[0].position);
        int destPos = 0;
        for (PiecePoint pp : range) {
            Piece piece = pp.piece();
            int length = piece.length() >= (long)(start + len) ? len : Math.toIntExact(piece.length()) - start;
            byte[] bytes = piece.bytes(start, length);
            System.arraycopy(bytes, 0, ret, destPos, bytes.length);
            start = 0;
            destPos += bytes.length;
            len -= bytes.length;
        }
        return ret;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void save(Path path) {
        this.write(path);
        this.pieces.clear();
        this.appendBuffer.clear();
        this.indices.clear();
        ChannelBuffer cb = ChannelBuffer.of(path);
        this.pieces.add(new Piece(cb, 0L, cb.length()));
        this.length = cb.length();
    }

    public byte[] bytes() {
        ByteArray bytes = ByteArray.of();
        for (Piece piece : this.pieces) {
            bytes.add(piece.bytes());
        }
        return bytes.get();
    }

    private void write(Path path) {
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            ByteBuffer buf = ByteBuffer.allocateDirect(Math.toIntExact(Math.min(this.length, 65536L)));
            long size = 0L;
            for (Piece piece : this.pieces) {
                size += piece.writeTo(channel, buf);
            }
            channel.truncate(size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private PiecePoint at(long pos) {
        PiecePoint piecePoint = Optional.ofNullable(this.indices.floorEntry(pos)).map(Map.Entry::getValue).orElse(null);
        if (piecePoint == null) {
            return this.fillToIndices(pos, 0L, 0);
        }
        if (piecePoint.contains(pos)) {
            return piecePoint;
        }
        return this.fillToIndices(pos, piecePoint.endPosition(), piecePoint.tableIndex() + 1);
    }

    private PiecePoint[] range(long startPos, long endPos) {
        PiecePoint pp = this.at(startPos);
        PiecePoint to = this.at(endPos);
        PiecePoint[] org = new PiecePoint[to.tableIndex - pp.tableIndex + 1];
        org[0] = pp;
        for (int i = 1; i < org.length; ++i) {
            org[i] = pp = this.at(pp.endPosition());
        }
        return org;
    }

    public void gc() {
        ArrayList<Piece> dest = new ArrayList<Piece>(this.pieces.size());
        Piece prev = null;
        for (Piece piece : this.pieces) {
            if (prev == null) {
                prev = piece;
                continue;
            }
            if (prev.target() == piece.target() && prev.end() == piece.bufIndex()) {
                prev = new Piece(prev.target(), prev.bufIndex(), prev.length() + piece.length());
                continue;
            }
            dest.add(prev);
            prev = piece;
        }
        if (prev != null) {
            dest.add(prev);
        }
        this.pieces.clear();
        this.pieces.addAll(dest);
        this.indices.clear();
    }

    private PiecePoint fillToIndices(long pos, long piecePosition, int tableIndex) {
        for (int i = tableIndex; i < this.pieces.size(); ++i) {
            Piece piece = this.pieces.get(i);
            PiecePoint piecePoint = new PiecePoint(piecePosition, i, piece);
            this.indices.put(piecePoint.position, piecePoint);
            if (piecePoint.contains(pos)) {
                return piecePoint;
            }
            piecePosition += piece.length();
        }
        return null;
    }

    record PiecePoint(Long position, int tableIndex, Piece piece) {
        public long endPosition() {
            return this.position + this.piece.length();
        }

        public boolean contains(long pos) {
            return this.position <= pos && pos < this.endPosition();
        }
    }
}

