/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.edit;

import com.mammb.code.piecetable.TextEdit;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

sealed interface Edit {
    public long occurredOn();

    default public Edit flip() {
        Edit edit = this;
        Objects.requireNonNull(edit);
        Edit edit2 = edit;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ins.class, Del.class, Cmp.class}, (Object)edit2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Ins e = (Ins)edit2;
                yield new Del(e.to, e.from, e.text, e.occurredOn);
            }
            case 1 -> {
                Del e = (Del)edit2;
                yield new Ins(e.to, e.from, e.text, e.occurredOn);
            }
            case 2 -> {
                Cmp e = (Cmp)edit2;
                List flipped = e.edits.stream().map(Edit::flip).map(ConcreteEdit.class::cast).collect(Collectors.toList());
                Collections.reverse(flipped);
                yield new Cmp(flipped, e.occurredOn);
            }
        };
    }

    default public Optional<Edit> merge(Edit that) {
        Optional<Edit> optional;
        Edit edit = this;
        Objects.requireNonNull(edit);
        Edit edit2 = edit;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ins.class, Del.class}, (Object)edit2, n)) {
                case 0: {
                    Ins t;
                    Ins e = (Ins)edit2;
                    if (!(that instanceof Ins) || !Edit.nearly(e, t = (Ins)that)) {
                        n = 1;
                        continue block4;
                    }
                    String text = e.forward() ? e.text + t.text : t.text + e.text;
                    optional = Optional.of(new Ins(e.from, t.to, text, t.occurredOn));
                    break block4;
                }
                case 1: {
                    Del t;
                    Del e = (Del)edit2;
                    if (!(that instanceof Del) || !Edit.nearly(e, t = (Del)that)) {
                        n = 2;
                        continue block4;
                    }
                    String text = e.backward() ? t.text + e.text : e.text + t.text;
                    optional = Optional.of(new Del(e.from, t.to, text, t.occurredOn));
                    break block4;
                }
                default: {
                    optional = Optional.empty();
                    break block4;
                }
            }
            break;
        }
        return optional;
    }

    private static boolean nearly(ConcreteEdit e1, ConcreteEdit e2) {
        return e1.occurredOn() - e2.occurredOn() < 2500L && !e1.text().contains("\n") && !e2.text().contains("\n") && e1.from().row() == e2.from().row() && e1.to().col() == e2.from().col() && e1.forward() == e2.forward();
    }

    public record Ins(TextEdit.Pos from, TextEdit.Pos to, String text, long occurredOn) implements ConcreteEdit
    {
        public Ins(TextEdit.Pos from, TextEdit.Pos to, String text) {
            this(from, to, text, System.currentTimeMillis());
        }
    }

    public record Del(TextEdit.Pos from, TextEdit.Pos to, String text, long occurredOn) implements ConcreteEdit
    {
        public Del(TextEdit.Pos from, TextEdit.Pos to, String text) {
            this(from, to, text, System.currentTimeMillis());
        }

        public Del(TextEdit.Pos pos, String text, long occurredOn) {
            this(pos, pos, text, System.currentTimeMillis());
        }
    }

    public record Cmp(List<? extends ConcreteEdit> edits, long occurredOn) implements Edit
    {
    }

    public static sealed interface ConcreteEdit
    extends Edit
    permits Ins, Del {
        public TextEdit.Pos from();

        public TextEdit.Pos to();

        public String text();

        default public boolean forward() {
            return this.from().row() < this.to().row() || this.from().row() == this.to().row() && this.from().col() < this.to().col();
        }

        default public boolean backward() {
            return this.from().row() > this.to().row() || this.from().row() == this.to().row() && this.from().col() > this.to().col();
        }

        default public TextEdit.Pos min() {
            return this.backward() ? this.to() : this.from();
        }
    }
}

