/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.edit;

import com.mammb.code.piecetable.Document;
import com.mammb.code.piecetable.Found;
import com.mammb.code.piecetable.TextEdit;
import com.mammb.code.piecetable.edit.Edit;
import com.mammb.code.piecetable.edit.Texts;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TextEditImpl
implements TextEdit {
    private final Deque<Edit> deque = new ArrayDeque<Edit>();
    private final Deque<Edit> undo = new ArrayDeque<Edit>();
    private final Deque<Edit> redo = new ArrayDeque<Edit>();
    private final Map<Integer, String> dryBuffer = new HashMap<Integer, String>();
    private final Document doc;

    public TextEditImpl(Document doc) {
        this.doc = doc;
    }

    @Override
    public TextEdit.Pos insert(int row, int col, String text) {
        if (text.isEmpty()) {
            return new TextEdit.Pos(row, col);
        }
        Edit.Ins edit = this.insertEdit(row, col, text, System.currentTimeMillis());
        this.push(edit);
        return edit.to();
    }

    @Override
    public List<TextEdit.Pos> insert(List<TextEdit.Pos> posList, String text) {
        long occurredOn = System.currentTimeMillis();
        ArrayList<Edit.Ins> edits = new ArrayList<Edit.Ins>();
        List<String> lines = Texts.splitRowBreak(text);
        Edit.ConcreteEdit prevEdit = null;
        TextEdit.Pos prevPos = null;
        int piledRow = 0;
        int piledCol = 0;
        for (TextEdit.Pos pos : posList.stream().sorted().distinct().toList()) {
            int row = pos.row();
            int col = pos.col();
            if (prevEdit != null && prevEdit.from().row() != prevEdit.to().row() && prevEdit.to().row() == (row += piledRow)) {
                piledCol -= prevPos.col();
            } else if (prevEdit != null && prevEdit.to().row() != row) {
                piledCol = 0;
            }
            Edit.Ins edit = this.insertEdit(row, col += piledCol, text, occurredOn);
            edits.add(edit);
            prevEdit = edit;
            prevPos = pos;
            piledRow += lines.size() - 1;
            piledCol = lines.size() > 1 ? lines.getLast().length() : piledCol + lines.getFirst().length();
        }
        Edit.Cmp edit = new Edit.Cmp(edits, occurredOn);
        this.push(edit);
        return edits.stream().map(e -> new TextEdit.Pos(e.to().row(), e.to().col())).toList();
    }

    @Override
    public String delete(int row, int col) {
        return this.deleteChar(row, col, 1);
    }

    @Override
    public String delete(int row, int col, int len) {
        String del = Texts.join(this.textRightByte(row, col, len));
        Edit.Del edit = this.deleteEdit(row, col, del, System.currentTimeMillis());
        this.push(edit);
        return edit.text();
    }

    @Override
    public List<TextEdit.Pos> delete(List<TextEdit.Pos> posList) {
        return this.deleteChar(posList, 1);
    }

    private String deleteChar(int row, int col, int chCount) {
        String del = Texts.join(this.textRight(row, col, chCount));
        Edit.Del edit = this.deleteEdit(row, col, del, System.currentTimeMillis());
        this.push(edit);
        return edit.text();
    }

    List<TextEdit.Pos> deleteChar(List<TextEdit.Pos> posList, int chCount) {
        long occurredOn = System.currentTimeMillis();
        ArrayList<Edit.Del> edits = new ArrayList<Edit.Del>();
        Edit.ConcreteEdit prevEdit = null;
        int piledRow = 0;
        int piledCol = 0;
        for (TextEdit.Pos pos : posList.stream().sorted().distinct().toList()) {
            int row = pos.row();
            int col = pos.col();
            List<String> lines = this.textRight(row, col, chCount);
            if (prevEdit != null && Texts.countRowBreak(prevEdit.text()) > 0 && prevEdit.from().row() == (row -= piledRow)) {
                piledCol = -(prevEdit.to().col() - Texts.splitRowBreak(prevEdit.text()).getLast().length());
            } else if (prevEdit != null && prevEdit.from().row() != row) {
                piledCol = 0;
            }
            Edit.Del edit = this.deleteEdit(row, col -= piledCol, Texts.join(lines), occurredOn);
            edits.add(edit);
            prevEdit = edit;
            piledRow += Texts.countRowBreak(edit.text());
            piledCol += lines.getLast().length();
        }
        Edit.Cmp edit = new Edit.Cmp(edits, occurredOn);
        this.push(edit);
        return edits.stream().map(e -> new TextEdit.Pos(e.to().row(), e.to().col())).toList();
    }

    @Override
    public TextEdit.Pos backspace(int row, int col) {
        return this.backspaceChar(row, col, 1);
    }

    @Override
    public TextEdit.Pos backspace(int row, int col, int len) {
        String del = Texts.join(this.textLeftByte(row, col, len));
        Edit.Del edit = this.backspaceEdit(row, col, del, System.currentTimeMillis());
        this.push(edit);
        return edit.to();
    }

    @Override
    public List<TextEdit.Pos> backspace(List<TextEdit.Pos> posList) {
        return this.backspaceChar(posList, 1);
    }

    TextEdit.Pos backspaceChar(int row, int col, int chCount) {
        String del = Texts.join(this.textLeft(row, col, chCount));
        Edit.Del edit = this.backspaceEdit(row, col, del, System.currentTimeMillis());
        this.push(edit);
        return edit.to();
    }

    List<TextEdit.Pos> backspaceChar(List<TextEdit.Pos> posList, int chCount) {
        long occurredOn = System.currentTimeMillis();
        ArrayList<Edit.Del> edits = new ArrayList<Edit.Del>();
        for (TextEdit.Pos pos : posList.stream().sorted(Comparator.reverseOrder()).distinct().toList()) {
            List<String> lines = this.textLeft(pos.row(), pos.col(), chCount);
            Edit.Del del = this.backspaceEdit(pos.row(), pos.col(), Texts.join(lines), occurredOn);
            edits.add(del);
        }
        Edit.Cmp edit = new Edit.Cmp(edits, occurredOn);
        this.push(edit);
        Edit.ConcreteEdit prevEdit = (Edit.ConcreteEdit)edits.getLast();
        int piledRow = 0;
        int piledCol = 0;
        ArrayList<TextEdit.Pos> ret = new ArrayList<TextEdit.Pos>();
        for (Edit.ConcreteEdit e : edits.stream().sorted(Comparator.comparing(Edit.ConcreteEdit::to)).toList()) {
            int row = e.to().row();
            int col = e.to().col();
            if (prevEdit.to().row() != prevEdit.from().row() && prevEdit.from().row() == row) {
                piledCol -= prevEdit.to().col();
            } else if (row != prevEdit.from().row()) {
                piledCol = 0;
            }
            ret.add(new TextEdit.Pos(row -= piledRow, col -= piledCol));
            prevEdit = e;
            piledRow += Texts.countRowBreak(e.text());
            piledCol += Texts.splitRowBreak(e.text()).getLast().length();
        }
        return ret;
    }

    @Override
    public TextEdit.Pos replace(int row, int col, int len, String text) {
        TextEdit.Pos pos;
        Edit.Cmp e;
        if (len == 0) {
            return this.insert(row, col, text);
        }
        long occurredOn = System.currentTimeMillis();
        if (len > 0) {
            String delText = Texts.join(this.textRightByte(row, col, len));
            Edit.Del del = this.deleteEdit(row, col, delText, occurredOn);
            Edit.Ins ins = this.insertEdit(row, col, text, occurredOn);
            e = new Edit.Cmp(List.of(del, ins), occurredOn);
            pos = ins.to();
        } else {
            String delText = Texts.join(this.textLeftByte(row, col, -len));
            Edit.Del bs = this.backspaceEdit(row, col, delText, occurredOn);
            Edit.Ins ins = this.insertEdit(bs.to().row(), bs.to().col(), text, occurredOn);
            e = new Edit.Cmp(List.of(bs, ins), occurredOn);
            pos = ins.to();
        }
        this.push(e);
        return pos;
    }

    @Override
    public List<TextEdit.Pos> undo() {
        this.flush();
        Optional<Edit> undo = this.undoEdit();
        if (undo.isEmpty()) {
            return List.of();
        }
        Edit edit = undo.get();
        Objects.requireNonNull(edit);
        Edit edit2 = edit;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.ConcreteEdit.class, Edit.Cmp.class}, (Object)edit2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Edit.ConcreteEdit e = (Edit.ConcreteEdit)edit2;
                yield List.of(e.to());
            }
            case 1 -> {
                Edit.Cmp e = (Edit.Cmp)edit2;
                yield List.of(e.edits().getLast().to());
            }
        };
    }

    @Override
    public List<TextEdit.Pos> redo() {
        this.flush();
        Optional<Edit> redo = this.redoEdit();
        if (redo.isEmpty()) {
            return List.of();
        }
        Edit edit = redo.get();
        Objects.requireNonNull(edit);
        Edit edit2 = edit;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.ConcreteEdit.class, Edit.Cmp.class}, (Object)edit2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Edit.ConcreteEdit e = (Edit.ConcreteEdit)edit2;
                yield List.of(e.to());
            }
            case 1 -> {
                Edit.Cmp e = (Edit.Cmp)edit2;
                yield List.of(e.edits().getLast().to());
            }
        };
    }

    @Override
    public String getText(int row) {
        if (!this.deque.isEmpty() && this.dryBuffer.isEmpty()) {
            this.dryApply();
        }
        if (this.dryBuffer.containsKey(row)) {
            return this.dryBuffer.get(row);
        }
        return this.doc.getText(row).toString();
    }

    @Override
    public String getText(int fromRow, int endRowExclusive) {
        return IntStream.range(fromRow, endRowExclusive).mapToObj(this::getText).collect(Collectors.joining());
    }

    @Override
    public String getText(TextEdit.Pos start, TextEdit.Pos end) {
        if (end.compareTo(start) < 0) {
            TextEdit.Pos temp = start;
            start = end;
            end = temp;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start.row(); i <= end.row(); ++i) {
            String row = this.getText(i);
            row = i == end.row() ? row.substring(0, end.col()) : row;
            row = i == start.row() ? row.substring(start.col()) : row;
            sb.append(row);
        }
        return sb.toString();
    }

    @Override
    public List<String> getTexts(TextEdit.Pos start, TextEdit.Pos end) {
        if (end.compareTo(start) < 0) {
            TextEdit.Pos temp = start;
            start = end;
            end = temp;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = start.row(); i <= end.row(); ++i) {
            String row = this.getText(i);
            row = i == end.row() ? row.substring(0, end.col()) : row;
            row = i == start.row() ? row.substring(start.col()) : row;
            list.add(row);
        }
        return list;
    }

    @Override
    public void flush() {
        while (!this.deque.isEmpty()) {
            Edit edit = this.deque.pop();
            this.apply(edit);
            this.undo.push(edit.flip());
            this.redo.clear();
        }
        this.dryBuffer.clear();
    }

    @Override
    public void clear() {
        this.flush();
        this.undo.clear();
        this.redo.clear();
    }

    @Override
    public List<Found> findAll(String text) {
        this.flush();
        return this.doc.findAll(text);
    }

    @Override
    public Optional<Found> findNext(String text, int row, int col) {
        this.flush();
        return this.doc.findNext(text, row, col);
    }

    @Override
    public int rows() {
        return this.doc.rows();
    }

    @Override
    public long rawSize() {
        this.flush();
        return this.doc.rawSize();
    }

    @Override
    public Charset charset() {
        return this.doc.charset();
    }

    @Override
    public Path path() {
        return this.doc.path();
    }

    @Override
    public void save(Path path) {
        this.flush();
        this.doc.save(path);
    }

    Edit.Ins insertEdit(int row, int col, String text, long occurredOn) {
        int index = text.lastIndexOf(10);
        if (index < 0) {
            return new Edit.Ins(new TextEdit.Pos(row, col), new TextEdit.Pos(row, col + text.length()), text, occurredOn);
        }
        int nRow = row + (int)text.chars().mapToLong(c -> c == 10 ? 1L : 0L).sum();
        int nCol = text.substring(index + 1).length();
        return new Edit.Ins(new TextEdit.Pos(row, col), new TextEdit.Pos(nRow, nCol), text, occurredOn);
    }

    Edit.Del deleteEdit(int row, int col, String text, long occurredOn) {
        return new Edit.Del(new TextEdit.Pos(row, col), text, occurredOn);
    }

    Edit.Del backspaceEdit(int row, int col, String text, long occurredOn) {
        int newRow = row - Texts.countRowBreak(text);
        int newCol = row == newRow ? col - text.length() : this.getText(newRow).length() - (text.indexOf(10) + 1);
        return new Edit.Del(new TextEdit.Pos(row, col), new TextEdit.Pos(newRow, newCol), text, occurredOn);
    }

    private void push(Edit edit) {
        Optional<Edit> merged;
        Edit last = this.deque.peekLast();
        if (last != null && (merged = last.merge(edit)).isPresent()) {
            this.deque.removeLast();
            this.flush();
            this.deque.push(merged.get());
            return;
        }
        this.flush();
        this.deque.push(edit);
        Edit edit2 = edit;
        Objects.requireNonNull(edit2);
        Edit edit3 = edit2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.ConcreteEdit.class, Edit.Cmp.class}, (Object)edit3, n)) {
                case 0: {
                    Edit.ConcreteEdit e = (Edit.ConcreteEdit)edit3;
                    if (!e.text().contains("\n")) {
                        n = 1;
                        continue block4;
                    }
                    this.flush();
                    break block4;
                }
                case 1: {
                    Edit.Cmp e = (Edit.Cmp)edit3;
                    if (!e.edits().stream().map(Edit.ConcreteEdit::text).anyMatch(s -> s.contains("\n"))) {
                        n = 2;
                        continue block4;
                    }
                    this.flush();
                    break block4;
                }
            }
            break;
        }
    }

    private Optional<Edit> undoEdit() {
        this.flush();
        if (this.undo.isEmpty()) {
            return Optional.empty();
        }
        Edit edit = this.undo.pop();
        this.apply(edit);
        this.redo.push(edit.flip());
        return Optional.of(edit);
    }

    private Optional<Edit> redoEdit() {
        this.flush();
        if (this.redo.isEmpty()) {
            return Optional.empty();
        }
        Edit edit = this.redo.pop();
        this.apply(edit);
        this.undo.push(edit.flip());
        return Optional.of(edit);
    }

    private void apply(Edit edit) {
        Edit edit2 = edit;
        Objects.requireNonNull(edit2);
        Edit edit3 = edit2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.Ins.class, Edit.Del.class, Edit.Cmp.class}, (Object)edit3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Edit.Ins e = (Edit.Ins)edit3;
                this.doc.insert(e.min().row(), e.min().col(), e.text());
                break;
            }
            case 1: {
                Edit.Del e = (Edit.Del)edit3;
                this.doc.delete(e.min().row(), e.min().col(), e.text());
                break;
            }
            case 2: {
                Edit.Cmp e = (Edit.Cmp)edit3;
                e.edits().forEach(this::apply);
            }
        }
    }

    private void dryApply() {
        this.dryBuffer.clear();
        this.deque.forEach(this::dryApply);
    }

    private void dryApply(Edit edit) {
        Edit edit2 = edit;
        Objects.requireNonNull(edit2);
        Edit edit3 = edit2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Edit.Ins.class, Edit.Del.class, Edit.Cmp.class}, (Object)edit3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Edit.Ins e = (Edit.Ins)edit3;
                Object row = this.dryBuffer.get(e.from().row());
                if (row == null) {
                    row = this.doc.getText(e.from().row()).toString();
                }
                row = ((String)row).substring(0, e.min().col()) + e.text() + ((String)row).substring(e.min().col());
                this.dryBuffer.put(e.from().row(), (String)row);
                break;
            }
            case 1: {
                Edit.Del e = (Edit.Del)edit3;
                Object row = this.dryBuffer.get(e.from().row());
                if (row == null) {
                    row = this.doc.getText(e.from().row()).toString();
                }
                row = ((String)row).substring(0, e.min().col()) + ((String)row).substring(e.min().col() + e.text().length());
                this.dryBuffer.put(e.from().row(), (String)row);
                break;
            }
            case 2: {
                Edit.Cmp e = (Edit.Cmp)edit3;
                e.edits().forEach(this::dryApply);
            }
        }
    }

    List<String> textRight(int row, int col, int chLen) {
        String text;
        ArrayList<String> ret = new ArrayList<String>();
        int i = row;
        while (!(text = this.getText(i).substring(col)).isEmpty()) {
            int len = Texts.chLength(text);
            if (chLen - len <= 0) {
                String left = Texts.left(text, chLen);
                ret.add(left);
                break;
            }
            ret.add(text);
            chLen -= len;
            col = 0;
            ++i;
        }
        if (!ret.isEmpty() && ((String)ret.getLast()).endsWith("\n")) {
            ret.add("");
        }
        return ret;
    }

    List<String> textLeft(int row, int col, int chLen) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = row; i >= 0; --i) {
            String s = this.getText(i);
            String text = i == row ? s.substring(0, col) : s;
            int len = Texts.chLength(text);
            if (chLen - len <= 0) {
                ret.addFirst(Texts.right(text, chLen));
                break;
            }
            ret.addFirst(text);
            chLen -= len;
        }
        return ret;
    }

    List<String> textRightByte(int row, int col, int byteLen) {
        String text;
        ArrayList<String> ret = new ArrayList<String>();
        int i = row;
        while (!(text = this.getText(i).substring(col)).isEmpty()) {
            int len = text.length();
            if (byteLen - len <= 0) {
                ret.add(text.substring(0, byteLen));
                break;
            }
            ret.add(text);
            byteLen -= len;
            col = 0;
            ++i;
        }
        if (!ret.isEmpty() && ((String)ret.getLast()).endsWith("\n")) {
            ret.add("");
        }
        return ret;
    }

    List<String> textLeftByte(int row, int col, int byteLen) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = row; i >= 0; --i) {
            String s = this.getText(i);
            String text = col > 0 ? s.substring(0, col) : s;
            int len = text.length();
            if (byteLen - len <= 0) {
                ret.addFirst(text.substring(len - byteLen));
                break;
            }
            ret.addFirst(text);
            byteLen -= len;
            col = 0;
        }
        return ret;
    }

    Document getDoc() {
        return this.doc;
    }

    Map<Integer, String> getDryBuffer() {
        return this.dryBuffer;
    }

    Deque<Edit> getDeque() {
        return this.deque;
    }

    Deque<Edit> getUndo() {
        return this.undo;
    }

    Deque<Edit> getRedo() {
        return this.redo;
    }

    void testPush(Edit edit) {
        this.push(edit);
    }

    void testDryApply() {
        this.dryApply();
    }

    void testDryApply(Edit edit) {
        this.dryApply(edit);
    }

    int[] distances(List<TextEdit.Pos> poss) {
        int distance = 0;
        int index = 0;
        int[] ret = new int[poss.size()];
        TextEdit.Pos pos = poss.get(index);
        for (int i = poss.getFirst().row(); i <= poss.getLast().row(); ++i) {
            String rowText = this.getText(i);
            while (pos.row() == i) {
                ret[index++] = distance + pos.col();
                if (index >= poss.size()) break;
                pos = poss.get(index);
            }
            distance += rowText.length();
        }
        return ret;
    }

    List<TextEdit.Pos> posList(int row, int[] distances) {
        String rowText;
        ArrayList<TextEdit.Pos> poss = new ArrayList<TextEdit.Pos>();
        int total = 0;
        int index = 0;
        int i = row;
        while (index < distances.length && !(rowText = this.getText(i)).isEmpty()) {
            while (total + rowText.length() >= distances[index]) {
                poss.add(new TextEdit.Pos(i, distances[index] - total));
                if (++index < distances.length) continue;
            }
            total += rowText.length();
            ++i;
        }
        return poss;
    }
}

