/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.text;

import com.mammb.code.piecetable.CharsetMatch;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public abstract class CharsetMatches {
    private CharsetMatches() {
    }

    static CharsetMatch utf8() {
        return new Utf8Match();
    }

    static CharsetMatch ms932() {
        return new Ms932Match();
    }

    private static int clamp(int value) {
        return Math.min(100, Math.max(value, 0));
    }

    private static class Utf8Match
    implements CharsetMatch {
        private int confidence = 50;
        private int trail = 0;
        private int miss = 0;

        private Utf8Match() {
        }

        @Override
        public CharsetMatch.Result put(byte[] bytes) {
            block0: for (int i = 0; i < bytes.length && this.confidence > 0 && this.confidence < 100; ++i) {
                byte b;
                if (this.trail == 0) {
                    b = bytes[i];
                    this.trail = this.trail(b);
                    if (this.trail == -1) {
                        this.confidence = CharsetMatches.clamp(--this.confidence);
                        ++this.miss;
                    }
                    if (this.trail <= 0) continue;
                }
                while (++i < bytes.length) {
                    b = bytes[i];
                    if ((b & 0xC0) != 128) {
                        this.confidence = CharsetMatches.clamp(--this.confidence);
                        ++this.miss;
                        this.trail = 0;
                        continue block0;
                    }
                    if (--this.trail != 0) continue;
                    this.confidence = CharsetMatches.clamp(++this.confidence);
                    continue block0;
                }
            }
            return new CharsetMatch.Result(StandardCharsets.UTF_8, CharsetMatches.clamp(this.confidence - this.miss));
        }

        private int trail(byte b) {
            if ((b & 0x80) == 0) {
                return 0;
            }
            if ((b & 0xE0) == 192) {
                return 1;
            }
            if ((b & 0xF0) == 224) {
                return 2;
            }
            if ((b & 0xF8) == 240) {
                return 3;
            }
            System.out.println(Byte.toString(b));
            return -1;
        }
    }

    private static class Ms932Match
    implements CharsetMatch {
        private int confidence = 50;
        private int trail = 0;
        private int miss = 0;

        private Ms932Match() {
        }

        @Override
        public CharsetMatch.Result put(byte[] bytes) {
            for (int i = 0; i < bytes.length; ++i) {
                int s;
                int b = Byte.toUnsignedInt(bytes[i]);
                if (b == 128 || b == 160 || b >= 253) {
                    this.confidence = CharsetMatches.clamp(--this.confidence);
                    ++this.miss;
                    continue;
                }
                if ((129 > b || b > 159) && b < 224) continue;
                this.trail = 1;
                if (i + 1 >= bytes.length) break;
                if (64 <= (s = Byte.toUnsignedInt(bytes[++i])) && s <= 126 || 128 <= s && s <= 252) {
                    this.confidence = CharsetMatches.clamp(++this.confidence);
                } else {
                    this.confidence = CharsetMatches.clamp(--this.confidence);
                    ++this.miss;
                }
                this.trail = 0;
            }
            return new CharsetMatch.Result(Charset.forName("windows-31j"), CharsetMatches.clamp(this.confidence - this.miss));
        }
    }
}

