/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.text;

import java.io.Serializable;
import java.util.Arrays;

public class IntArray
implements Serializable {
    private static final int[] EMPTY = new int[0];
    private int[] ints;
    private int length;

    private IntArray(int[] ints, int length) {
        this.ints = ints;
        this.length = length;
    }

    public static IntArray of() {
        return new IntArray(EMPTY, 0);
    }

    public static IntArray of(int initialCapacity) {
        return new IntArray(new int[initialCapacity], 0);
    }

    public static IntArray of(int[] values) {
        return new IntArray(Arrays.copyOf(values, values.length), values.length);
    }

    public void add(int value) {
        if (this.length == this.ints.length) {
            this.ints = this.grow(this.length + 1);
        }
        this.ints[this.length++] = value;
    }

    public void add(int[] values) {
        if (this.length + values.length > this.ints.length) {
            this.ints = this.grow(this.length + values.length);
        }
        System.arraycopy(values, 0, this.ints, this.length, values.length);
        this.length += values.length;
    }

    public int get(int index) {
        return this.ints[index];
    }

    public int[] get() {
        return Arrays.copyOf(this.ints, this.length);
    }

    public void clear() {
        this.ints = EMPTY;
        this.length = 0;
    }

    public int length() {
        return this.length;
    }

    public int capacity() {
        return this.ints.length;
    }

    private int[] grow(int minCapacity) {
        int oldCapacity = this.ints.length;
        if (oldCapacity > 0 || this.ints != EMPTY) {
            int newCapacity = Math.min(Math.max(minCapacity, oldCapacity + (oldCapacity >> 1)), 0x7FFFFFF7);
            this.ints = Arrays.copyOf(this.ints, newCapacity);
            return this.ints;
        }
        this.ints = new int[Math.max(10, minCapacity)];
        return this.ints;
    }
}

