/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.text;

import com.mammb.code.piecetable.CharsetMatch;
import com.mammb.code.piecetable.text.CharsetMatches;
import com.mammb.code.piecetable.text.RowIndex;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class Reader {
    private final RowIndex index;
    private byte[] bom;
    private Charset charset;
    private long length;
    private final List<CharsetMatch> matches = new ArrayList<CharsetMatch>();

    private Reader(Path path, CharsetMatch ... matches) {
        this.index = RowIndex.of();
        this.matches.addAll(Arrays.asList(matches));
        if (path != null) {
            this.readAll(path);
        }
    }

    public static Reader of(Path path) {
        return new Reader(path, CharsetMatches.utf8(), CharsetMatches.ms932());
    }

    public static Reader of(Path path, Charset charset) {
        return new Reader(path, CharsetMatch.of(charset));
    }

    public static Reader of(Path path, CharsetMatch ... matches) {
        return new Reader(path, matches);
    }

    public RowIndex index() {
        return this.index;
    }

    public Charset charset() {
        return this.charset == null ? StandardCharsets.UTF_8 : this.charset;
    }

    public byte[] bom() {
        return this.bom;
    }

    private void readAll(Path path) {
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            long size = channel.size();
            int cap = 65536;
            ByteBuffer buf = size < (long)cap ? ByteBuffer.allocate((int)size) : ByteBuffer.allocateDirect(cap);
            byte[] bytes = new byte[buf.capacity()];
            while (true) {
                buf.clear();
                int n = channel.read(buf);
                if (n < 0) {
                    break;
                }
                buf.flip();
                byte[] read = this.asBytes(buf, n, bytes);
                if (this.length == 0L) {
                    this.bom = this.checkBom(read);
                }
                if (this.charset == null) {
                    this.charset = this.checkCharset(read);
                }
                this.length += (long)read.length;
                this.index.add(read);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] asBytes(ByteBuffer buf, int nRead, byte[] bytes) {
        if (buf.isDirect()) {
            if (nRead != bytes.length) {
                byte[] rest = new byte[nRead];
                buf.get(rest);
                return rest;
            }
            buf.get(bytes);
            return bytes;
        }
        return Arrays.copyOf(buf.array(), buf.limit());
    }

    private byte[] checkBom(byte[] bytes) {
        if (bytes == null) {
            return new byte[0];
        }
        if (bytes.length >= 3 && (bytes[0] & 0xFF) == 239 && (bytes[1] & 0xFF) == 187 && (bytes[2] & 0xFF) == 191) {
            this.charset = StandardCharsets.UTF_8;
            return new byte[]{bytes[0], bytes[1], bytes[2]};
        }
        if (bytes.length >= 2 && (bytes[0] & 0xFF) == 254 && (bytes[1] & 0xFF) == 255) {
            this.charset = StandardCharsets.UTF_16BE;
            return new byte[]{bytes[0], bytes[1]};
        }
        if (bytes.length >= 4 && (bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 254 && (bytes[2] & 0xFF) == 0 && (bytes[3] & 0xFF) == 0) {
            this.charset = Charset.forName("UTF_32LE");
            return new byte[]{bytes[0], bytes[1], bytes[2], bytes[3]};
        }
        if (bytes.length >= 2 && (bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 254) {
            this.charset = StandardCharsets.UTF_16LE;
            return new byte[]{bytes[0], bytes[1]};
        }
        if (bytes.length >= 4 && (bytes[0] & 0xFF) == 0 && (bytes[1] & 0xFF) == 0 && (bytes[2] & 0xFF) == 254 && (bytes[3] & 0xFF) == 255) {
            this.charset = Charset.forName("UTF_32BE");
            return new byte[]{bytes[0], bytes[1], bytes[2], bytes[3]};
        }
        return new byte[0];
    }

    private Charset checkCharset(byte[] bytes) {
        return this.matches.stream().map(m -> m.put(bytes)).max(Comparator.naturalOrder()).filter(r -> r.confidence() >= 100).map(r -> r.charset()).orElse(null);
    }
}

