/*
 * Decompiled with CFR 0.152.
 */
package com.mammb.code.piecetable.text;

import com.mammb.code.piecetable.text.IntArray;
import java.util.Arrays;

public class RowIndex {
    private int[] rowLengths = new int[]{0};
    private int length = 1;
    private long[] stCache = new long[]{0L};
    private int cacheLength = 1;
    private final int cacheInterval;

    private RowIndex(int cacheInterval) {
        this.cacheInterval = cacheInterval;
    }

    public static RowIndex of() {
        return new RowIndex(100);
    }

    static RowIndex of(int cacheInterval) {
        return new RowIndex(cacheInterval);
    }

    public void add(byte[] bytes) {
        int[] rows = RowIndex.rows(bytes);
        if (rows.length == 0) {
            return;
        }
        if (this.length + rows.length > this.rowLengths.length) {
            this.rowLengths = this.grow(this.length + rows.length);
        }
        if (this.length == 0) {
            ++this.length;
        }
        for (int i = 0; i < rows.length; ++i) {
            int n = this.length - 1;
            this.rowLengths[n] = this.rowLengths[n] + rows[i];
            if (rows.length <= 1 || i >= rows.length - 1) continue;
            ++this.length;
        }
    }

    public long get(int row) {
        int startRow = 0;
        long startPos = 0L;
        int cacheIndex = row / this.cacheInterval;
        if (cacheIndex > 0 && cacheIndex < this.cacheLength) {
            startRow = cacheIndex * this.cacheInterval;
            startPos = this.stCache[cacheIndex];
        }
        for (int i = startRow; i < this.length && i < row; ++i) {
            if (i % this.cacheInterval == 0) {
                if (this.cacheLength + 1 > this.stCache.length) {
                    this.stCache = this.growCache(this.cacheLength + 1);
                }
                int chIndex = i / this.cacheInterval;
                this.stCache[chIndex] = startPos;
                this.cacheLength = chIndex + 1;
            }
            startPos += (long)this.rowLengths[i];
        }
        return startPos;
    }

    public void insert(int row, int col, byte[] bytes) {
        int[] rows = RowIndex.rows(bytes);
        if (rows.length == 0) {
            return;
        }
        if (this.length + rows.length > this.rowLengths.length) {
            this.rowLengths = this.grow(this.length + rows.length);
        }
        this.cacheLength = row / this.cacheInterval;
        if (rows.length == 1) {
            int n = row;
            this.rowLengths[n] = this.rowLengths[n] + rows[0];
        } else {
            int head = col + rows[0];
            int tail = this.rowLengths[row] - col + rows[rows.length - 1];
            System.arraycopy(this.rowLengths, row + 1, this.rowLengths, row + rows.length, this.length - (row + 1));
            this.rowLengths[row] = head;
            System.arraycopy(rows, 1, this.rowLengths, row + 1, rows.length - 1 - 1);
            this.rowLengths[row + rows.length - 1] = tail;
        }
        this.length += rows.length - 1;
    }

    public void delete(int row, int col, int len) {
        if (len <= 0) {
            return;
        }
        this.cacheLength = row / this.cacheInterval;
        if (this.rowLengths[row] - col > len) {
            int n = row;
            this.rowLengths[n] = this.rowLengths[n] - len;
        } else {
            len -= this.rowLengths[row] - col;
            this.rowLengths[row] = col;
            int lines = 0;
            while (row + lines + 1 < this.length && (len -= this.rowLengths[row + ++lines]) >= 0) {
            }
            int n = row;
            this.rowLengths[n] = this.rowLengths[n] + -len;
            if (lines > 0) {
                System.arraycopy(this.rowLengths, row + 1 + lines, this.rowLengths, row + 1, this.length - (row + 1 + lines));
                this.length -= lines;
            }
        }
    }

    public int rowSize() {
        return this.length;
    }

    static int[] rows(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new int[0];
        }
        IntArray intArray = IntArray.of();
        int n = 0;
        for (byte aByte : bytes) {
            ++n;
            if (aByte != 10) continue;
            intArray.add(n);
            n = 0;
        }
        intArray.add(n);
        return intArray.get();
    }

    private int[] grow(int minCapacity) {
        int oldCapacity = this.rowLengths.length;
        if (oldCapacity > 0) {
            int newCapacity = Math.min(Math.max(minCapacity, oldCapacity >> 1), 0x7FFFFFF7);
            this.rowLengths = Arrays.copyOf(this.rowLengths, newCapacity);
            return this.rowLengths;
        }
        this.rowLengths = new int[Math.max(100, minCapacity)];
        return this.rowLengths;
    }

    private long[] growCache(int minCapacity) {
        int oldCapacity = this.stCache.length;
        if (oldCapacity > 0) {
            int newCapacity = Math.min(Math.max(minCapacity, oldCapacity >> 2), 0x7FFFFFF7);
            this.stCache = Arrays.copyOf(this.stCache, newCapacity);
            return this.stCache;
        }
        this.stCache = new long[Math.max(10, minCapacity)];
        return this.stCache;
    }

    int[] rowLengths() {
        return Arrays.copyOf(this.rowLengths, this.length);
    }

    long[] stCache() {
        return Arrays.copyOf(this.stCache, this.cacheLength);
    }
}

