/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.mangofactory.swagger.models.Collections;
import com.mangofactory.swagger.models.ModelContext;
import com.mangofactory.swagger.models.ModelDependencyProvider;
import com.mangofactory.swagger.models.ModelProvider;
import com.mangofactory.swagger.models.ResolvedTypes;
import com.mangofactory.swagger.models.ScalaConverters;
import com.mangofactory.swagger.models.Types;
import com.mangofactory.swagger.models.alternates.AlternateTypeProvider;
import com.mangofactory.swagger.models.property.ModelProperty;
import com.mangofactory.swagger.models.property.provider.ModelPropertiesProvider;
import com.wordnik.swagger.annotations.ApiModel;
import com.wordnik.swagger.model.Model;
import com.wordnik.swagger.model.ModelRef;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import scala.Option;
import scala.collection.JavaConversions;

@Component
public class DefaultModelProvider
implements ModelProvider {
    private final TypeResolver resolver;
    private final AlternateTypeProvider alternateTypeProvider;
    private final ModelPropertiesProvider propertiesProvider;
    private final ModelDependencyProvider dependencyProvider;

    @Autowired
    public DefaultModelProvider(TypeResolver resolver, AlternateTypeProvider alternateTypeProvider, @Qualifier(value="default") ModelPropertiesProvider propertiesProvider, ModelDependencyProvider dependencyProvider) {
        this.resolver = resolver;
        this.alternateTypeProvider = alternateTypeProvider;
        this.propertiesProvider = propertiesProvider;
        this.dependencyProvider = dependencyProvider;
    }

    @Override
    public Optional<Model> modelFor(ModelContext modelContext) {
        ResolvedType propertiesHost = this.alternateTypeProvider.alternateFor(modelContext.resolvedType(this.resolver));
        if (Collections.isContainerType(propertiesHost) || propertiesHost.getErasedType().isEnum() || Types.isBaseType(Types.typeNameFor(propertiesHost.getErasedType()))) {
            return Optional.absent();
        }
        LinkedHashMap properties = Maps.newLinkedHashMap();
        int index = 0;
        for (ModelProperty modelProperty : this.properties(modelContext, propertiesHost)) {
            properties.put(modelProperty.getName(), new com.wordnik.swagger.model.ModelProperty(modelProperty.typeName(modelContext), modelProperty.qualifiedTypeName(), index, modelProperty.isRequired(), modelProperty.propertyDescription(), modelProperty.allowableValues(), this.itemModelRef(modelProperty.getType())));
        }
        return Optional.of((Object)new Model(ResolvedTypes.typeName(propertiesHost), ResolvedTypes.typeName(propertiesHost), ResolvedTypes.simpleQualifiedTypeName(propertiesHost), ScalaConverters.toScalaLinkedHashMap(properties), this.modelDescription(propertiesHost), Option.apply((Object)""), Option.empty(), JavaConversions.collectionAsScalaIterable(new ArrayList()).toList()));
    }

    @Override
    public Map<String, Model> dependencies(ModelContext modelContext) {
        HashMap models = Maps.newHashMap();
        for (ResolvedType resolvedType : this.dependencyProvider.dependentModels(modelContext)) {
            Optional<Model> model = this.modelFor(ModelContext.fromParent(modelContext, resolvedType));
            if (!model.isPresent()) continue;
            models.put(((Model)model.get()).name(), model.get());
        }
        return models;
    }

    private Option<String> modelDescription(ResolvedType type) {
        ApiModel annotation = (ApiModel)AnnotationUtils.findAnnotation((Class)type.getErasedType(), ApiModel.class);
        if (annotation != null) {
            return Option.apply((Object)annotation.description());
        }
        return Option.apply((Object)"");
    }

    private Iterable<? extends ModelProperty> properties(ModelContext context, ResolvedType propertiesHost) {
        if (context.isReturnType()) {
            return this.propertiesProvider.propertiesForSerialization(propertiesHost);
        }
        return this.propertiesProvider.propertiesForDeserialization(propertiesHost);
    }

    private Option<ModelRef> itemModelRef(ResolvedType type) {
        if (!Collections.isContainerType(type)) {
            return Option.empty();
        }
        ResolvedType collectionElementType = Collections.collectionElementType(type);
        String elementTypeName = ResolvedTypes.typeName(collectionElementType);
        String qualifiedElementTypeName = ResolvedTypes.simpleQualifiedTypeName(collectionElementType);
        if (!Types.isBaseType(elementTypeName)) {
            return Option.apply((Object)new ModelRef(null, Option.apply((Object)elementTypeName), Option.apply((Object)qualifiedElementTypeName)));
        }
        return Option.apply((Object)new ModelRef(elementTypeName, Option.empty(), Option.apply((Object)qualifiedElementTypeName)));
    }

    private String id(Type type) {
        return ResolvedTypes.asResolved(this.resolver, type).getErasedType().getSimpleName();
    }
}

