/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.models;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Optional;
import com.wordnik.swagger.annotations.ApiModelProperty;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.ResponseStatus;

public class Annotations {
    public static <A extends Annotation> A findPropertyAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        return (A)((Annotation)Annotations.tryGetGetterAnnotation(beanPropertyDefinition, annotationClass).or(Annotations.tryGetSetterAnnotation(beanPropertyDefinition, annotationClass)).or(Annotations.tryGetFieldAnnotation(beanPropertyDefinition, annotationClass)).orNull());
    }

    private static <A extends Annotation> Optional<A> tryGetGetterAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        try {
            if (beanPropertyDefinition.hasGetter()) {
                return Optional.fromNullable((Object)beanPropertyDefinition.getGetter().getAnnotation(annotationClass));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.absent();
    }

    private static <A extends Annotation> Optional<A> tryGetSetterAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        try {
            if (beanPropertyDefinition.hasSetter()) {
                return Optional.fromNullable((Object)beanPropertyDefinition.getSetter().getAnnotation(annotationClass));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.absent();
    }

    private static <A extends Annotation> Optional<A> tryGetFieldAnnotation(BeanPropertyDefinition beanPropertyDefinition, Class<A> annotationClass) {
        try {
            if (beanPropertyDefinition.hasField()) {
                return Optional.fromNullable((Object)beanPropertyDefinition.getField().getAnnotation(annotationClass));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Optional.absent();
    }

    public static boolean memberIsUnwrapped(AnnotatedMember member) {
        return Optional.fromNullable((Object)member.getAnnotation(JsonUnwrapped.class)).isPresent();
    }

    public static Optional<ApiModelProperty> findApiModePropertyAnnotation(AnnotatedElement annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiModelProperty.class));
    }

    public static Optional<ApiParam> findApiParamAnnotation(AnnotatedElement annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiParam.class));
    }

    public static Optional<ApiResponses> findApiResponsesAnnotations(Method method) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)method, ApiResponses.class));
    }

    public static Optional<ResponseStatus> findResponseStatusAnnotation(Method method) {
        return Optional.fromNullable((Object)AnnotationUtils.findAnnotation((Method)method, ResponseStatus.class));
    }
}

